/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "sort.h"

gint id_compare (GtkCList *clist, gconstpointer s1, gconstpointer s2)
{
   GtkCListRow *row1, *row2;
   gchar *text1, *text2;

   g_return_val_if_fail (clist != NULL, 0);
   g_return_val_if_fail (GTK_IS_CLIST (clist), 0);
   g_return_val_if_fail (s1 != NULL, 0);
   g_return_val_if_fail (s2 != NULL, 0);

   row1 = (GtkCListRow *) s1;
   row2 = (GtkCListRow *) s2;

   text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
   text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

   if (atoi(text1) < atoi(text2))
      return -1;
   if (atoi(text1) > atoi(text2))
      return 1;
   return 0;
}

gint str_compare (GtkCList *clist, gconstpointer s1, gconstpointer s2)
{
   /* Copyright (C) 1999 Jussi Junni */
   GtkCListRow *row1, *row2;
   gchar *text1, *text2;

   g_return_val_if_fail (clist != NULL, 0);
   g_return_val_if_fail (GTK_IS_CLIST (clist), 0);
   g_return_val_if_fail (s1 != NULL, 0);
   g_return_val_if_fail (s2 != NULL, 0);

   row1 = (GtkCListRow *) s1;
   row2 = (GtkCListRow *) s2;

   text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
   text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

   if (!text2) return text1 != NULL;
   if (!text1) return -1;

   return strcmp (text1, text2);
}

gint date_compare (GtkCList *clist, gconstpointer s1, gconstpointer s2)
{
   /* Original function by Jussi Junni, modified by Jeffrey Stedfast */
   GtkCListRow *row1, *row2;
   gchar *text1, *text2;
   date_t date1, date2;

   g_return_val_if_fail (clist != NULL, 0);
   g_return_val_if_fail (GTK_IS_CLIST (clist), 0);
   g_return_val_if_fail (s1 != NULL, 0);
   g_return_val_if_fail (s2 != NULL, 0);

   row1 = (GtkCListRow *) s1;
   row2 = (GtkCListRow *) s2;

   text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
   text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

   if (text2 == NULL)
      return (text1 != NULL);
   if (text1 == NULL)
      return -1;

   date1 = parse_date(text1);
   date2 = parse_date(text2);

   if (date1.year < date2.year) return 1;
   if (date1.year > date2.year) return -1;

   if (date1.mon != 0 && date2.mon != 0)
   {
      if (date1.mon < date2.mon) return 1;
      if (date1.mon > date2.mon) return -1;
   }
   else
   {
      fprintf(stderr, "Invalid date format!\n");
      fflush(stderr);
   }

   if (date1.day < date2.day) return 1;
   if (date1.day > date2.day) return -1;

   if (date1.hour < date2.hour) return 1;
   if (date1.hour > date2.hour) return -1;

   if (date1.min < date2.min) return 1;
   if (date1.min > date2.min) return -1;

   if (date1.sec < date2.sec) return 1;
   if (date1.sec > date2.sec) return -1;
  
   return 0;
}
