/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "options.h"

/* external variables */
extern gboolean OptionsOpen;
extern GtkWidget *frmOptions;
extern gboolean AccountsOpen;
extern GtkWidget *frmAccounts;
extern gchar *spruceconf;

/* Identity */
extern gchar *SenderAddr;
extern gchar *ReplyTo;
extern gint use_rand_sig;
extern gint auto_attach_sig;
extern gchar *signaturefile;

/* Accounts */
extern gint NumAccounts;
extern accounts_t AccountsList[MAX_ACCOUNTS];
extern Server SmtpServer;

/* Appearance */
extern gchar *mesg_body_font;
extern gchar *unread_mesg_header_font;
extern gchar *read_mesg_header_font;

/* Misc */
extern gint save_outgoing;
extern gint empty_on_exit;
extern gint save_sizes;
extern gint cm_delay;
extern gint hdr_trim_level;

/* PGP */
extern gchar *pgp_identity;
extern gint use_gnupg;
extern gint pgp_sign;
extern gint encrypt_to_self;
extern gint store_passphrase;
extern gchar *pgp_passphrase;


/* local */
static gboolean BrowseSigFileOpen = FALSE;
static GtkWidget *frmBrowseSigFile;
static gboolean FontSelOpen = FALSE;
static GtkWidget *frmFontSel;
static GtkWidget *txtFont;               /* pointer to the current font textbox */

GtkWidget* create_frmOptions ()
{
  GtkWidget *frmOptions;
  GtkWidget *fixed;
  GtkWidget *hseparator;
  GtkWidget *cmdOptionsOK;
  GtkWidget *cmdOptionsApply;
  GtkWidget *cmdOptionsCancel;
  GtkWidget *notebook;
  GtkWidget *fixedIdentity;
  GSList *grpSigfiles_group = NULL;
  GtkWidget *radSigFile;
  GtkWidget *radRandSig;
  GtkWidget *chkAutoSig;
  GtkWidget *txtName;
  GtkWidget *lblEmailAddy;
  GtkWidget *lblReplyTo;
  GtkWidget *lblSignatureFile;
  GtkWidget *lblName;
  GtkWidget *txtEmail;
  GtkWidget *txtReplyTo;
  GtkWidget *txtSigfile;
  GtkWidget *cmdSignatureBrowse;
  GtkWidget *fixedAccounts;
  GtkWidget *frameOutgoing;
  GtkWidget *fixedOutgoing;
  GtkWidget *txtSMTPserver;
  GtkWidget *lblSMTPserver;
  GtkObject *spinSMTPport_adj;
  GtkWidget *spinSMTPport;
  GtkWidget *lblSMTPport;
  GtkWidget *frameIncoming;
  GtkWidget *fixedIncoming;
  GtkWidget *scrolledwindow1;
  GtkWidget *clistPop3Servers;
  GtkWidget *lblServer;
  GtkWidget *lblPort;
  GtkWidget *lblMailbox;
  GtkWidget *cmdOptionsEdit;
  GtkWidget *cmdOptionsRefresh;
  GtkWidget *fixedAppearance;
  GtkWidget *frameFonts;
  GtkWidget *fixedFonts;
  GtkWidget *txtMesgBodyFont;
  GtkWidget *lblBodyFont;
  GtkWidget *cmdMesgBodyFonts;
  GtkWidget *txtUnreadMesgFont;
  GtkWidget *lblUnreadMesgFont;
  GtkWidget *cmdUnreadMesgFonts;
  GtkWidget *txtReadMesgFont;
  GtkWidget *lblReadMesgFont;
  GtkWidget *cmdReadMesgFonts;
  GtkWidget *fixedComposer;
  GtkWidget *fixedMisc;
  GtkWidget *chkShowHeaders;
  GtkWidget *chkEmptyOnExit;
  GtkWidget *chkSaveOutgoing;
  GtkWidget *chkSaveSizes;
  GtkWidget *lblCheck;
  GtkObject *spinMinutes_adj;
  GtkWidget *spinMinutes;
  GtkWidget *lblMinutes;
  GtkWidget *fixedPGP;
  GtkWidget *framePGPIdentity;
  GtkWidget *fixedPGPIdentity;
  GtkWidget *txtPGPIdentity;
  GtkWidget *lblPGPIdentity;
  GtkWidget *framePGPGPG;
  GtkWidget *fixedPGPGPG;
  GSList *radPgpGpg_group_group = NULL;
  GtkWidget *radGpg;
  GtkWidget *radPgp50i;
  GtkWidget *framePGPOptions;
  GtkWidget *fixedPGPOptions;
  GtkWidget *chkStorePassphrase;
  GtkWidget *chkEncrypt2Self;
  GtkWidget *chkPgpSign;
  GtkWidget *lblIndentity;
  GtkWidget *lblAccounts;
  GtkWidget *lblAppearance;
  GtkWidget *lblComposer;
  GtkWidget *lblMisc;
  GtkWidget *lblPGP;
  gchar *name, email[256];
  gint i;

  name = g_strdup(SenderAddr);
  get_email_addr_from_text(email, SenderAddr);
  i = find_string(name, email);
  if (i >= 0)
     strcut(name, i, strlen(email));
  i = find_string(name, "<>");
  if (i >= 0)
     strcut(name, i, strlen("<>"));
  trim_whtspc(name);
  trim_whtspc(email);

  frmOptions = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmOptions, "frmOptions");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "frmOptions", frmOptions);
  gtk_widget_set_usize (frmOptions, 500, 500);
  gtk_signal_connect_object (GTK_OBJECT (frmOptions), "destroy",
                             GTK_SIGNAL_FUNC (on_frmOptions_destroy),
                             GTK_OBJECT (frmOptions));
  gtk_signal_connect_object (GTK_OBJECT (frmOptions), "show",
                             GTK_SIGNAL_FUNC (on_frmOptions_show),
                             GTK_OBJECT (frmOptions));
  gtk_window_set_title (GTK_WINDOW (frmOptions), _("Spruce Configuration Options"));
  gtk_window_set_policy (GTK_WINDOW (frmOptions), FALSE, FALSE, FALSE);

  fixed = gtk_fixed_new ();
  gtk_widget_set_name (fixed, "fixed");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixed", fixed);
  gtk_widget_show (fixed);
  gtk_container_add (GTK_CONTAINER (frmOptions), fixed);

  hseparator = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator, "hseparator");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "hseparator", hseparator);
  gtk_widget_show (hseparator);
  gtk_fixed_put (GTK_FIXED (fixed), hseparator, 8, 440);
  gtk_widget_set_uposition (hseparator, 8, 440);
  gtk_widget_set_usize (hseparator, 488, 16);

  cmdOptionsOK = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (cmdOptionsOK, "cmdOptionsOK");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdOptionsOK", cmdOptionsOK);
  gtk_widget_show (cmdOptionsOK);
  gtk_fixed_put (GTK_FIXED (fixed), cmdOptionsOK, 280, 456);
  gtk_widget_set_uposition (cmdOptionsOK, 280, 456);
  gtk_widget_set_usize (cmdOptionsOK, 64, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdOptionsOK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsOK_clicked),
                             GTK_OBJECT (cmdOptionsOK));

  cmdOptionsApply = gtk_button_new_with_label (_("Apply"));
  gtk_widget_set_name (cmdOptionsApply, "cmdOptionsApply");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdOptionsApply", cmdOptionsApply);
  gtk_widget_show (cmdOptionsApply);
  gtk_fixed_put (GTK_FIXED (fixed), cmdOptionsApply, 352, 456);
  gtk_widget_set_uposition (cmdOptionsApply, 352, 456);
  gtk_widget_set_usize (cmdOptionsApply, 64, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdOptionsApply), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsApply_clicked),
                             GTK_OBJECT (cmdOptionsApply));

  cmdOptionsCancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cmdOptionsCancel, "cmdOptionsCancel");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdOptionsCancel", cmdOptionsCancel);
  gtk_widget_show (cmdOptionsCancel);
  gtk_fixed_put (GTK_FIXED (fixed), cmdOptionsCancel, 424, 456);
  gtk_widget_set_uposition (cmdOptionsCancel, 424, 456);
  gtk_widget_set_usize (cmdOptionsCancel, 64, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdOptionsCancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsCancel_clicked),
                             GTK_OBJECT (cmdOptionsCancel));

  notebook = gtk_notebook_new ();
  gtk_widget_set_name (notebook, "notebook");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "notebook", notebook);
  gtk_widget_show (notebook);
  gtk_fixed_put (GTK_FIXED (fixed), notebook, 4, 4);
  gtk_widget_set_uposition (notebook, 4, 4);
  gtk_widget_set_usize (notebook, 492, 436);

  fixedIdentity = gtk_fixed_new ();
  gtk_widget_set_name (fixedIdentity, "fixedIdentity");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedIdentity", fixedIdentity);
  gtk_widget_show (fixedIdentity);
  gtk_container_add (GTK_CONTAINER (notebook), fixedIdentity);

  radSigFile = gtk_radio_button_new_with_label (grpSigfiles_group, _("Use Signature file"));
  grpSigfiles_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radSigFile));
  gtk_widget_set_name (radSigFile, "radSigFile");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "radSigFile", radSigFile);
  gtk_widget_show (radSigFile);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), radSigFile, 8, 144);
  gtk_widget_set_uposition (radSigFile, 8, 144);
  gtk_widget_set_usize (radSigFile, 208, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radSigFile), !use_rand_sig);

  radRandSig = gtk_radio_button_new_with_label (grpSigfiles_group, _("Use Random Signature"));
  grpSigfiles_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radRandSig));
  gtk_widget_set_name (radRandSig, "radRandSig");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "radRandSig", radRandSig);
  gtk_widget_show (radRandSig);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), radRandSig, 216, 144);
  gtk_widget_set_uposition (radRandSig, 216, 144);
  gtk_widget_set_usize (radRandSig, 240, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radRandSig), use_rand_sig);

  chkAutoSig = gtk_check_button_new_with_label (_("Automatically attach selected signature"));
  gtk_widget_set_name (chkAutoSig, "chkAutoSig");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "chkAutoSig", chkAutoSig);
  gtk_widget_show (chkAutoSig);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), chkAutoSig, 8, 176);
  gtk_widget_set_uposition (chkAutoSig, 8, 176);
  gtk_widget_set_usize (chkAutoSig, 448, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkAutoSig), auto_attach_sig);

  txtName = gtk_entry_new ();
  gtk_widget_set_name (txtName, "txtName");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtName", txtName);
  gtk_widget_show (txtName);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), txtName, 144, 16);
  gtk_widget_set_uposition (txtName, 144, 16);
  gtk_widget_set_usize (txtName, 224, 24);
  if (name != NULL)
     gtk_entry_set_text(GTK_ENTRY(txtName), (gchar*) name);
  else
     gtk_entry_set_text(GTK_ENTRY (txtName), _("Joe Sixpack"));

  lblEmailAddy = gtk_label_new (_("Email Address:"));
  gtk_widget_set_name (lblEmailAddy, "lblEmailAddy");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblEmailAddy", lblEmailAddy);
  gtk_widget_show (lblEmailAddy);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), lblEmailAddy, 8, 48);
  gtk_widget_set_uposition (lblEmailAddy, 8, 48);
  gtk_widget_set_usize (lblEmailAddy, 128, 24);
  gtk_label_set_justify (GTK_LABEL (lblEmailAddy), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblEmailAddy), 1.93715e-07, 0.5);

  lblReplyTo = gtk_label_new (_("Reply-To Address:"));
  gtk_widget_set_name (lblReplyTo, "lblReplyTo");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblReplyTo", lblReplyTo);
  gtk_widget_show (lblReplyTo);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), lblReplyTo, 8, 80);
  gtk_widget_set_uposition (lblReplyTo, 8, 80);
  gtk_widget_set_usize (lblReplyTo, 128, 24);
  gtk_label_set_justify (GTK_LABEL (lblReplyTo), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblReplyTo), 1.93715e-07, 0.5);

  lblSignatureFile = gtk_label_new (_("Signature File:"));
  gtk_widget_set_name (lblSignatureFile, "lblSignatureFile");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblSignatureFile", lblSignatureFile);
  gtk_widget_show (lblSignatureFile);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), lblSignatureFile, 8, 112);
  gtk_widget_set_uposition (lblSignatureFile, 8, 112);
  gtk_widget_set_usize (lblSignatureFile, 128, 24);
  gtk_label_set_justify (GTK_LABEL (lblSignatureFile), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblSignatureFile), 1.93715e-07, 0.5);

  lblName = gtk_label_new (_("Name:"));
  gtk_widget_set_name (lblName, "lblName");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblName", lblName);
  gtk_widget_show (lblName);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), lblName, 8, 16);
  gtk_widget_set_uposition (lblName, 8, 16);
  gtk_widget_set_usize (lblName, 128, 24);
  gtk_label_set_justify (GTK_LABEL (lblName), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblName), 1.93715e-07, 0.5);

  txtEmail = gtk_entry_new ();
  gtk_widget_set_name (txtEmail, "txtEmail");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtEmail", txtEmail);
  gtk_widget_show (txtEmail);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), txtEmail, 144, 48);
  gtk_widget_set_uposition (txtEmail, 144, 48);
  gtk_widget_set_usize (txtEmail, 224, 24);
  if (email[0] != '\0')
     gtk_entry_set_text (GTK_ENTRY(txtEmail), (gchar*) email);
  else
     gtk_entry_set_text (GTK_ENTRY (txtEmail), _("joe@sixpack.org"));

  txtReplyTo = gtk_entry_new ();
  gtk_widget_set_name (txtReplyTo, "txtReplyTo");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtReplyTo", txtReplyTo);
  gtk_widget_show (txtReplyTo);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), txtReplyTo, 144, 80);
  gtk_widget_set_uposition (txtReplyTo, 144, 80);
  gtk_widget_set_usize (txtReplyTo, 224, 24);
  if (ReplyTo != NULL)
     gtk_entry_set_text (GTK_ENTRY(txtReplyTo), (gchar*) ReplyTo);

  txtSigfile = gtk_entry_new ();
  gtk_widget_set_name (txtSigfile, "txtSigfile");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtSigfile", txtSigfile);
  gtk_widget_show (txtSigfile);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), txtSigfile, 144, 112);
  gtk_widget_set_uposition (txtSigfile, 144, 112);
  gtk_widget_set_usize (txtSigfile, 224, 24);
  if (signaturefile != NULL)
     gtk_entry_set_text (GTK_ENTRY(txtSigfile), (gchar*) signaturefile);

  cmdSignatureBrowse = gtk_button_new_with_label (_("Browse"));
  gtk_widget_set_name (cmdSignatureBrowse, "cmdSignatureBrowse");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdSignatureBrowse", cmdSignatureBrowse);
  gtk_widget_show (cmdSignatureBrowse);
  gtk_fixed_put (GTK_FIXED (fixedIdentity), cmdSignatureBrowse, 384, 112);
  gtk_widget_set_uposition (cmdSignatureBrowse, 384, 112);
  gtk_widget_set_usize (cmdSignatureBrowse, 88, 24);
  gtk_signal_connect_object (GTK_OBJECT (cmdSignatureBrowse), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdSignatureBrowse_clicked),
                             GTK_OBJECT (cmdSignatureBrowse));

  fixedAccounts = gtk_fixed_new ();
  gtk_widget_set_name (fixedAccounts, "fixedAccounts");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedAccounts", fixedAccounts);
  gtk_widget_show (fixedAccounts);
  gtk_container_add (GTK_CONTAINER (notebook), fixedAccounts);

  frameOutgoing = gtk_frame_new (_("Outgoing Mail"));
  gtk_widget_set_name (frameOutgoing, "frameOutgoing");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "frameOutgoing", frameOutgoing);
  gtk_widget_show (frameOutgoing);
  gtk_fixed_put (GTK_FIXED (fixedAccounts), frameOutgoing, 6, 6);
  gtk_widget_set_uposition (frameOutgoing, 6, 6);
  gtk_widget_set_usize (frameOutgoing, 476, 190);

  fixedOutgoing = gtk_fixed_new ();
  gtk_widget_set_name (fixedOutgoing, "fixedOutgoing");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedOutgoing", fixedOutgoing);
  gtk_widget_show (fixedOutgoing);
  gtk_container_add (GTK_CONTAINER (frameOutgoing), fixedOutgoing);

  txtSMTPserver = gtk_entry_new ();
  gtk_widget_set_name (txtSMTPserver, "txtSMTPserver");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtSMTPserver", txtSMTPserver);
  gtk_widget_show (txtSMTPserver);
  gtk_fixed_put (GTK_FIXED (fixedOutgoing), txtSMTPserver, 160, 8);
  gtk_widget_set_uposition (txtSMTPserver, 160, 8);
  gtk_widget_set_usize (txtSMTPserver, 296, 24);
  if (SmtpServer.hostname != NULL)
     gtk_entry_set_text(GTK_ENTRY(txtSMTPserver), (gchar*) SmtpServer.hostname);
  else
     gtk_entry_set_text (GTK_ENTRY (txtSMTPserver), _("mail.sixpack.org"));

  lblSMTPserver = gtk_label_new (_("SMTP Server:"));
  gtk_widget_set_name (lblSMTPserver, "lblSMTPserver");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblSMTPserver", lblSMTPserver);
  gtk_widget_show (lblSMTPserver);
  gtk_fixed_put (GTK_FIXED (fixedOutgoing), lblSMTPserver, 8, 8);
  gtk_widget_set_uposition (lblSMTPserver, 8, 8);
  gtk_widget_set_usize (lblSMTPserver, 144, 24);
  gtk_label_set_justify (GTK_LABEL (lblSMTPserver), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblSMTPserver), 1.93715e-07, 0.5);

  spinSMTPport_adj = gtk_adjustment_new (25, 0, 65535, 1, 10, 10);
  spinSMTPport = gtk_spin_button_new (GTK_ADJUSTMENT (spinSMTPport_adj), 1, 0);
  gtk_widget_set_name (spinSMTPport, "spinSMTPport");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "spinSMTPport", spinSMTPport);
  gtk_widget_show (spinSMTPport);
  gtk_fixed_put (GTK_FIXED (fixedOutgoing), spinSMTPport, 160, 40);
  gtk_widget_set_uposition (spinSMTPport, 160, 40);
  gtk_widget_set_usize (spinSMTPport, 88, 24);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinSMTPport), TRUE);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinSMTPport), SmtpServer.port);

  lblSMTPport = gtk_label_new (_("SMTP Port:"));
  gtk_widget_set_name (lblSMTPport, "lblSMTPport");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblSMTPport", lblSMTPport);
  gtk_widget_show (lblSMTPport);
  gtk_fixed_put (GTK_FIXED (fixedOutgoing), lblSMTPport, 8, 40);
  gtk_widget_set_uposition (lblSMTPport, 8, 40);
  gtk_widget_set_usize (lblSMTPport, 144, 24);
  gtk_label_set_justify (GTK_LABEL (lblSMTPport), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblSMTPport), 1.93715e-07, 0.5);

  frameIncoming = gtk_frame_new (_("Incoming Mail"));
  gtk_widget_set_name (frameIncoming, "frameIncoming");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "frameIncoming", frameIncoming);
  gtk_widget_show (frameIncoming);
  gtk_fixed_put (GTK_FIXED (fixedAccounts), frameIncoming, 6, 202);
  gtk_widget_set_uposition (frameIncoming, 6, 202);
  gtk_widget_set_usize (frameIncoming, 476, 196);

  fixedIncoming = gtk_fixed_new ();
  gtk_widget_set_name (fixedIncoming, "fixedIncoming");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedIncoming", fixedIncoming);
  gtk_widget_show (fixedIncoming);
  gtk_container_add (GTK_CONTAINER (frameIncoming), fixedIncoming);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "scrolledwindow1", scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_fixed_put (GTK_FIXED (fixedIncoming), scrolledwindow1, 6, 6);
  gtk_widget_set_uposition (scrolledwindow1, 6, 6);
  gtk_widget_set_usize (scrolledwindow1, 370, 166);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clistPop3Servers = gtk_clist_new (3);
  gtk_widget_set_name (clistPop3Servers, "clistPop3Servers");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "clistPop3Servers", clistPop3Servers);
  gtk_widget_show (clistPop3Servers);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), clistPop3Servers);
  gtk_clist_set_column_width (GTK_CLIST (clistPop3Servers), 0, 136);
  gtk_clist_set_column_width (GTK_CLIST (clistPop3Servers), 1, 64);
  gtk_clist_set_column_width (GTK_CLIST (clistPop3Servers), 2, 80);
  gtk_clist_column_titles_show (GTK_CLIST (clistPop3Servers));

  lblServer = gtk_label_new (_("Server"));
  gtk_widget_set_name (lblServer, "lblServer");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblServer", lblServer);
  gtk_widget_show (lblServer);
  gtk_clist_set_column_widget (GTK_CLIST (clistPop3Servers), 0, lblServer);

  lblPort = gtk_label_new (_("Port"));
  gtk_widget_set_name (lblPort, "lblPort");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblPort", lblPort);
  gtk_widget_show (lblPort);
  gtk_clist_set_column_widget (GTK_CLIST (clistPop3Servers), 1, lblPort);

  lblMailbox = gtk_label_new (_("Mailbox"));
  gtk_widget_set_name (lblMailbox, "lblMailbox");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblMailbox", lblMailbox);
  gtk_widget_show (lblMailbox);
  gtk_clist_set_column_widget (GTK_CLIST (clistPop3Servers), 2, lblMailbox);

  cmdOptionsEdit = gtk_button_new_with_label (_("Edit"));
  gtk_widget_set_name (cmdOptionsEdit, "cmdOptionsEdit");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdOptionsEdit", cmdOptionsEdit);
  gtk_widget_show (cmdOptionsEdit);
  gtk_fixed_put (GTK_FIXED (fixedIncoming), cmdOptionsEdit, 384, 24);
  gtk_widget_set_uposition (cmdOptionsEdit, 384, 24);
  gtk_widget_set_usize (cmdOptionsEdit, 80, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdOptionsEdit), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsEdit_clicked),
                             GTK_OBJECT (cmdOptionsEdit));

  cmdOptionsRefresh = gtk_button_new_with_label (_("Refresh"));
  gtk_widget_set_name (cmdOptionsRefresh, "cmdOptionsRefresh");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdOptionsRefresh", cmdOptionsRefresh);
  gtk_widget_show (cmdOptionsRefresh);
  gtk_fixed_put (GTK_FIXED (fixedIncoming), cmdOptionsRefresh, 384, 64);
  gtk_widget_set_uposition (cmdOptionsRefresh, 384, 64);
  gtk_widget_set_usize (cmdOptionsRefresh, 80, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdOptionsRefresh), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsRefresh_clicked),
                             GTK_OBJECT (cmdOptionsRefresh));

  fixedAppearance = gtk_fixed_new ();
  gtk_widget_set_name (fixedAppearance, "fixedAppearance");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedAppearance", fixedAppearance);
  gtk_widget_show (fixedAppearance);
  gtk_container_add (GTK_CONTAINER (notebook), fixedAppearance);

  frameFonts = gtk_frame_new (_("Fonts"));
  gtk_widget_set_name (frameFonts, "frameFonts");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "frameFonts", frameFonts);
  gtk_widget_show (frameFonts);
  gtk_fixed_put (GTK_FIXED (fixedAppearance), frameFonts, 6, 6);
  gtk_widget_set_uposition (frameFonts, 6, 6);
  gtk_widget_set_usize (frameFonts, 476, 150);

  fixedFonts = gtk_fixed_new ();
  gtk_widget_set_name (fixedFonts, "fixedFonts");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedFonts", fixedFonts);
  gtk_widget_show (fixedFonts);
  gtk_container_add (GTK_CONTAINER (frameFonts), fixedFonts);

  /* Message Body Font */
  txtMesgBodyFont = gtk_entry_new ();
  gtk_widget_set_name (txtMesgBodyFont, "txtMesgBodyFont");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtMesgBodyFont", txtMesgBodyFont);
  gtk_widget_show (txtMesgBodyFont);
  gtk_fixed_put (GTK_FIXED (fixedFonts), txtMesgBodyFont, 168, 16);
  gtk_widget_set_uposition (txtMesgBodyFont, 168, 16);
  gtk_widget_set_usize (txtMesgBodyFont, 240, 24);
  if (mesg_body_font != NULL)
     gtk_entry_set_text (GTK_ENTRY (txtMesgBodyFont), (gchar*) mesg_body_font);

  lblBodyFont = gtk_label_new (_("Message Body Font:"));
  gtk_widget_set_name (lblBodyFont, "lblBodyFont");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblBodyFont", lblBodyFont);
  gtk_widget_show (lblBodyFont);
  gtk_fixed_put (GTK_FIXED (fixedFonts), lblBodyFont, 8, 16);
  gtk_widget_set_uposition (lblBodyFont, 8, 16);
  gtk_widget_set_usize (lblBodyFont, 152, 24);
  gtk_misc_set_alignment (GTK_MISC (lblBodyFont), 1.93715e-07, 0.5);

  cmdMesgBodyFonts = gtk_button_new_with_label (_("..."));
  gtk_widget_set_name (cmdMesgBodyFonts, "cmdMesgBodyFonts");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdMesgBodyFonts", cmdMesgBodyFonts);
  gtk_widget_show (cmdMesgBodyFonts);
  gtk_fixed_put (GTK_FIXED (fixedFonts), cmdMesgBodyFonts, 416, 16);
  gtk_widget_set_uposition (cmdMesgBodyFonts, 416, 16);
  gtk_widget_set_usize (cmdMesgBodyFonts, 47, 22);
  gtk_signal_connect_object (GTK_OBJECT (cmdMesgBodyFonts), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsFonts_clicked),
                             GTK_OBJECT (txtMesgBodyFont));
  
  /* Unread Message font (for the clist) */ 
  txtUnreadMesgFont = gtk_entry_new ();
  gtk_widget_set_name (txtUnreadMesgFont, "txtUnreadMesgFont");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtUnreadMesgFont", txtUnreadMesgFont);
  gtk_widget_show (txtUnreadMesgFont);
  gtk_fixed_put (GTK_FIXED (fixedFonts), txtUnreadMesgFont, 168, 48);
  gtk_widget_set_uposition (txtUnreadMesgFont, 168, 48);
  gtk_widget_set_usize (txtUnreadMesgFont, 240, 24);
  if (unread_mesg_header_font != NULL)
     gtk_entry_set_text (GTK_ENTRY (txtUnreadMesgFont), (gchar*) unread_mesg_header_font);

  lblUnreadMesgFont = gtk_label_new (_("Unread Message List Font:"));
  gtk_widget_set_name (lblUnreadMesgFont, "lblUnreadMesgFont");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblUnreadMesgFont", lblUnreadMesgFont);
  gtk_widget_show (lblUnreadMesgFont);
  gtk_fixed_put (GTK_FIXED (fixedFonts), lblUnreadMesgFont, 8, 48);
  gtk_widget_set_uposition (lblUnreadMesgFont, 8, 48);
  gtk_widget_set_usize (lblUnreadMesgFont, 152, 24);
  gtk_misc_set_alignment (GTK_MISC (lblUnreadMesgFont), 1.93715e-07, 0.5);

  cmdUnreadMesgFonts = gtk_button_new_with_label (_("..."));
  gtk_widget_set_name (cmdUnreadMesgFonts, "cmdUnreadMesgFonts");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdUnreadMesgFonts", cmdUnreadMesgFonts);
  gtk_widget_show (cmdUnreadMesgFonts);
  gtk_fixed_put (GTK_FIXED (fixedFonts), cmdUnreadMesgFonts, 416, 48);
  gtk_widget_set_uposition (cmdUnreadMesgFonts, 416, 48);
  gtk_widget_set_usize (cmdUnreadMesgFonts, 47, 22);
  gtk_signal_connect_object (GTK_OBJECT (cmdUnreadMesgFonts), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsFonts_clicked),
                             GTK_OBJECT (txtUnreadMesgFont));
  
  /* Read Message font (for the clist) */ 
  txtReadMesgFont = gtk_entry_new ();
  gtk_widget_set_name (txtReadMesgFont, "txtReadMesgFont");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtReadMesgFont", txtReadMesgFont);
  gtk_widget_show (txtReadMesgFont);
  gtk_fixed_put (GTK_FIXED (fixedFonts), txtReadMesgFont, 168, 80);
  gtk_widget_set_uposition (txtReadMesgFont, 168, 80);
  gtk_widget_set_usize (txtReadMesgFont, 240, 24);
  if (read_mesg_header_font != NULL)
     gtk_entry_set_text (GTK_ENTRY (txtReadMesgFont), (gchar*) read_mesg_header_font);

  lblReadMesgFont = gtk_label_new (_("Read Message List Font:"));
  gtk_widget_set_name (lblReadMesgFont, "lblReadMesgFont");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblReadMesgFont", lblReadMesgFont);
  gtk_widget_show (lblReadMesgFont);
  gtk_fixed_put (GTK_FIXED (fixedFonts), lblReadMesgFont, 8, 80);
  gtk_widget_set_uposition (lblReadMesgFont, 8, 80);
  gtk_widget_set_usize (lblReadMesgFont, 152, 24);
  gtk_misc_set_alignment (GTK_MISC (lblReadMesgFont), 1.93715e-07, 0.5);

  cmdReadMesgFonts = gtk_button_new_with_label (_("..."));
  gtk_widget_set_name (cmdReadMesgFonts, "cmdReadMesgFonts");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "cmdReadMesgFonts", cmdReadMesgFonts);
  gtk_widget_show (cmdReadMesgFonts);
  gtk_fixed_put (GTK_FIXED (fixedFonts), cmdReadMesgFonts, 416, 80);
  gtk_widget_set_uposition (cmdReadMesgFonts, 416, 80);
  gtk_widget_set_usize (cmdReadMesgFonts, 47, 22);
  gtk_signal_connect_object (GTK_OBJECT (cmdReadMesgFonts), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsFonts_clicked),
                             GTK_OBJECT (txtReadMesgFont));
  
  fixedComposer = gtk_fixed_new ();
  gtk_widget_set_name (fixedComposer, "fixedComposer");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedComposer", fixedComposer);
  gtk_widget_show (fixedComposer);
  gtk_container_add (GTK_CONTAINER (notebook), fixedComposer);

  fixedMisc = gtk_fixed_new ();
  gtk_widget_set_name (fixedMisc, "fixedMisc");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedMisc", fixedMisc);
  gtk_widget_show (fixedMisc);
  gtk_container_add (GTK_CONTAINER (notebook), fixedMisc);

  chkShowHeaders = gtk_check_button_new_with_label (_("Show headers"));
  gtk_widget_set_name (chkShowHeaders, "chkShowHeaders");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "chkShowHeaders", chkShowHeaders);
  gtk_widget_show (chkShowHeaders);
  gtk_fixed_put (GTK_FIXED (fixedMisc), chkShowHeaders, 8, 8);
  gtk_widget_set_uposition (chkShowHeaders, 8, 8);
  gtk_widget_set_usize (chkShowHeaders, 472, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkShowHeaders), hdr_trim_level);
  
  chkEmptyOnExit = gtk_check_button_new_with_label (_("Empty \"Deleted items\" on exit"));
  gtk_widget_set_name (chkEmptyOnExit, "chkEmptyOnExit");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "chkEmptyOnExit", chkEmptyOnExit);
  gtk_widget_show (chkEmptyOnExit);
  gtk_fixed_put (GTK_FIXED (fixedMisc), chkEmptyOnExit, 8, 32);
  gtk_widget_set_uposition (chkEmptyOnExit, 8, 32);
  gtk_widget_set_usize (chkEmptyOnExit, 472, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkEmptyOnExit), empty_on_exit);

  chkSaveOutgoing = gtk_check_button_new_with_label (_("Save outgoing messages to \"Sent items\""));
  gtk_widget_set_name (chkSaveOutgoing, "chkSaveOutgoing");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "chkSaveOutgoing", chkSaveOutgoing);
  gtk_widget_show (chkSaveOutgoing);
  gtk_fixed_put (GTK_FIXED (fixedMisc), chkSaveOutgoing, 8, 56);
  gtk_widget_set_uposition (chkSaveOutgoing, 8, 56);
  gtk_widget_set_usize (chkSaveOutgoing, 472, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkSaveOutgoing), save_outgoing);

  chkSaveSizes = gtk_check_button_new_with_label (_("Save window size and column sizes"));
  gtk_widget_set_name (chkSaveSizes, "chkSaveSizes");
  gtk_object_set_data (GTK_OBJECT(frmOptions), "chkSaveSizes", chkSaveSizes);
  gtk_widget_show (chkSaveSizes);
  gtk_fixed_put (GTK_FIXED (fixedMisc), chkSaveSizes, 8, 80);
  gtk_widget_set_uposition (chkSaveSizes, 8, 80);
  gtk_widget_set_usize (chkSaveSizes, 472, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkSaveSizes), save_sizes);

  lblCheck = gtk_label_new (_("Check mail every:"));
  gtk_widget_set_name (lblCheck, "lblCheck");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblCheck", lblCheck);
  gtk_widget_show (lblCheck);
  gtk_fixed_put (GTK_FIXED (fixedMisc), lblCheck, 8, 104);
  gtk_widget_set_uposition (lblCheck, 8, 104);
  gtk_widget_set_usize (lblCheck, 136, 24);
  gtk_label_set_justify (GTK_LABEL (lblCheck), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblCheck), 1.93715e-07, 0.5);

  spinMinutes_adj = gtk_adjustment_new (0, 0, 100, 1, 10, 10);
  spinMinutes = gtk_spin_button_new (GTK_ADJUSTMENT (spinMinutes_adj), 1, 0);
  gtk_widget_set_name (spinMinutes, "spinMinutes");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "spinMinutes", spinMinutes);
  gtk_widget_show (spinMinutes);
  gtk_fixed_put (GTK_FIXED (fixedMisc), spinMinutes, 160, 104);
  gtk_widget_set_uposition (spinMinutes, 160, 104);
  gtk_widget_set_usize (spinMinutes, 80, 24);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(spinMinutes), cm_delay);

  lblMinutes = gtk_label_new (_("minutes (0 for never)"));
  gtk_widget_set_name (lblMinutes, "lblMinutes");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblMinutes", lblMinutes);
  gtk_widget_show (lblMinutes);
  gtk_fixed_put (GTK_FIXED (fixedMisc), lblMinutes, 248, 104);
  gtk_widget_set_uposition (lblMinutes, 248, 104);
  gtk_widget_set_usize (lblMinutes, 168, 24);
  gtk_label_set_justify (GTK_LABEL (lblMinutes), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblMinutes), 1.93715e-07, 0.5);

  fixedPGP = gtk_fixed_new ();
  gtk_widget_set_name (fixedPGP, "fixedPGP");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedPGP", fixedPGP);
  gtk_widget_show (fixedPGP);
  gtk_container_add (GTK_CONTAINER (notebook), fixedPGP);

  framePGPIdentity = gtk_frame_new (_("Identity"));
  gtk_widget_set_name (framePGPIdentity, "framePGPIdentity");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "framePGPIdentity", framePGPIdentity);
  gtk_widget_show (framePGPIdentity);
  gtk_fixed_put (GTK_FIXED (fixedPGP), framePGPIdentity, 6, 6);
  gtk_widget_set_uposition (framePGPIdentity, 6, 6);
  gtk_widget_set_usize (framePGPIdentity, 476, 80);

  fixedPGPIdentity = gtk_fixed_new ();
  gtk_widget_set_name (fixedPGPIdentity, "fixedPGPIdentity");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedPGPIdentity", fixedPGPIdentity);
  gtk_widget_show (fixedPGPIdentity);
  gtk_container_add (GTK_CONTAINER (framePGPIdentity), fixedPGPIdentity);

  txtPGPIdentity = gtk_entry_new ();
  gtk_widget_set_name (txtPGPIdentity, "txtPGPIdentity");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "txtPGPIdentity", txtPGPIdentity);
  gtk_widget_show (txtPGPIdentity);
  gtk_fixed_put (GTK_FIXED (fixedPGPIdentity), txtPGPIdentity, 160, 16);
  gtk_widget_set_uposition (txtPGPIdentity, 160, 16);
  gtk_widget_set_usize (txtPGPIdentity, 296, 24);
  if (pgp_identity != NULL)
     gtk_entry_set_text(GTK_ENTRY(txtPGPIdentity), (gchar*) pgp_identity);

  lblPGPIdentity = gtk_label_new (_("PGP User Identity:"));
  gtk_widget_set_name (lblPGPIdentity, "lblPGPIdentity");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblPGPIdentity", lblPGPIdentity);
  gtk_widget_show (lblPGPIdentity);
  gtk_fixed_put (GTK_FIXED (fixedPGPIdentity), lblPGPIdentity, 8, 16);
  gtk_widget_set_uposition (lblPGPIdentity, 8, 16);
  gtk_widget_set_usize (lblPGPIdentity, 144, 24);
  gtk_misc_set_alignment (GTK_MISC (lblPGPIdentity), 1.93715e-07, 0.5);

  framePGPGPG = gtk_frame_new (_("PGP / GNUpg"));
  gtk_widget_set_name (framePGPGPG, "framePGPGPG");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "framePGPGPG", framePGPGPG);
  gtk_widget_show (framePGPGPG);
  gtk_fixed_put (GTK_FIXED (fixedPGP), framePGPGPG, 6, 96);
  gtk_widget_set_uposition (framePGPGPG, 6, 96);
  gtk_widget_set_usize (framePGPGPG, 476, 80);

  fixedPGPGPG = gtk_fixed_new ();
  gtk_widget_set_name (fixedPGPGPG, "fixedPGPGPG");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedPGPGPG", fixedPGPGPG);
  gtk_widget_show (fixedPGPGPG);
  gtk_container_add (GTK_CONTAINER (framePGPGPG), fixedPGPGPG);

  radGpg = gtk_radio_button_new_with_label (radPgpGpg_group_group, _("Use GNUpg"));
  radPgpGpg_group_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radGpg));
  gtk_widget_set_name (radGpg, "radGpg");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "radGpg", radGpg);
  gtk_widget_show (radGpg);
  gtk_fixed_put (GTK_FIXED (fixedPGPGPG), radGpg, 8, 16);
  gtk_widget_set_uposition (radGpg, 8, 16);
  gtk_widget_set_usize (radGpg, 152, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radGpg), use_gnupg);

  radPgp50i = gtk_radio_button_new_with_label (radPgpGpg_group_group, _("Use Pgp50i"));
  radPgpGpg_group_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radPgp50i));
  gtk_widget_set_name (radPgp50i, "radPgp50i");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "radPgp50i", radPgp50i);
  gtk_widget_show (radPgp50i);
  gtk_fixed_put (GTK_FIXED (fixedPGPGPG), radPgp50i, 168, 16);
  gtk_widget_set_uposition (radPgp50i, 168, 16);
  gtk_widget_set_usize (radPgp50i, 152, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radPgp50i), !use_gnupg);
  
  framePGPOptions = gtk_frame_new (_("Options"));
  gtk_widget_set_name (framePGPOptions, "framePGPOptions");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "framePGPOptions", framePGPOptions);
  gtk_widget_show (framePGPOptions);
  gtk_fixed_put (GTK_FIXED (fixedPGP), framePGPOptions, 6, 184);
  gtk_widget_set_uposition (framePGPOptions, 6, 184);
  gtk_widget_set_usize (framePGPOptions, 476, 160);

  fixedPGPOptions = gtk_fixed_new ();
  gtk_widget_set_name (fixedPGPOptions, "fixedPGPOptions");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "fixedPGPOptions", fixedPGPOptions);
  gtk_widget_show (fixedPGPOptions);
  gtk_container_add (GTK_CONTAINER (framePGPOptions), fixedPGPOptions);

  chkStorePassphrase = gtk_check_button_new_with_label (_("Store passphrase"));
  gtk_widget_set_name (chkStorePassphrase, "chkStorePassphrase");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "chkStorePassphrase", chkStorePassphrase);
  gtk_widget_show (chkStorePassphrase);
  gtk_fixed_put (GTK_FIXED (fixedPGPOptions), chkStorePassphrase, 8, 8);
  gtk_widget_set_uposition (chkStorePassphrase, 8, 8);
  gtk_widget_set_usize (chkStorePassphrase, 456, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkStorePassphrase), store_passphrase);

  chkEncrypt2Self = gtk_check_button_new_with_label (_("Always encrypt to self"));
  gtk_widget_set_name (chkEncrypt2Self, "chkEncrypt2Self");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "chkEncrypt2Self", chkEncrypt2Self);
  gtk_widget_show (chkEncrypt2Self);
  gtk_fixed_put (GTK_FIXED (fixedPGPOptions), chkEncrypt2Self, 8, 32);
  gtk_widget_set_uposition (chkEncrypt2Self, 8, 32);
  gtk_widget_set_usize (chkEncrypt2Self, 456, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkEncrypt2Self), encrypt_to_self);

  chkPgpSign = gtk_check_button_new_with_label (_("Always sign"));
  gtk_widget_set_name (chkPgpSign, "chkPgpSign");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "chkPgpSign", chkPgpSign);
  gtk_widget_show (chkPgpSign);
  gtk_fixed_put (GTK_FIXED (fixedPGPOptions), chkPgpSign, 8, 56);
  gtk_widget_set_uposition (chkPgpSign, 8, 56);
  gtk_widget_set_usize (chkPgpSign, 456, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (chkPgpSign), pgp_sign);

  lblIndentity = gtk_label_new (_("Identity"));
  gtk_widget_set_name (lblIndentity, "lblIndentity");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblIndentity", lblIndentity);
  gtk_widget_show (lblIndentity);
  set_notebook_tab (notebook, 0, lblIndentity);

  lblAccounts = gtk_label_new (_("Accounts"));
  gtk_widget_set_name (lblAccounts, "lblAccounts");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblAccounts", lblAccounts);
  gtk_widget_show (lblAccounts);
  set_notebook_tab (notebook, 1, lblAccounts);

  lblAppearance = gtk_label_new (_("Appearance"));
  gtk_widget_set_name (lblAppearance, "lblAppearance");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblAppearance", lblAppearance);
  gtk_widget_show (lblAppearance);
  set_notebook_tab (notebook, 2, lblAppearance);

  lblComposer = gtk_label_new (_("Composer"));
  gtk_widget_set_name (lblComposer, "lblComposer");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblComposer", lblComposer);
  gtk_widget_show (lblComposer);
  set_notebook_tab (notebook, 3, lblComposer);

  lblMisc = gtk_label_new (_("Misc"));
  gtk_widget_set_name (lblMisc, "lblMisc");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblMisc", lblMisc);
  gtk_widget_show (lblMisc);
  set_notebook_tab (notebook, 4, lblMisc);

  lblPGP = gtk_label_new (_("PGP"));
  gtk_widget_set_name (lblPGP, "lblPGP");
  gtk_object_set_data (GTK_OBJECT (frmOptions), "lblPGP", lblPGP);
  gtk_widget_show (lblPGP);
  set_notebook_tab (notebook, 5, lblPGP);

  g_free(name);

  return frmOptions;
}
GtkWidget* create_frmBrowseSigFile ()
{
  GtkWidget *frmBrowseSigFile;
  GtkWidget *cmdOptionsBrowse_OK;
  GtkWidget *cmdOptionsBrowse_Cancel;

  frmBrowseSigFile = gtk_file_selection_new (_("Select Signature file..."));
  gtk_widget_set_name (frmBrowseSigFile, "frmBrowseSigFile");
  gtk_object_set_data (GTK_OBJECT (frmBrowseSigFile), "frmBrowseSigFile", frmBrowseSigFile);
  gtk_container_border_width (GTK_CONTAINER (frmBrowseSigFile), 10);
  gtk_signal_connect_object (GTK_OBJECT (frmBrowseSigFile), "destroy",
                             GTK_SIGNAL_FUNC (on_frmBrowseSigFile_destroy),
                             GTK_OBJECT (frmBrowseSigFile));

  cmdOptionsBrowse_OK = GTK_FILE_SELECTION (frmBrowseSigFile)->ok_button;
  gtk_widget_set_name (cmdOptionsBrowse_OK, "cmdOptionsBrowse_OK");
  gtk_object_set_data (GTK_OBJECT (frmBrowseSigFile), "cmdOptionsBrowse_OK", cmdOptionsBrowse_OK);
  gtk_widget_show (cmdOptionsBrowse_OK);
  GTK_WIDGET_SET_FLAGS (cmdOptionsBrowse_OK, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdOptionsBrowse_OK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsBrowse_OK_clicked),
                             GTK_OBJECT (cmdOptionsBrowse_OK));

  cmdOptionsBrowse_Cancel = GTK_FILE_SELECTION (frmBrowseSigFile)->cancel_button;
  gtk_widget_set_name (cmdOptionsBrowse_Cancel, "cmdOptionsBrowse_Cancel");
  gtk_object_set_data (GTK_OBJECT (frmBrowseSigFile), "cmdOptionsBrowse_Cancel", cmdOptionsBrowse_Cancel);
  gtk_widget_show (cmdOptionsBrowse_Cancel);
  GTK_WIDGET_SET_FLAGS (cmdOptionsBrowse_Cancel, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdOptionsBrowse_Cancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdOptionsBrowse_Cancel_clicked),
                             GTK_OBJECT (cmdOptionsBrowse_Cancel));

  return frmBrowseSigFile;
}

GtkWidget* create_frmFontSel ()
{
  GtkWidget *cmdFontSel_OK;
  GtkWidget *cmdFontSel_Cancel;
  GtkWidget *cmdFontSel_Apply;

  frmFontSel = gtk_font_selection_dialog_new ("Select Font");
  gtk_object_set_data (GTK_OBJECT (frmFontSel), "frmFontSel", frmFontSel);
  gtk_container_border_width (GTK_CONTAINER (frmFontSel), 4);
  gtk_signal_connect_object (GTK_OBJECT (frmFontSel), "destroy",
                             GTK_SIGNAL_FUNC (on_frmFontSel_destroy),
                             GTK_OBJECT (frmFontSel));
  gtk_window_set_policy (GTK_WINDOW (frmFontSel), FALSE, TRUE, TRUE);

  cmdFontSel_OK = GTK_FONT_SELECTION_DIALOG (frmFontSel)->ok_button;
  gtk_object_set_data (GTK_OBJECT (frmFontSel), "cmdFontSel_OK", cmdFontSel_OK);
  gtk_widget_show (cmdFontSel_OK);
  GTK_WIDGET_SET_FLAGS (cmdFontSel_OK, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdFontSel_OK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdFontSel_OK_clicked),
                             GTK_OBJECT (cmdFontSel_OK));

  cmdFontSel_Cancel = GTK_FONT_SELECTION_DIALOG (frmFontSel)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (frmFontSel), "cmdFontSel_Cancel", cmdFontSel_Cancel);
  gtk_widget_show (cmdFontSel_Cancel);
  GTK_WIDGET_SET_FLAGS (cmdFontSel_Cancel, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdFontSel_Cancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdFontSel_Cancel_clicked),
                             GTK_OBJECT (cmdFontSel_Cancel));

  cmdFontSel_Apply = GTK_FONT_SELECTION_DIALOG (frmFontSel)->apply_button;
  gtk_object_set_data (GTK_OBJECT (frmFontSel), "cmdFontSel_Apply", cmdFontSel_Apply);
  gtk_widget_show (cmdFontSel_Apply);
  GTK_WIDGET_SET_FLAGS (cmdFontSel_Apply, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdFontSel_Apply), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdFontSel_Apply_clicked),
                             GTK_OBJECT (cmdFontSel_Apply));

  return frmFontSel;
}

void on_frmOptions_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmOptions);
   OptionsOpen = FALSE;
}

void on_frmOptions_show (GtkWidget *widget, gpointer user_data)
{
   BrowseSigFileOpen = FALSE;
   refresh_clistPop3Servers(TRUE);
}

void on_cmdOptionsOK_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *spinMinutes    = get_widget(frmOptions, "spinMinutes");
   GtkWidget *radGpg         = get_widget(frmOptions, "radGpg");
   GtkWidget *chkPgpSign     = get_widget(frmOptions, "chkPgpSign");
   GtkWidget *txtMesgBodyFont= get_widget(frmOptions, "txtMesgBodyFont");
   GtkWidget *txtPGPIdentity = get_widget(frmOptions, "txtPGPIdentity");
   GtkWidget *chkStorePass   = get_widget(frmOptions, "chkStorePassphrase");
   GtkWidget *chkEnc2Self    = get_widget(frmOptions, "chkEncrypt2Self");
   GtkWidget *radRandSig     = get_widget(frmOptions, "radRandSig");
   GtkWidget *chkAutoSig     = get_widget(frmOptions, "chkAutoSig");
   GtkWidget *txtReplyTo     = get_widget(frmOptions, "txtReplyTo");
   GtkWidget *chkSaveOut     = get_widget(frmOptions, "chkSaveOutgoing");
   GtkWidget *chkShowHeaders = get_widget(frmOptions, "chkShowHeaders");
   GtkWidget *chkEmptyOnExit = get_widget(frmOptions, "chkEmptyOnExit");
   GtkWidget *chkSaveSizes   = get_widget(frmOptions, "chkSaveSizes");

   cm_delay = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinMinutes));
   use_gnupg = GTK_TOGGLE_BUTTON (radGpg)->active;
   pgp_sign = GTK_TOGGLE_BUTTON (chkPgpSign)->active;
   store_passphrase = GTK_TOGGLE_BUTTON (chkStorePass)->active;
   encrypt_to_self = GTK_TOGGLE_BUTTON (chkEnc2Self)->active;
   use_rand_sig = GTK_TOGGLE_BUTTON (radRandSig)->active;
   auto_attach_sig = GTK_TOGGLE_BUTTON (chkAutoSig)->active;
   save_outgoing = GTK_TOGGLE_BUTTON (chkSaveOut)->active;
   hdr_trim_level = GTK_TOGGLE_BUTTON (chkShowHeaders)->active;
   empty_on_exit = GTK_TOGGLE_BUTTON (chkEmptyOnExit)->active;
   save_sizes = GTK_TOGGLE_BUTTON (chkSaveSizes)->active;

   if (mesg_body_font != NULL)
      g_free(mesg_body_font);
   mesg_body_font = g_malloc(strlen(gtk_entry_get_text(GTK_ENTRY(txtMesgBodyFont))) + 1);
   strcpy(mesg_body_font, gtk_entry_get_text(GTK_ENTRY(txtMesgBodyFont)));

   if (pgp_identity != NULL)
      g_free(pgp_identity);
   pgp_identity = g_malloc(strlen(gtk_entry_get_text(GTK_ENTRY(txtPGPIdentity))) + 1);
   strcpy(pgp_identity, gtk_entry_get_text(GTK_ENTRY(txtPGPIdentity)));
	
   if (ReplyTo != NULL)
      g_free(ReplyTo);
   ReplyTo = g_malloc(strlen(gtk_entry_get_text(GTK_ENTRY(txtReplyTo))) + 1);
   strcpy(ReplyTo, gtk_entry_get_text(GTK_ENTRY(txtReplyTo)));
	
   if (valid_info())
	{
      rc_save_defaults();
      gtk_widget_destroy(frmOptions);
      OptionsOpen = FALSE;
	}
}

void on_cmdOptionsApply_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *spinMinutes    = get_widget(frmOptions, "spinMinutes");
   GtkWidget *radGpg         = get_widget(frmOptions, "radGpg");
   GtkWidget *chkPgpSign     = get_widget(frmOptions, "chkPgpSign");
   GtkWidget *txtMesgBodyFont = get_widget(frmOptions, "txtMesgBodyFont");
   GtkWidget *txtUnreadMesgFont = get_widget(frmOptions, "txtUnreadMesgFont");
   GtkWidget *txtReadMesgFont = get_widget(frmOptions, "txtReadMesgFont");
   GtkWidget *txtPGPIdentity = get_widget(frmOptions, "txtPGPIdentity");
   GtkWidget *chkStorePass   = get_widget(frmOptions, "chkStorePassphrase");
   GtkWidget *chkEnc2Self    = get_widget(frmOptions, "chkEncrypt2Self");
   GtkWidget *radRandSig     = get_widget(frmOptions, "radRandSig");
   GtkWidget *chkAutoSig     = get_widget(frmOptions, "chkAutoSig");
   GtkWidget *txtReplyTo     = get_widget(frmOptions, "txtReplyTo");
   GtkWidget *chkSaveOut     = get_widget(frmOptions, "chkSaveOutgoing");
   GtkWidget *chkShowHeaders = get_widget(frmOptions, "chkShowHeaders");
   GtkWidget *chkEmptyOnExit = get_widget(frmOptions, "chkEmptyOnExit");
   GtkWidget *chkSaveSize    = get_widget(frmOptions, "chkSaveSizes");

   cm_delay = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinMinutes));
   use_gnupg = GTK_TOGGLE_BUTTON (radGpg)->active;
   pgp_sign = GTK_TOGGLE_BUTTON (chkPgpSign)->active;
   store_passphrase = GTK_TOGGLE_BUTTON (chkStorePass)->active;
   encrypt_to_self = GTK_TOGGLE_BUTTON (chkEnc2Self)->active;
   use_rand_sig = GTK_TOGGLE_BUTTON (radRandSig)->active;
   auto_attach_sig = GTK_TOGGLE_BUTTON (chkAutoSig)->active;
   save_outgoing = GTK_TOGGLE_BUTTON (chkSaveOut)->active;
   hdr_trim_level = GTK_TOGGLE_BUTTON (chkShowHeaders)->active;
   empty_on_exit = GTK_TOGGLE_BUTTON (chkEmptyOnExit)->active;
   save_sizes = GTK_TOGGLE_BUTTON (chkSaveSize)->active;

   if (mesg_body_font != NULL)
      g_free(mesg_body_font);
   mesg_body_font = g_strdup(gtk_entry_get_text(GTK_ENTRY(txtMesgBodyFont)));

   if (unread_mesg_header_font != NULL)
      g_free(unread_mesg_header_font);
   unread_mesg_header_font = g_strdup(gtk_entry_get_text(GTK_ENTRY(txtUnreadMesgFont)));

   if (read_mesg_header_font != NULL)
      g_free(read_mesg_header_font);
   read_mesg_header_font = g_strdup(gtk_entry_get_text(GTK_ENTRY(txtReadMesgFont)));

   if (pgp_identity != NULL)
      g_free(pgp_identity);
   pgp_identity = g_strdup(gtk_entry_get_text(GTK_ENTRY(txtPGPIdentity)));
	
   if (ReplyTo != NULL)
      g_free(ReplyTo);
   ReplyTo = g_strdup(gtk_entry_get_text(GTK_ENTRY(txtReplyTo)));

   if (valid_info())
      rc_save_defaults();
}

void on_cmdOptionsCancel_clicked (GtkButton *button, gpointer user_data)
{
   if (valid_info())
	{
      gtk_widget_destroy(frmOptions);
      OptionsOpen = FALSE;
	}
}

void on_cmdSignatureBrowse_clicked (GtkButton *button, gpointer user_data)
{
   if(!BrowseSigFileOpen)
	{
      frmBrowseSigFile = create_frmBrowseSigFile();
      gtk_widget_show(frmBrowseSigFile);
      BrowseSigFileOpen = TRUE;
	}
}

void on_cmdOptionsEdit_clicked (GtkButton *button, gpointer user_data)
{
   if(!AccountsOpen)
	{
      frmAccounts = create_frmAccounts(FALSE);
      gtk_widget_show(frmAccounts);
      AccountsOpen = TRUE;
	}
}

void on_cmdOptionsRefresh_clicked (GtkButton *button, gpointer user_data)
{
   refresh_clistPop3Servers(TRUE);
}

void on_cmdOptionsFonts_clicked (GtkWidget *widget, gpointer user_data)
{
   if(!FontSelOpen)
	{
      txtFont = widget;
      frmFontSel = create_frmFontSel();
      gtk_widget_show(frmFontSel);
      FontSelOpen = TRUE;
	}
}

void on_frmBrowseSigFile_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmBrowseSigFile);
   BrowseSigFileOpen = FALSE;
}

void on_cmdOptionsBrowse_OK_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *txtSigfile = get_widget(frmOptions, "txtSigfile");

   gtk_entry_set_text(GTK_ENTRY(txtSigfile), (gchar*) gtk_file_selection_get_filename(GTK_FILE_SELECTION(frmBrowseSigFile)));

   gtk_widget_destroy(frmBrowseSigFile);
   BrowseSigFileOpen = FALSE;
}

void on_cmdOptionsBrowse_Cancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(frmBrowseSigFile);
   BrowseSigFileOpen = FALSE;
}

void on_frmFontSel_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmFontSel);
   txtFont = NULL;
   FontSelOpen = FALSE;
}

void on_cmdFontSel_OK_clicked (GtkButton *button, gpointer user_data)
{
   on_cmdFontSel_Apply_clicked (NULL, NULL);

   gtk_widget_destroy(frmFontSel);
   txtFont = NULL;
   FontSelOpen = FALSE;
}

void on_cmdFontSel_Cancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(frmFontSel);
   FontSelOpen = FALSE;
}

void on_cmdFontSel_Apply_clicked (GtkButton *button, gpointer user_data)
{
	gtk_entry_set_text(GTK_ENTRY(txtFont), gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(frmFontSel)) );
}

void refresh_clistPop3Servers(gint reread)
{
   GtkWidget *clist = get_widget(frmOptions, "clistPop3Servers");
   gchar buffer[256];
   gint i, mRow = NumAccounts - 1;
   gchar *text[3] = {"Server", "Port", "Mailbox"};

   if (reread)
      read_accounts();

   gtk_clist_freeze(GTK_CLIST(clist));
   gtk_clist_clear(GTK_CLIST(clist));

   for(i = 0; i <= mRow; i++)
	{
      gtk_clist_append(GTK_CLIST(clist), (gchar**) text);
      gtk_clist_set_text(GTK_CLIST(clist), i, 0, AccountsList[i].server.hostname);
      g_snprintf(buffer, 255, "%d", AccountsList[i].server.port);
      gtk_clist_set_text(GTK_CLIST(clist), i, 1, buffer);
      gtk_clist_set_text(GTK_CLIST(clist), i, 2, AccountsList[i].mailbox);
	}

   gtk_clist_thaw(GTK_CLIST(clist));
}

gint valid_info()
{
   GtkWidget *txtName  = get_widget(frmOptions, "txtName");
   GtkWidget *txtEmail = get_widget(frmOptions, "txtEmail");
   GtkWidget *txtHost  = get_widget(frmOptions, "txtSMTPserver");
   GtkWidget *spinPort  = get_widget(frmOptions, "spinSMTPport");
   GtkWidget *txtSigfile = get_widget(frmOptions, "txtSigfile");
   gchar *name, *email, *buffer;

   if (!strcmp("", gtk_entry_get_text(GTK_ENTRY(txtName))))
      return 0;
   name = gtk_entry_get_text(GTK_ENTRY(txtName));

   if (!strcmp("", gtk_entry_get_text(GTK_ENTRY(txtEmail))))
      return 0;
   email = gtk_entry_get_text(GTK_ENTRY(txtEmail));

   if (SenderAddr != NULL)
      g_free(SenderAddr);
   SenderAddr = g_malloc0(strlen(name) + 2 + strlen(email) + 2);
   sprintf(SenderAddr, "%s <%s>", name, email);

   if (!strcmp("", gtk_entry_get_text(GTK_ENTRY(txtHost))))
      return 0;
   buffer = gtk_entry_get_text(GTK_ENTRY(txtHost));

   if (SmtpServer.hostname != NULL)
      g_free(SmtpServer.hostname);
   SmtpServer.hostname = g_strdup(buffer);

   SmtpServer.port = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinPort));

   if (signaturefile != NULL)
      g_free(signaturefile);
   signaturefile = g_strdup(gtk_entry_get_text(GTK_ENTRY(txtSigfile)));

   return 1;
}
