/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __MAILBOX_H__
#define __MAILBOX_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "parse.h"
#include "mbox.h"

/* char *mailbox         file that contains the messages (Inbox, Outbox, etc)
 * char *message         the body/header of the message (same as returned from
 *                       mailbox_get_mesg(); )
 * int mesg_num          represents the mesg_num'th message in the mailbox
*/

extern guint32 *mailpos;

/* returns the actual mailbox dir/file */
gchar *get_mailbox(gchar *mailbox);

/* returns TRUE if it is a standard spruce mailbox */
gboolean mailbox_is_spruce_format(gchar *mbx, gboolean return_last_retval);

/* make a uid list */
gint mailbox_make_uid_list(GtkWidget *clistBoxes, guint num);

/* append this uid to the uid list */
gint mailbox_append_uid(gchar *uid);

/* do we already have this message somewhere? */
gboolean mailbox_have_uid(gchar *uid);

/* returns the number of messages in mailbox */
guint mailbox_get_num_mesgs (gchar *mailbox);

/* returns the body/header of the mesg_num'th message in mailbox */
gchar *mailbox_get_mesg (guint mesg_num, gchar *mailbox);

/* returns the subject of the message */
gchar *mailbox_get_mesg_subject (gchar *message);
/* #define mailbox_get_mesg_subject(a) mailbox_get_mesg_header_field((a), "Subject:") */

/* returns the name/addr of the Sender of the message */
gchar *mailbox_get_mesg_from (gchar *message);
/* #define mailbox_get_mesg_from(a) mailbox_get_mesg_header_field((a), "From:") */

/* returns the reply-to addr that the sender provided */
gchar *mailbox_get_mesg_replyto (gchar *message);
/* #define mailbox_get_mesg_replyto(a) mailbox_get_mesg_header_field((a), "Reply-To:") */

/* returns the date of the message */
gchar *mailbox_get_mesg_date (gchar *message);
/* #define mailbox_get_mesg_date(a) mailbox_get_mesg_header_field((a), "Date:") */

/* returns the xmailer of the message */
gchar *mailbox_get_mesg_xmailer (gchar *message);
/* #define mailbox_get_mesg_xmailer(a) mailbox_get_mesg_header_field((a), "X-Mailer:") */

/* returns the "field" of the message */
gchar *mailbox_get_mesg_header_field (gchar *message, gchar *field);

/* returns 1 if successful or 0 if it fails */
gint mailbox_del_mesgs (guint mesgs, guint *mesg_num, gchar *mailbox);

/* copies an email message from 1 mailbox to another - returns 1 if successful */
gint mailbox_copy_mesgs(guint mesgs, guint *mesg_num, gchar *orig_mailbox, gchar *new_mailbox);

/* moves an email message from 1 mailbox to another - returns 1 if successful */
gint mailbox_move_mesgs(guint mesgs, guint *mesg_num, gchar *orig_mailbox, gchar *new_mailbox);

/* returns 1 if successful or 0 if it fails */
gint mailbox_delete(gchar *mailbox);

/* returns 1 if successful or 0 if fail */
gint mailbox_create(gchar *mailbox);

/* returns the length of a header in bytes */
gint get_header_len(gchar *mesg);

/* returns a 'trimmed' header */
gchar *get_trimmed_header(gchar *mesg, gint trim_level, gint hdrlen);

/* trims the header information off of the body of the message. */
void trim_header(gchar *mesg, gint trim_level);

/* refresh the mailpos list after deleting/moving a message */
void mailbox_refresh_mailpos (guint num_ids, guint *ids, guint num_mesgs, gchar *mailbox);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
