/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "addrbook.h"

/* globals for addrbook */
static gchar abf[] = ".spruce/addrbook"; /* addressbook file name */
gint AddrListRow;                        /* row selected in the addr list */
gint AddrMaxRow;                         /* max row (currently) */
gboolean AddrAddOpen;                    /* is frmAddrAdd opened? */
GtkWidget *frmAddrAdd;

/* external variables */
extern gboolean AboutOpen;               /* is frmAbout opened?? */
extern GtkWidget *frmAbout;
extern gboolean AddrBookOpen;            /* is the frmAddrBook opened?? */
extern GtkWidget *frmAddrBook;
extern gboolean ComposerOpen;            /* is the composer opened?? */
extern GtkWidget *frmComposer;
extern gchar *AddrSelected;              /* addr selected in frmAddrBook */

static GtkWidget *txtField;

GtkWidget* create_frmAddrBook (GtkWidget *txtFld)
{
  GtkWidget *frmAddrBook;
  GtkWidget *fixed;
  GtkWidget *menubar;
  GtkWidget *mnuFile;
  GtkWidget *mnuFile_menu;
  GtkWidget *mnuAddrBookSave;
  GtkWidget *mnuAddrBookAdd_Contact;
  GtkWidget *mnuAddrBookDelete_Contact;
  GtkWidget *separator;
  GtkWidget *mnuAddrBookClose;
  GtkWidget *mnuHelp;
  GtkWidget *mnuHelp_menu;
  GtkWidget *mnuAddrBookAbout;
  GtkWidget *mnuAddrBookHowto;
  GtkWidget *cmdAddrBookAdd;
  GtkWidget *cmdAddrBookDelete;
  GtkWidget *cmdAddrBookSelect;
  GtkWidget *cmdAddrBookCancel;
  GtkWidget *scrlAddr;
  GtkWidget *clistAddrList;
  GtkWidget *lblName;
  GtkWidget *lblEmail;
  GtkWidget *lblMemo;

  frmAddrBook = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmAddrBook, "frmAddrBook");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "frmAddrBook", frmAddrBook);
  gtk_widget_set_usize (frmAddrBook, 450, 300);
  gtk_signal_connect_object (GTK_OBJECT (frmAddrBook), "destroy",
                             GTK_SIGNAL_FUNC (on_frmAddrBook_destroy),
                             GTK_OBJECT (frmAddrBook));
  gtk_signal_connect_object (GTK_OBJECT (frmAddrBook), "show",
                             GTK_SIGNAL_FUNC (on_frmAddrBook_show),
                             GTK_OBJECT (frmAddrBook));
  gtk_window_set_title (GTK_WINDOW (frmAddrBook), _("Spruce Address Book"));
  gtk_window_set_policy (GTK_WINDOW (frmAddrBook), FALSE, FALSE, FALSE);

  fixed = gtk_fixed_new ();
  gtk_widget_set_name (fixed, "fixed");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "fixed", fixed);
  gtk_widget_show (fixed);
  gtk_container_add (GTK_CONTAINER (frmAddrBook), fixed);

  menubar = gtk_menu_bar_new ();
  gtk_widget_set_name (menubar, "menubar");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "menubar", menubar);
  gtk_widget_show (menubar);
  gtk_fixed_put (GTK_FIXED (fixed), menubar, 0, 0);
  gtk_widget_set_uposition (menubar, 0, 0);
  gtk_widget_set_usize (menubar, 448, 24);

  mnuFile = gtk_menu_item_new_with_label (_("File"));
  gtk_widget_set_name (mnuFile, "mnuFile");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuFile", mnuFile);
  gtk_widget_show (mnuFile);
  gtk_container_add (GTK_CONTAINER (menubar), mnuFile);

  mnuFile_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuFile_menu, "mnuFile_menu");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuFile_menu", mnuFile_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuFile), mnuFile_menu);

  mnuAddrBookSave = gtk_menu_item_new_with_label (_("Save"));
  gtk_widget_set_name (mnuAddrBookSave, "mnuAddrBookSave");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuAddrBookSave", mnuAddrBookSave);
  gtk_widget_show (mnuAddrBookSave);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuAddrBookSave);
  gtk_signal_connect (GTK_OBJECT (mnuAddrBookSave), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAddrBookSave_activate),
                      NULL);

  mnuAddrBookAdd_Contact = gtk_menu_item_new_with_label (_("Add Contact"));
  gtk_widget_set_name (mnuAddrBookAdd_Contact, "mnuAddrBookAdd_Contact");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuAddrBookAdd_Contact", mnuAddrBookAdd_Contact);
  gtk_widget_show (mnuAddrBookAdd_Contact);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuAddrBookAdd_Contact);
  gtk_signal_connect (GTK_OBJECT (mnuAddrBookAdd_Contact), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAddrBookAdd_Contact_activate),
                      NULL);

  mnuAddrBookDelete_Contact = gtk_menu_item_new_with_label (_("Delete Contact"));
  gtk_widget_set_name (mnuAddrBookDelete_Contact, "mnuAddrBookDelete_Contact");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuAddrBookDelete_Contact", mnuAddrBookDelete_Contact);
  gtk_widget_show (mnuAddrBookDelete_Contact);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuAddrBookDelete_Contact);
  gtk_signal_connect (GTK_OBJECT (mnuAddrBookDelete_Contact), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAddrBookDelete_Contact_activate),
                      NULL);

  separator = gtk_menu_item_new ();
  gtk_widget_set_name (separator, "separator");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "separator", separator);
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), separator);

  mnuAddrBookClose = gtk_menu_item_new_with_label (_("Close"));
  gtk_widget_set_name (mnuAddrBookClose, "mnuAddrBookClose");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuAddrBookClose", mnuAddrBookClose);
  gtk_widget_show (mnuAddrBookClose);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuAddrBookClose);
  gtk_signal_connect (GTK_OBJECT (mnuAddrBookClose), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAddrBookClose_activate),
                      NULL);

  mnuHelp = gtk_menu_item_new_with_label (_("Help"));
  gtk_widget_set_name (mnuHelp, "mnuHelp");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuHelp", mnuHelp);
  gtk_widget_show (mnuHelp);
  gtk_container_add (GTK_CONTAINER (menubar), mnuHelp);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (mnuHelp));

  mnuHelp_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuHelp_menu, "mnuHelp_menu");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuHelp_menu", mnuHelp_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuHelp), mnuHelp_menu);

  mnuAddrBookAbout = gtk_menu_item_new_with_label (_("About..."));
  gtk_widget_set_name (mnuAddrBookAbout, "mnuAddrBookAbout");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuAddrBookAbout", mnuAddrBookAbout);
  gtk_widget_show (mnuAddrBookAbout);
  gtk_container_add (GTK_CONTAINER (mnuHelp_menu), mnuAddrBookAbout);
  gtk_signal_connect (GTK_OBJECT (mnuAddrBookAbout), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAddrBookAbout_activate),
                      NULL);

  mnuAddrBookHowto = gtk_menu_item_new_with_label (_("Howto"));
  gtk_widget_set_name (mnuAddrBookHowto, "mnuAddrBookHowto");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "mnuAddrBookHowto", mnuAddrBookHowto);
  gtk_widget_show (mnuAddrBookHowto);
  gtk_container_add (GTK_CONTAINER (mnuHelp_menu), mnuAddrBookHowto);
  gtk_signal_connect (GTK_OBJECT (mnuAddrBookHowto), "activate",
                      GTK_SIGNAL_FUNC (on_mnuAddrBookHowto_activate),
                      NULL);

  cmdAddrBookAdd = gtk_button_new_with_label (_("Add Contact"));
  gtk_widget_set_name (cmdAddrBookAdd, "cmdAddrBookAdd");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "cmdAddrBookAdd", cmdAddrBookAdd);
  gtk_widget_show (cmdAddrBookAdd);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAddrBookAdd, 8, 32);
  gtk_widget_set_uposition (cmdAddrBookAdd, 8, 32);
  gtk_widget_set_usize (cmdAddrBookAdd, 104, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAddrBookAdd), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAddrBookAdd_clicked),
                             GTK_OBJECT (cmdAddrBookAdd));

  cmdAddrBookDelete = gtk_button_new_with_label (_("Delete Contact"));
  gtk_widget_set_name (cmdAddrBookDelete, "cmdAddrBookDelete");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "cmdAddrBookDelete", cmdAddrBookDelete);
  gtk_widget_show (cmdAddrBookDelete);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAddrBookDelete, 120, 32);
  gtk_widget_set_uposition (cmdAddrBookDelete, 120, 32);
  gtk_widget_set_usize (cmdAddrBookDelete, 104, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAddrBookDelete), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAddrBookDelete_clicked),
                             GTK_OBJECT (cmdAddrBookDelete));

  cmdAddrBookSelect = gtk_button_new_with_label (_("Select"));
  gtk_widget_set_name (cmdAddrBookSelect, "cmdAddrBookSelect");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "cmdAddrBookSelect", cmdAddrBookSelect);
  gtk_widget_show (cmdAddrBookSelect);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAddrBookSelect, 272, 32);
  gtk_widget_set_uposition (cmdAddrBookSelect, 272, 32);
  gtk_widget_set_usize (cmdAddrBookSelect, 80, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAddrBookSelect), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAddrBookSelect_clicked),
                             GTK_OBJECT (cmdAddrBookSelect));

  cmdAddrBookCancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cmdAddrBookCancel, "cmdAddrBookCancel");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "cmdAddrBookCancel", cmdAddrBookCancel);
  gtk_widget_show (cmdAddrBookCancel);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAddrBookCancel, 360, 32);
  gtk_widget_set_uposition (cmdAddrBookCancel, 360, 32);
  gtk_widget_set_usize (cmdAddrBookCancel, 80, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAddrBookCancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAddrBookCancel_clicked),
                             GTK_OBJECT (cmdAddrBookCancel));

  scrlAddr = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrlAddr, "scrlAddr");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "scrlAddr", scrlAddr);
  gtk_widget_show (scrlAddr);
  gtk_fixed_put (GTK_FIXED (fixed), scrlAddr, 8, 72);
  gtk_widget_set_uposition (scrlAddr, 8, 72);
  gtk_widget_set_usize (scrlAddr, 440, 224);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrlAddr), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  clistAddrList = gtk_clist_new (3);
  gtk_widget_set_name (clistAddrList, "clistAddrList");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "clistAddrList", clistAddrList);
  gtk_widget_show (clistAddrList);
  gtk_container_add (GTK_CONTAINER (scrlAddr), clistAddrList);
  gtk_signal_connect_object (GTK_OBJECT (clistAddrList), "select_row",
                             GTK_SIGNAL_FUNC (on_clistAddrList_select_row),
                             GTK_OBJECT (clistAddrList));
  gtk_clist_set_column_width (GTK_CLIST (clistAddrList), 0, 150);
  gtk_clist_set_column_width (GTK_CLIST (clistAddrList), 1, 120);
  gtk_clist_set_column_width (GTK_CLIST (clistAddrList), 2, 120);
  gtk_clist_column_titles_show (GTK_CLIST (clistAddrList));
  /*gtk_clist_set_auto_sort (GTK_CLIST (clistAddrList), TRUE);*/

  lblName = gtk_label_new (_("Name"));
  gtk_widget_set_name (lblName, "lblName");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "lblName", lblName);
  gtk_widget_show (lblName);
  gtk_clist_set_column_widget (GTK_CLIST (clistAddrList), 0, lblName);

  lblEmail = gtk_label_new (_("Email"));
  gtk_widget_set_name (lblEmail, "lblEmail");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "lblEmail", lblEmail);
  gtk_widget_show (lblEmail);
  gtk_clist_set_column_widget (GTK_CLIST (clistAddrList), 1, lblEmail);
  
  lblMemo = gtk_label_new (_("Memo"));
  gtk_widget_set_name (lblMemo, "lblMemo");
  gtk_object_set_data (GTK_OBJECT (frmAddrBook), "lblMemo", lblMemo);
  gtk_widget_show (lblMemo);
  gtk_clist_set_column_widget (GTK_CLIST (clistAddrList), 2, lblMemo);
  
  txtField = txtFld;

  return frmAddrBook;
}

GtkWidget* create_frmAddrAdd ()
{
  GtkWidget *frmAddrAdd;
  GtkWidget *fixed;
  GtkWidget *txtName;
  GtkWidget *txtEmail;
  GtkWidget *txtMemo;
  GtkWidget *cmdAddrBookAddOK;
  GtkWidget *cmdAddrBookAddCancel;
  GtkWidget *lblName;
  GtkWidget *lblEmail;
  GtkWidget *lblMemo;

  frmAddrAdd = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmAddrAdd, "frmAddrAdd");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "frmAddrAdd", frmAddrAdd);
  gtk_widget_set_usize (frmAddrAdd, 345, 185);
  gtk_signal_connect_object (GTK_OBJECT (frmAddrAdd), "destroy",
                             GTK_SIGNAL_FUNC (on_frmAddrAdd_destroy),
                             GTK_OBJECT (frmAddrAdd));
  gtk_window_set_title (GTK_WINDOW (frmAddrAdd), _("Add Contact"));
  gtk_window_set_policy (GTK_WINDOW (frmAddrAdd), FALSE, FALSE, FALSE);

  fixed = gtk_fixed_new ();
  gtk_widget_set_name (fixed, "fixed");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "fixed", fixed);
  gtk_widget_show (fixed);
  gtk_container_add (GTK_CONTAINER (frmAddrAdd), fixed);

  txtName = gtk_entry_new ();
  gtk_widget_set_name (txtName, "txtName");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "txtName", txtName);
  gtk_widget_show (txtName);
  gtk_fixed_put (GTK_FIXED (fixed), txtName, 56, 24);
  gtk_widget_set_uposition (txtName, 56, 24);
  gtk_widget_set_usize (txtName, 280, 24);

  txtEmail = gtk_entry_new ();
  gtk_widget_set_name (txtEmail, "txtEmail");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "txtEmail", txtEmail);
  gtk_widget_show (txtEmail);
  gtk_fixed_put (GTK_FIXED (fixed), txtEmail, 56, 64);
  gtk_widget_set_uposition (txtEmail, 56, 64);
  gtk_widget_set_usize (txtEmail, 280, 24);
  
  txtMemo = gtk_entry_new ();
  gtk_widget_set_name (txtMemo, "txtMemo");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "txtMemo", txtMemo);
  gtk_widget_show (txtMemo);
  gtk_fixed_put (GTK_FIXED (fixed), txtMemo, 56, 104);
  gtk_widget_set_uposition (txtMemo, 56, 104);
  gtk_widget_set_usize (txtMemo, 280, 24);

  cmdAddrBookAddOK = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (cmdAddrBookAddOK, "cmdAddrBookAddOK");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "cmdAddrBookAddOK", cmdAddrBookAddOK);
  gtk_widget_show (cmdAddrBookAddOK);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAddrBookAddOK, 192, 144);
  gtk_widget_set_uposition (cmdAddrBookAddOK, 192, 144);
  gtk_widget_set_usize (cmdAddrBookAddOK, 64, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAddrBookAddOK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAddrBookAddOK_clicked),
                             GTK_OBJECT (cmdAddrBookAddOK));

  cmdAddrBookAddCancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cmdAddrBookAddCancel, "cmdAddrBookAddCancel");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "cmdAddrBookAddCancel", cmdAddrBookAddCancel);
  gtk_widget_show (cmdAddrBookAddCancel);
  gtk_fixed_put (GTK_FIXED (fixed), cmdAddrBookAddCancel, 272, 144);
  gtk_widget_set_uposition (cmdAddrBookAddCancel, 272, 144);
  gtk_widget_set_usize (cmdAddrBookAddCancel, 64, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdAddrBookAddCancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdAddrBookAddCancel_clicked),
                             GTK_OBJECT (cmdAddrBookAddCancel));

  lblName = gtk_label_new (_("Name:"));
  gtk_widget_set_name (lblName, "lblName");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "lblName", lblName);
  gtk_widget_show (lblName);
  gtk_fixed_put (GTK_FIXED (fixed), lblName, 0, 32);
  gtk_widget_set_uposition (lblName, 0, 32);
  gtk_widget_set_usize (lblName, 56, 16);

  lblEmail = gtk_label_new (_("Email:"));
  gtk_widget_set_name (lblEmail, "lblEmail");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "lblEmail", lblEmail);
  gtk_widget_show (lblEmail);
  gtk_fixed_put (GTK_FIXED (fixed), lblEmail, 0, 72);
  gtk_widget_set_uposition (lblEmail, 0, 72);
  gtk_widget_set_usize (lblEmail, 56, 16);
  
  lblMemo = gtk_label_new (_("Memo:"));
  gtk_widget_set_name (lblMemo, "lblMemo");
  gtk_object_set_data (GTK_OBJECT (frmAddrAdd), "lblMemo", lblMemo);
  gtk_widget_show (lblMemo);
  gtk_fixed_put (GTK_FIXED (fixed), lblMemo, 0, 112);
  gtk_widget_set_uposition (lblMemo, 0, 112);
  gtk_widget_set_usize (lblMemo, 56, 16);

  return frmAddrAdd;
}

void on_frmAddrBook_destroy (GtkObject *object, gpointer user_data)
{
   g_free(AddrSelected);           /* free the mem for AddrSelected */
   gtk_widget_destroy(frmAddrBook);
   AddrBookOpen = FALSE;
}

void on_frmAddrBook_show (GtkWidget *widget, gpointer user_data)
{
   AddrListRow = -1;
   AddrMaxRow = -1;
   AddrAddOpen = FALSE;

   read_addrbook();
}

void on_mnuAddrBookSave_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   write_addrbook();
}

void on_mnuAddrBookAdd_Contact_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if(!AddrAddOpen)
	{
      frmAddrAdd = create_frmAddrAdd();
      gtk_widget_show(frmAddrAdd);
      AddrAddOpen = TRUE;
   }
}

void on_mnuAddrBookDelete_Contact_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *clist = get_widget(frmAddrBook, "clistAddrList");

   if(AddrMaxRow >= 0 && AddrListRow >= 0)
	{
      AddrMaxRow--;
      gtk_clist_freeze(GTK_CLIST(clist));

      gtk_clist_remove(GTK_CLIST(clist), AddrListRow);

      if (AddrListRow > AddrMaxRow)
         AddrListRow = AddrMaxRow;

      gtk_clist_select_row(GTK_CLIST(clist), AddrListRow, 0);
      gtk_clist_moveto(GTK_CLIST(clist), AddrListRow, 0, 1.0, 0.0);

      gtk_clist_thaw(GTK_CLIST(clist));
	}
}

void on_mnuAddrBookClose_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   g_free(AddrSelected);  /* make the AddrSelected NULL */
   gtk_widget_destroy(frmAddrBook);
   AddrBookOpen = TRUE;
}

void on_mnuAddrBookAbout_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if(!AboutOpen)
	{
      frmAbout = create_frmAbout();
      gtk_widget_show(frmAbout);
      AboutOpen = TRUE;
	}
}

void on_mnuAddrBookHowto_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   /* will code on a later date */
}

void on_clistAddrList_select_row (GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data)
{
   GtkWidget *button = get_widget(frmAddrBook, "cmdAddrBookSelect");

   if (AddrListRow != row)
      AddrListRow = row;
   else
      on_cmdAddrBookSelect_clicked(GTK_BUTTON(button), NULL);
}

void on_cmdAddrBookAdd_clicked (GtkButton *button, gpointer user_data)
{
   if(!AddrAddOpen)
	{
      frmAddrAdd = create_frmAddrAdd();
      gtk_widget_show(frmAddrAdd);
      AddrAddOpen = TRUE;
	}
}

void on_cmdAddrBookDelete_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *clist = get_widget(frmAddrBook, "clistAddrList");

   if(AddrMaxRow >= 0 && AddrListRow >= 0)
     {
       AddrMaxRow--;
       gtk_clist_freeze(GTK_CLIST(clist));
       
       gtk_clist_remove(GTK_CLIST(clist), AddrListRow);
       
       if (AddrListRow > AddrMaxRow)
         AddrListRow = AddrMaxRow;
       
       AddrListRow--;
       gtk_clist_select_row(GTK_CLIST(clist), AddrListRow + 1, 0);
       gtk_clist_moveto(GTK_CLIST(clist), AddrListRow, 0, 1.0, 0.0);
       
       write_addrbook();
       
       gtk_clist_thaw(GTK_CLIST(clist));
     }
}

void on_cmdAddrBookSelect_clicked (GtkButton *button, gpointer user_data)
{
   if (AddrListRow >= 0)
   {
      GtkWidget *clist = get_widget(frmAddrBook, "clistAddrList");
      gchar *text1, *text2;

      fflush(stdout);
      gtk_clist_get_text(GTK_CLIST(clist), AddrListRow, 0, &text1);
      gtk_clist_get_text(GTK_CLIST(clist), AddrListRow, 1, &text2);

      AddrSelected = malloc(strlen(text1) + strlen(text2) + 6);
      sprintf(AddrSelected, "\"%s\" <%s>", text1, text2);

      if (ComposerOpen)
      {
         /* Add the selected address. */
         if (strlen(gtk_entry_get_text(GTK_ENTRY(txtField))) < 1)
         {
            gtk_entry_set_text(GTK_ENTRY(txtField), AddrSelected);
         }
         else
         {
            gtk_entry_append_text(GTK_ENTRY(txtField), "; ");
            gtk_entry_append_text(GTK_ENTRY(txtField), AddrSelected);
         }
      }
      else
      {
         frmComposer = create_frmComposer(NULL, AddrSelected, NULL, NULL);
         gtk_widget_show(frmComposer);
         ComposerOpen = 1;
      }
   }
   else
   {
      g_free(AddrSelected);
   }

   gtk_widget_hide(frmAddrBook);
   AddrBookOpen = FALSE;
}

void on_cmdAddrBookCancel_clicked (GtkButton *button, gpointer user_data)
{
   g_free(AddrSelected);                 /* make the AddrSelected NULL */
   gtk_widget_destroy(frmAddrBook);
   AddrBookOpen = FALSE;
}

void on_frmAddrAdd_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmAddrAdd);
   AddrAddOpen = FALSE;
}

void on_cmdAddrBookAddOK_clicked (GtkButton *button, gpointer user_data)
{
   GtkWidget *clist = get_widget(frmAddrBook, "clistAddrList");
   GtkWidget *name  = get_widget(frmAddrAdd, "txtName");
   GtkWidget *email = get_widget(frmAddrAdd, "txtEmail");
	GtkWidget *memo  = get_widget(frmAddrAdd, "txtMemo");
   gchar *text[3] = {"Name", "Email", "Memo"};

   AddrMaxRow++;
   AddrListRow = AddrMaxRow;
	
   gtk_clist_freeze(GTK_CLIST(clist));

   gtk_clist_append(GTK_CLIST(clist), (gchar**) text);
   gtk_clist_set_text(GTK_CLIST(clist), AddrMaxRow, 0, gtk_entry_get_text(GTK_ENTRY(name)));
   gtk_clist_set_text(GTK_CLIST(clist), AddrMaxRow, 1, gtk_entry_get_text(GTK_ENTRY(email)));
   gtk_clist_set_text(GTK_CLIST(clist), AddrMaxRow, 2, gtk_entry_get_text(GTK_ENTRY(memo)));

   AddrListRow--;
   gtk_clist_select_row(GTK_CLIST(clist), AddrListRow + 1, 0);
   gtk_clist_moveto(GTK_CLIST(clist), AddrListRow, 0, 1.0, 0.0);

   write_addrbook();

   gtk_clist_sort(GTK_CLIST(clist));

   gtk_clist_thaw(GTK_CLIST(clist));

   gtk_clist_moveto(GTK_CLIST(clist), AddrListRow, 0, 1.0, 0.0);
   
   gtk_widget_destroy(frmAddrAdd);
   AddrAddOpen = FALSE;
}


void on_cmdAddrBookAddCancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(frmAddrAdd);
   AddrAddOpen = FALSE;
}

gint read_addrbook()
{
   GtkWidget *clist = get_widget(frmAddrBook, "clistAddrList");
   gchar *filename = get_addrbook_path();
   FILE *fp;
	gchar buffer[257];
   gchar *text[3] = {"Name", "Email", "Memo"};

   fp = fopen(filename, "rt");
   if (fp == NULL)
   {
      fprintf(stderr, "Spruce: %s failed to open for reading.\n", filename);
      fprintf(stderr, "Please check with your local Administrator.\n");
      return 0;
   }

   AddrMaxRow = -1;
   AddrListRow = -1;

   gtk_clist_freeze(GTK_CLIST(clist));
   gtk_clist_clear(GTK_CLIST(clist));

   while (!feof(fp))
	{
      fgets(buffer, 256, fp);
      trim_leadspc(buffer);
      if(buffer[0] != '\n' && buffer[0] != '#')
		{
			AddrMaxRow++;
			gtk_clist_append(GTK_CLIST(clist), (gchar**) text);
			
         strcut(buffer, 0, strlen("Name:"));
         trim_whtspc(buffer);
         gtk_clist_set_text(GTK_CLIST(clist), AddrMaxRow, 0, (gchar*) buffer);
			
         fgets(buffer, 256, fp);
         strcut(buffer, 0, strlen("Email:"));
         trim_whtspc(buffer);
         gtk_clist_set_text(GTK_CLIST(clist), AddrMaxRow, 1, (gchar*) buffer);

         fgets(buffer, 256, fp);
         strcut(buffer, 0, strlen("Memo:"));
         trim_whtspc(buffer);
         gtk_clist_set_text(GTK_CLIST(clist), AddrMaxRow, 2, (gchar*) buffer);
      }
   }

   gtk_clist_sort(GTK_CLIST(clist));

   gtk_clist_thaw(GTK_CLIST(clist));

   g_free(filename);

   fclose(fp);
   return 1;
}

gint write_addrbook()
{
   GtkWidget *clist = get_widget(frmAddrBook, "clistAddrList");
   gchar *filename = get_addrbook_path();
   FILE *fp;
   gint i;
   gchar *name, *email, *memo;

   fp = fopen(filename, "wt");
   if (fp == NULL)
   {
      fprintf(stderr, "Spruce: %s failed to open for writing.\n", filename);
      fprintf(stderr, "Please check with your local Administrator.\n");
      return 0;
   }

   fprintf(fp, "# This is a generated file made by Spruce.\n");
   fprintf(fp, "# Please do NOT edit this by hand, please instead use\n");
   fprintf(fp, "# Spruce's address book editor to modify this file.\n\n");

   for(i = 0; i <= AddrMaxRow; i++)
	{
      gtk_clist_get_text(GTK_CLIST(clist), i, 0, &name);
      gtk_clist_get_text(GTK_CLIST(clist), i, 1, &email);
      gtk_clist_get_text(GTK_CLIST(clist), i, 2, &memo);
      fprintf(fp, "# Address %d\nName: %s\n", i, name);
      fprintf(fp, "Email: %s\n", email);
      fprintf(fp, "Memo: %s\n\n", memo);
	}
   fprintf(fp, "\n");

   fprintf(fp, "# End of address book file.\n");

   fclose(fp);

   g_free(filename);

   return 1;
}

gchar *get_addrbook_path()
{
   gchar *home_dir;
   gchar *buffer;

   home_dir = getenv("HOME");

   buffer = g_malloc(strlen(home_dir) + 1 + strlen(abf) + 1);
   sprintf(buffer, "%s/%s", home_dir, abf);

   return buffer;	
}
