/* the default inbox location on your system.  Defaults to _PATH_MAILDIR */
/* #define MAILDIR "/var/spool/mail" */

/* The place where mailleds will store its pid files.  NOTE:
   this directory doesn't need to be global writeable, as mailleds will
   write out the pidfile as root */
 
#ifndef DEBUG
#define PIDFILE_DIR  "/var/run"
#else
#define PIDFILE_DIR "/tmp"
#endif

/* Port to send data to.  NOTE: must be a paralell port, or you must
   know what you're doing!  You might screw up your sys with a bad port
   here. */
#define LPT_PORT 0x378
/* #define LPT_PORT 0x278 */

/* max number of virtual consoles (vt's) you will need */
#define MAX_CONSOLES 63

/* Time spent with leds on, leds off, and when -a is specified, time between 
   blink series.  These are "tune to your liking" type of params. */

/*  Martin likes these pauses, which give a _very_ quick, trekkie appeal to things. 
    Admittedly, they're easier to read the # of messages. 
    
    However, my led setup involves bright, eye-catching green lights. 
    These settings make me nervous. =) */
/*
#define BLINK_TIME_ON		40000
#define BLINK_TIME_OFF		20000
#define TIME_BETWEEN_COUNTS	80000
*/

/*  I prefer a slow, lethargic microsecond pause like this: */
#define BLINK_TIME_ON		400000
#define BLINK_TIME_OFF		300000
#define TIME_BETWEEN_COUNTS	700000

/* sleep time in seconds between mailbox checks (if there isn't any mail)
   This can be 1 considering it's just a stat now. 
*/
#define INTERVAL_BETWEEN_CHECKS 1

/* default keyboard leds to flash:
LED_SCR for scroll Lock, LED_NUM for Num Lock, LED_CAP for Caps Lock,
or 0 for none.
Boolean or these together to get the desired default.  
Just look at the examples. */

/* #define DEF_KBD_LEDS 0 */
/* #define DEF_KBD_LEDS LED_SCR | LED_NUM | LED_CAP */
#define DEF_KBD_LEDS LED_SCR

/* default parallel lights to flash.  Any boolean or combination
   of PORT_LED_[1-8] */
#define DEF_PORT_LEDS PORT_LED_1
