/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"exittrap.h"
#include	"config.h"
#include	<stdlib.h>

static const char rcsid[]="$Id: exittrap.C 1.2 1999/03/31 07:30:03 mrsam Exp $";

#if HAVE_UNISTD_H
#include	<unistd.h>
#else
extern "C" long alarm(long);
#endif

static ExitTrap *first=0, *last=0;

ExitTrap::ExitTrap() : next(0), prev(last), callcleanup(0)
{
	if (prev)	prev->next=this;
	else		first=this;
	last=this;
	callcleanup=1;
}

ExitTrap::~ExitTrap()
{
	callcleanup=0;
	if (prev)	prev->next=next;
	else		first=next;

	if (next)	next->prev=prev;
	else		last=prev;
}

void ExitTrap::onexit()
{
ExitTrap	*p;

	alarm(0);
	for (p=first; p; p=p->next)
		if (p->callcleanup)
			p->cleanup();
}

void ExitTrap::onfork()
{
ExitTrap	*p;

	alarm(0);
	for (p=first; p; p=p->next)
		if (p->callcleanup)
			p->forked();
}
