/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"maildirgetquota.h"
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<stdlib.h>
#include	<string.h>
#include	<fcntl.h>
#include	<sys/types.h>
#include	<sys/stat.h>

int	maildir_getquota(const char *dir, char buf[QUOTABUFSIZE])
{
char	*p;
struct	stat	stat_buf;
int	n;
int	l;

	p=(char *)malloc(strlen(dir)+sizeof("/maildirfolder"));
	if (!p)	return (-1);

	strcat(strcpy(p, dir), "/maildirfolder");
	if (stat(p, &stat_buf) == 0)
	{
		strcat(strcpy(p, dir), "/..");
		n=maildir_getquota(p, buf);
		free(p);
		return (n);
	}

	strcat(strcpy(p, dir), "/maildirsize");
	n=open(p, O_RDONLY);
	free(p);
	if (n < 0)	return (n);
	if ((l=read(n, buf, QUOTABUFSIZE-1)) < 0)
	{
		close(n);
		return (-1);
	}
	close(n);
	for (n=0; n<l; n++)
		if (buf[n] == '\n')	break;
	buf[n]=0;
	return (0);
}
