/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"maildircreate.h"
#include	<sys/types.h>
#if	HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#include	<time.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<string.h>
#include	<errno.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	"numlib/numlib.h"

static const char rcsid[]="$Id: maildircreateh.c,v 1.2 1999/09/21 01:50:53 mrsam Exp $";

int maildir_try_create_hostname(const char *m,	/* Maildir */
	const char *u,	/* Unique when creating multiple msgs by one pid */
	unsigned long s,	/* If >0, we know the size of the message */
	const char *h,	/* Hostname */
	char **tptr,	/* On exit, filename in tmp */
	char **nptr)	/* On exit, filename in new */
{
time_t	t;
pid_t	p;
unsigned l=strlen(m)+strlen(h)+(u ? strlen(u)+1:0)+200;
struct	stat stat_buf;

char	tbuf[NUMBUFSIZE];
char	pbuf[NUMBUFSIZE];

	time(&t);
	p=getpid();
	if ( (*tptr=(char *)malloc(l)) == 0 )	return (-1);
	if ( (*nptr=(char *)malloc(l)) == 0 )
	{
		free(*tptr);
		return (-1);
	}
	strcpy(*tptr, m);
	l=strlen(*tptr);
	if (l && (*tptr)[l-1] == '/')	--l;
	sprintf( (*tptr)+l,
		(s ? "/tmp/%s.%s%s%s.%s,S=%lu":"/tmp/%s.%s%s%s.%s"),
		str_time_t(t, tbuf),
		str_pid_t(p, pbuf),
		(u && u ? "_":""),
		(u && u ? u:""),
		h,
		s);
	strcpy( (*nptr), (*tptr) );
	memcpy( (*nptr)+l+1, "new", 3);

	if (stat( (*nptr), &stat_buf) < 0 && errno == ENOENT)
		return (0);
	free( *nptr );
	free( *tptr );
	return (-1);
}
