
static char rcsid[] = "@(#)$Id: signals.c,v 1.4.6.1 1999/08/27 04:06:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4.6.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This set of routines traps various signals and informs the
    user of the error, leaving the program in a nice, graceful
    manner.

**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

extern int pipe_abort;		/* set to TRUE if receive SIGPIPE */

SIGHAND_TYPE
quit_signal(sig)
{
	dprint(1, (debugfile, "\n\n** Received SIGQUIT **\n\n\n\n"));
	leave(!InGetPrompt);
}

SIGHAND_TYPE
hup_signal(sig)
{
	dprint(1, (debugfile, "\n\n** Received SIGHUP **\n\n\n\n"));
	leave(!InGetPrompt);
}

SIGHAND_TYPE
term_signal(sig) 
{
	dprint(1, (debugfile, "\n\n** Received SIGTERM **\n\n\n\n"));
	leave(!InGetPrompt);
}

SIGHAND_TYPE
ill_signal(sig)
{
	MoveCursor(elm_LINES,0);
	Raw(OFF);
	dprint(1, (debugfile, "\n\n** Received SIGILL **\n\n\n\n"));
	printf(catgets(elm_msg_cat, ElmSet, ElmIllegalInstructionSignal,
		"\n\nIllegal Instruction signal!\n\n"));
	emergency_exit(!InGetPrompt);
}

SIGHAND_TYPE
fpe_signal(sig)  
{
	MoveCursor(elm_LINES,0);
	Raw(OFF);
	dprint(1, (debugfile, "\n\n** Received SIGFPE **\n\n\n\n"));
	printf(catgets(elm_msg_cat, ElmSet, ElmFloatingPointSignal,
		"\n\nFloating Point Exception signal!\n\n"));
	emergency_exit(!InGetPrompt);
}

#ifdef SIGBUS
SIGHAND_TYPE
bus_signal(sig)
{
	MoveCursor(elm_LINES,0);
	Raw(OFF);
	dprint(1, (debugfile, "\n\n** Received SIGBUS **\n\n\n\n"));
	printf(catgets(elm_msg_cat, ElmSet, ElmBusErrorSignal,
		"\n\nBus Error signal!\n\n"));
	emergency_exit(!InGetPrompt);
}
#endif

SIGHAND_TYPE
segv_signal(sig)
{
	MoveCursor(elm_LINES,0);
	Raw(OFF);
	dprint(1, (debugfile,"\n\n** Received SIGSEGV **\n\n\n\n"));
	printf(catgets(elm_msg_cat, ElmSet, ElmSegmentViolationSignal,
		"\n\nSegment Violation signal!\n\n"));
	emergency_exit(!InGetPrompt);
}

SIGHAND_TYPE
alarm_signal(sig)
{	
	signal(SIGALRM, alarm_signal);

	/** silently process alarm signal for timeouts... **/
	if (InGetPrompt)
		{
#ifdef HASSIGHOLD
		sigrelse(SIGALRM);
#endif
		LONGJMP(GetPromptBuf, 1);
		}
}

SIGHAND_TYPE
pipe_signal(sig)
{
	/** silently process pipe signal... **/
	dprint(2, (debugfile, "*** received SIGPIPE ***\n\n"));
	
	pipe_abort = TRUE;	/* internal signal ... wheeee!  */

	signal(SIGPIPE, pipe_signal);
}

#ifdef SIGTSTP
int was_in_raw_state;

SIGHAND_TYPE
sig_user_stop(sig)
{
	dprint(1, (debugfile,"\n\n** Received SIGTSTP **\n\n\n\n"));
	/* This is called when the user presses a ^Z to stop the
	   process within BSD 
	*/

	redraw_screen = 1;

#ifdef	SIGTSTP
	signal(SIGTSTP, SIG_DFL);
#endif

	was_in_raw_state = RawState();
	Raw(OFF);	/* turn it off regardless */

	printf(catgets(elm_msg_cat, ElmSet, ElmStoppedUseFGToReturn,
		"\n\nStopped.  Use \"fg\" to return to ELM\n\n"));

	kill(getpid(), SIGSTOP);
}

SIGHAND_TYPE
sig_return_from_user_stop(sig)
{  
	/** this is called when returning from a ^Z stop **/
	dprint(1, (debugfile,"\n\n** Received SIGCONT **\n\n\n\n"));

	redraw_screen = 1;

	signal(SIGCONT, sig_return_from_user_stop);
	signal(SIGTSTP, sig_user_stop);

	printf(catgets(elm_msg_cat, ElmSet, ElmBackInElmRedraw,
	 "\nBack in ELM. (You might need to explicitly request a redraw.)\n\n"));

	if (was_in_raw_state)
	  Raw(ON);

	if (InGetPrompt)
		{
#ifdef HASSIGHOLD
		sigrelse(SIGTSTP);
		sigrelse(SIGCONT);
#endif
		LONGJMP(GetPromptBuf, 1);
		}
}
#endif

#ifdef SIGWINCH
SIGHAND_TYPE
winch_signal(sig)
{
	resize_screen = 1;
	redraw_screen = 1;

	signal(SIGWINCH, winch_signal);

	if (InGetPrompt)
		{
#ifdef HASSIGHOLD
		sigrelse(SIGWINCH);
#endif
		LONGJMP(GetPromptBuf, 1);
		}
}
#endif

SIGHAND_TYPE
usr1_signal(sig)
{
  int result;

  dprint(1, (debugfile, "\n\n** Received SIGUSR1 **\n\n\n\n"));
  if (!InGetPrompt) {
    dprint(1, (debugfile, "-- Not in prompt -- can't leave folder\n"));
    return;
  }

  question_me = FALSE;
  while (current_folder &&
	 (result = leave_mbox(TRUE, FALSE, TRUE)) == -1)
    newmbox(current_folder->cur_folder, TRUE);

  if (result >= 0) 
    leave(!InGetPrompt);
}

SIGHAND_TYPE
usr2_signal(sig)
{
  int result;
  
  dprint(1, (debugfile, "\n\n** Received SIGUSR2 **\n\n\n\n"));
  if (!InGetPrompt) {
    dprint(1, (debugfile, "-- Not in prompt -- can't leave folder\n"));
    return;
  }

  while (current_folder &&
	 (result = leave_mbox(FALSE, TRUE, FALSE)) == -1)
    newmbox(current_folder->cur_folder, TRUE);

  if (result >= 0)
    leave(!InGetPrompt);
}
