
static char rcsid[] = "@(#)$Id: mime.c,v 1.3 1999/01/25 19:19:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/


#include "headers.h"
#include "s_elm.h"
#include "me.h"

extern int errno;

int check_for_multipart(filedesc, mime_info)
     FILE *filedesc;
     mime_send_t *mime_info;
{
  char buffer[SLEN];
  int Multi_Part = FALSE;
  char *ptr;
  char *incptr;
  char Include_Filename[SLEN];
  char Expanded_Filename[SLEN];

  while (mail_gets(buffer, SLEN, filedesc))
    if (buffer[0] == '[') {
      if (strncmp(buffer, MIME_INCLUDE, strlen(MIME_INCLUDE)) == 0) {
      	Multi_Part = TRUE;
	if (Include_Part((FILE *)NULL, buffer, TRUE, mime_info, FALSE) == -1) {
	   return(-1);
	}
      }
    }
    rewind(filedesc);
  return(Multi_Part);
}

int
Include_Part(dest, buffer, check, mime_info, copy)
     FILE *dest;
     char *buffer;
     int  check;
     mime_send_t *mime_info;
     int copy;
{
  char *ptr;
  char *incptr;
  char Include_Filename[SLEN];
  char Expanded_Filename[SLEN];
  char tmp_fn[SLEN];
  char *filename;
  char Primary_Type[SLEN];
  char SubType[SLEN];
  char Params[STRING];
  char Encoding[SLEN];
  char sh_buffer[SLEN];
  char Encode_Flag[3];
  int  Enc_Type;
  FILE *incfile;
  int  line_len;
  int is_text;

  ptr = buffer + strlen(MIME_INCLUDE);
  while ((*ptr != '\0') && (*ptr == ' '))
    ptr++;
  incptr = Include_Filename;
  while ((*ptr != ' ') && (*ptr != ']') && (*ptr != '\0') &&
	 (incptr < Include_Filename + sizeof(Include_Filename) -1))
    *incptr++ = *ptr++;
  *incptr = '\0';

  while ((*ptr != '\0') && (*ptr == ' '))
    ptr++;
  incptr = Primary_Type;
  while ((*ptr != ' ') && (*ptr != ']') && (*ptr != '\0') && (*ptr!='/')
	 && (*ptr != ';') 
	 && (incptr < Primary_Type + sizeof(Primary_Type) -1))
    *incptr++ = *ptr++;
  *incptr = '\0';
  while ((*ptr != '\0') && (*ptr == ' '))
    ptr++;
  incptr = SubType;
  if (*ptr == '/') {
    ptr++;
    while ((*ptr != '\0') && (*ptr == ' '))
      ptr++;
    while ((*ptr != ' ') && (*ptr != ']') && (*ptr != '\0') && (*ptr!=';')
	   && (incptr < SubType + sizeof(SubType) -1))
      *incptr++ = *ptr++;
  }
  *incptr = '\0';
  while ((*ptr != '\0') && (*ptr == ' '))
    ptr++;
  incptr = Params;
  while (*ptr == ';') {
    ptr++;
    if (incptr > Params) {
      *incptr++ = ';';
    } else if (*ptr == ' ')
      ptr++;

    while ((*ptr != '\0') && (*ptr == ' ')
	   && (incptr < Params + sizeof(Params) -1))
      *incptr++ = *ptr++;

    while ((*ptr != ' ') && (*ptr != ']') && (*ptr != '\0') && (*ptr!=';')
	   && (incptr < Params + sizeof(Params) -1))
      *incptr++ = *ptr++;
    while ((*ptr != '\0') && (*ptr == ' '))
      ptr++;
  }
  *incptr = '\0';

  while ((*ptr != '\0') && (*ptr == ' '))
    ptr++;
  incptr = Encoding;
  while ((*ptr != ' ') && (*ptr != ']') && (*ptr != '\0')
	 && (incptr < Encoding + sizeof(Encoding) -1))
    *incptr++ = *ptr++;
  *incptr = '\0';

  if (strlen(Include_Filename) == 0) {
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoIncludeFilename,
		      "No Filename given, include line ignored"));
    if (sleepmsg > 0)
	    sleep(sleepmsg);
    return(-1);
  }
  (void) expand_env(Expanded_Filename, Include_Filename, 
		    sizeof(Expanded_Filename));

  if (strlen(Primary_Type) == 0 || strlen(SubType) == 0 ) {
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoContentTypeGiven,
                    "No Content-type given, include line ignored"));
    if (sleepmsg > 0)
	    sleep(sleepmsg);
    return(-1);
  }

  Enc_Type = check_encoding(Encoding);

  if (Enc_Type == ENCODING_ILLEGAL) {
        lib_error(CATGETS(elm_msg_cat, ElmSet, ElmEncodingIsIllegal,
			  "Encoding is illegal"));
	if (sleepmsg > 0)
		sleep(sleepmsg);
	return(-1);
  }

  if (can_open(Expanded_Filename, "r")) {
        lib_error(CATGETS(elm_msg_cat, ElmSet, ElmIncludeCannotAccess,
			"Include File can't be accessed"), 0);
	if (sleepmsg > 0)
		sleep(sleepmsg);
	return(-1);
  }

  /* Don't allow 7BIT if 8-bit charcters in any type,    
   * don't allow 8BIT if 'binary' characters       - K E H */
  if (Enc_Type == ENCODING_7BIT || Enc_Type == ENCODING_NONE
      || Enc_Type == ENCODING_8BIT) {
    
    FILE * fp = fopen (Expanded_Filename, "r");
    if (fp) {
      int tmp = needs_encoding (fp);
      if (tmp & HAVE_BINARY) {

	lib_error(CATGETS(elm_msg_cat, ElmSet,ElmIncludeBINARY,
			  "Include file has BINARY data."));
	
	sleep_message();
	
	if (Enc_Type == ENCODING_7BIT || Enc_Type == ENCODING_8BIT) {
	  if (check)
	    return -1; /* indicate failure */
	}
	
	Enc_Type = ENCODING_BINARY;

      } else if ((tmp & HAVE_8BIT) && Enc_Type != ENCODING_8BIT) {
	
	lib_error (CATGETS(elm_msg_cat, ElmSet,ElmInclude8BIT,
			   "Include file has 8BIT data."));
	
	sleep_message();
	
	if (Enc_Type == ENCODING_7BIT) {
	  if (check)
	    return -1; /* indicate failure */
	}
	
	Enc_Type = ENCODING_8BIT;
	
      }
      fclose(fp);
    }
  }

  if (Enc_Type == ENCODING_8BIT) {
#ifndef USE_8BITMIME
    if (allow_no_encoding < 1) {
      Enc_Type = ENCODING_QUOTED;
      lib_error (CATGETS(elm_msg_cat, ElmSet,ElmDoesnt8BIT,
			 "Mailer (MTA) doesn't support 8BIT encoding."));

      sleep_message();

      if (check)
	return -1; /* indicate failure */
    }
#endif
  }

  if (Enc_Type == ENCODING_BINARY) {
#ifndef USE_BINARYMIME
    if (allow_no_encoding < 2) {
      /* Convert to QUOTED-PRINTABLE */
      Enc_Type = ENCODING_QUOTED;
      lib_error (CATGETS(elm_msg_cat, ElmSet,ElmDoesntBINARY,
			 "Mailer (MTA) doesn't support BINARY encoding!"));
      sleep_message();
      if (check)
	return (-1);
    }
#endif
  }

  is_text = is_text_type(Primary_Type, SubType, Enc_Type);
  /* 1 if is text type (true)
   * 0 if not text type
   * -1 if can't be encoded (ie structured) Message/ or Multipart/ 
   */
    
  if (is_text < 0 && (Enc_Type == ENCODING_QUOTED ||
		      Enc_Type == ENCODING_BASE64)) {
      lib_error(CATGETS(elm_msg_cat, ElmSet,ElmDontEncoding,
		     "Content-Type don't allow encoding -- ignoring this part."));
      sleep_message();
      return (-1);
  }


  (void) update_encoding(&(mime_info->encoding_top),Enc_Type);

  if (check) {
	return(0);
  }

  incfile = fopen (Expanded_Filename, "r");
  if (incfile) {

    dprint (10, (debugfile, 
		 "Include_Part: '%s' C-T=%s/%s Params=%s Enc=%d is_text=%d\n",
		 Expanded_Filename,Primary_Type,SubType, Params, Enc_Type,
		 is_text));

    fprintf(dest, "%s %s/%s", MIME_CONTENTTYPE, Primary_Type, SubType);
    if (Params[0] == '\0') 
      print_EOLN(dest,mime_info->encoding_top);
    else { 
      if (strlen(Primary_Type) + strlen(SubType) + strlen(Params) > 60) {
	fprintf(dest,";");
	print_EOLN(dest,mime_info->encoding_top);
	fputc('\t',dest);
      } else
	fprintf(dest,"; ");
      fprintf(dest,"%s",Params);
      print_EOLN(dest,mime_info->encoding_top);
    }

    {
      char buf[STRING];
      buf [0] = 0;

      add_parameter(buf,"filename",Include_Filename,sizeof(buf),0);
      
      /* When user uses [include ...] it is better use disposition
       * 'inline' instead of 'attachment'
       */
      fprintf(dest,"Content-Disposition: inline; %s",buf);
      print_EOLN(dest,mime_info->encoding_top);
    }

    if (Enc_Type != ENCODING_NONE) {
      if (Enc_Type < ENCODING_EXPERIMENTAL) 
	fprintf(dest, "%s %s", MIME_CONTENTENCOD, 
		ENCODING(Enc_Type));
      else /* For ENCODING_EXPERIMENTAL */
	fprintf(dest, "%s %s", MIME_CONTENTENCOD, Encoding);
      print_EOLN(dest,mime_info->encoding_top);
    }
    print_EOLN(dest,mime_info->encoding_top);

    /* encoding rules are different for text and no text 
     * for text we must do \n -> \r\n before base64 encoding */
    
    /* For ENCODING_EXPERIMENTAL this is already supposed to be encoded */
    (void)write_encoded(incfile,dest,Enc_Type,copy,is_text,mime_info);
    
    fclose(incfile);
  }
  else {
    MoveCursor(elm_LINES, 0);
    Raw(OFF);
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantOpenIncludedFile,
		    "Can't open included File"));
    emergency_exit(0);
  }
  return(0);
}


/* Determine whether or not the data in "fp" needs to be QUOTED-PRINTABLE
    encoded.  Used when sending a message.
       1 == have 8bit data                (HAVE_8BIT)
       4 == have control charcters        (HAVE_CTRL)
       8 == mime requires encoding BINARY (HAVE_BINARY)
*/

int needs_encoding (fp)
     FILE *fp;
{
  int ch;
  int ret = FALSE;
  int len = 0;

  rewind (fp);
  while ((ch = fgetc (fp)) != EOF) {
    /* check for end of line */
    if (ch == 13) {   /* CR */
      ch = fgetc(fp);
      if (ch != 10) {  /* Not CR LF */
	dprint (3, (debugfile, "\nneeds_encoding(): found CR without LF\n"));
	ret |= HAVE_BINARY;
      }
      if (ch == EOF)
	break;
    }
    if (ch == 10) {
      len = 0;
      continue; /* skip newlines and tabs */
    }
    len++;
    if (len > 990) {
      dprint (3, (debugfile,"\nneeds_encoding(): Line over 990 characters\n"));
	ret |= HAVE_BINARY;
    }

    if (ch == 9) /* skip newlines and tabs */
      continue;
    if (ch < 32 || ch > 126) {
      dprint (3, (debugfile, "\nneeds_encoding(): found char decimal=%d\n", ch));
      if (ch == 0) 
	ret |= HAVE_BINARY;
      if (ch < 32 || ch == 127)
	ret |= HAVE_CTRL;
      if (ch > 127)
	ret |= HAVE_8BIT;
    }
    if (ret == (HAVE_8BIT | HAVE_CTRL | HAVE_BINARY))
      break;

  }
  rewind (fp);
  return (ret);
}

char *error_description();

int have_metamail()
{
  int return_value = 1;
  
  if (strcmp(metamail_path,"none") == 0 || 
      metamail_path[0] == '\0') {
    return_value = 0;
  } else if (metamail_path[0] == '/') {
    if (-1 == access(metamail_path,EXECUTE_ACCESS)) {
      int err = errno;
      lib_error(CATGETS(elm_msg_cat, ElmSet,ElmCantMetamail,
			"Can't execute metamail: %s.30: %.30s"),
	     metamail_path,
	     error_description(err));
      dprint(5,(debugfile,"have_metamail: no access %s: %s\n",metamail_path,
		error_description(err)));
      sleep_message();
      return_value = 0;
    }
  }

  dprint(5,(debugfile,"have_metamail=%d\n",return_value));
  return return_value;
}


