static char rcsid[] = "@(#)$Id: output.c,v 1.5.2.1 1999/09/01 16:11:52 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5.2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"

static int def_err_handler P_((CONST char *str));
static int def_err_handler (str) 
     CONST char *str;
{
  int ret;
  int l = strlen(str);
  ret = fprintf(stderr,"%s",str);
  if (ret > 0 && l && str[l-1] != '\n')
    ret += fprintf(stderr,"\n");
  return ret;
}

static err_handler *H = def_err_handler;
extern void set_error_handler (h)
     err_handler *h;
{
  H = h;
}



char *elm_message P_((CONST char * format, CONST char *msg, ...));
int elm_sfprintf P_((char *buffer, int size,
		    CONST char * format, CONST char *msg, ...));


char *elm_vmessage P_((int max_alloc,
		       CONST char *format, CONST char *msg, 
		       va_list args));


char *elm_vmessage (max_alloc,format,msg,vl)
     int max_alloc;
     CONST char *format;
     CONST char *msg;
     va_list vl;
{

  CONST char * s;
  char * store1 = NULL;
  int ptr1 = 0, alloced1 = 0;

  struct store2 {
    char * store;
    int ptr;
    int alloced;
  } * store2 = NULL;
  int store2_len = 0;
  int i,pos;

  int overflow_flag = 0;

  dprint(75,(debugfile,"elm_vmessage: max_alloc=%d, format=%s\n",
	     max_alloc,format));
  dprint(75,(debugfile,"              msg=%s\n",msg));


#define ENLARGE(ptr,alloced,S) do { if (ptr >= alloced) { \
    S = safe_realloc(S,alloced+10); alloced += 10; } } while(0)
#define PUTC1(c) do { ENLARGE(ptr1,alloced1,store1); store1[ptr1++] = c; } \
  while(0)
#define PUTC2(c) do { ENLARGE(store2[store2_len-1].ptr,\
   store2[store2_len-1].alloced,store2[store2_len-1].store); \
   store2[store2_len-1].store[store2[store2_len-1].ptr++] = c; } \
while(0)
#define NEW_STORE do { \
  store2 = safe_realloc(store2, \
  (store2_len+1) * sizeof (struct store2)); store2_len++; \
  store2[store2_len-1].store = NULL; store2[store2_len-1].alloced = 0; \
  store2[store2_len-1].ptr = 0; } while(0);
#define INC(p) { (p)++; if (!*(p)) break; }


  for (s = format; *s; s++) {
    int fill = ' ';
    int left = 0;
    int plus = 0;
    int val1 = 0, val2 = 0;
    int long_f = 0;
    if (*s != '%') {
      continue;
    }
    INC(s);

    if ('%' == *s) {
      continue;
    }
    NEW_STORE;


  again1:
    if ('0' == *s)      { fill = '0'; INC(s); }
    else if ('-' == *s) { left = 1;   INC(s); }
    else if ('+' == *s) { plus = 1;   INC(s); }
    
    if (*s >= '1' && *s <= '9') {
      while (*s >= '0' && *s <= '9') {
	val1 = val1 * 10 + *s - '0';
	INC(s);
      }

      if (*s == '$') {
	val1 = 0;
	INC(s);
	dprint(75,(debugfile,
		   "elm_vmessage: --- Positional args are not allowed in: %s\n",
		   format));
	goto error1;
      }

    } else if ('*' == *s) { 
      val1 = va_arg(vl,int);
      INC(s);
    }

    if ('.' == *s) {
      INC(s);
      if (*s >= '1' && *s <= '9') {
	while (*s >= '0' && *s <= '9') {
	  val2 = val2 * 10 + *s - '0';
	  INC(s);
	}
      } else if ('*' == *s) { 
	val2 = va_arg(vl,int);
	INC(s);
      }      
    }
     
    if ('l' == *s) { 
      long_f = 1;
      INC(s);
    }

    switch(*s) {
      CONST char *str, *a;
      int base;
      char *seq;

      int l,c;
      long val,valz;
      unsigned long r;
      unsigned long r1;
      int quote;

    case 'c':
      c = va_arg(vl, int);      
      dprint(75,(debugfile,"elm_vmessage: [c] val1=%d, c=%c\n",
		 val1,c));
      l = 1;
      while (l < val1 && !left) { PUTC2(fill); l++; }
      PUTC2(c);
      while (l < val1 && left) { PUTC2(' '); l++; }
      break;
    case 's': case 'Q':
      str = va_arg(vl, char *);
      if (!str)
	goto error1;

      quote = ('Q' == *s);

      l = strlen(str);
      if (quote) {
	  l += 2;
	  for (a=str; *a; a++) {
	      if (*a == '\\' || *a == '"')
		  l++;
	  }
      }
      if (val2 <= 0) val2 = l;
      if (quote)
	  val2 -= 2;
      dprint(75,(debugfile,"elm_vmessage: [%c] val1=%d, val2=%d, str=%s\n",
		 *s,val1,val2,str));
      while (l < val1 && !left) { PUTC2(fill); l++; }

      if (quote) {
	  PUTC2('"'); 
      }
      for (a = str; *a && a - str < val2; a++) { 
	  if (quote && (*a == '\\' || *a == '"')) {
	      PUTC2('\\'); 
	  }
	  PUTC2(*a); 
	  if (max_alloc > 0 && a - str > max_alloc) {
	      dprint(1,(debugfile,
			"elm_vmessage: --- too long string (max=%d): %.30s...\n",
			max_alloc,str));
	      break;
	  }
      }
      if (quote) {
	  PUTC2('"'); 
      }
      while (l < val1 && left) { PUTC2(' '); l++; }
      break;
    case 'd': case 'x': case 'X':
      switch (*s) {
      case 'd': seq = "0123456789"; base = 10; break;
      case 'x': seq = "0123456789abcdef"; base = 16; break;
      case 'X': seq = "0123456789ABCDEF"; base = 16; break;
      }
      if (long_f)
	val = va_arg(vl, long);
      else
	val = va_arg(vl, int);
      c = 0;
      if (val < 0) {
	c = '-'; val1--;
	val = -val;
      } else if (plus) {
	c = '+'; val1--;
      }
      dprint(75,(debugfile,"elm_vmessage: [d] val1=%d, val2=%d, c=%c, val=%ld, base=%d, seq=%s\n",
		 val1,val2,c, val,base,seq));
      l = 0;
      valz = val;
      r1 = 1;
      do {
	r = (valz / base);
	valz = r;
	l++;
	r1 *= (long) base;
      } while(r);
      while (l < val1 && !left && fill != '0') { PUTC2(fill); l++; }
      if (c) { PUTC2(c); }
      while (l < val1 && !left && fill == '0') { PUTC2('0');  l++; }
      valz = val;
      while(r1 >= (long) base) {
	r1 /= (long) base;
	r = (valz / r1);
	PUTC2( seq[r]);
	valz -= r * r1;
      } 
      while (l < val1 && left) { PUTC2(' '); l++; }
      break;
    default:
      dprint(75,(debugfile,"elm_vmessage: [%c] ????\n",*s));
    error1:
      dprint(75,(debugfile,"elm_vmessage: --- error\n"));
    }
    PUTC2('\0');
  }

  for (i = 0; i < store2_len; i++) {
      dprint(75,(debugfile,"elm_vmessage:  - %d: %.*s\n",i,
		 store2[i].ptr,NONULL(store2[i].store)));
  }

  pos = -1;
  /* Actual printing */
  for (s = msg; *s; s++) {
    int val1 = 0;
    if (*s != '%') {
      PUTC1(*s);
      continue;
    }
    INC(s);

    if ('%' == *s) {
      PUTC1(*s);
      continue;
    }
    pos++;

  again2:
    if ('0' == *s)      { INC(s); }
    else if ('-' == *s) { INC(s); }
    else if ('+' == *s) { INC(s); }
    
    if (*s >= '1' && *s <= '9') {
      while (*s >= '0' && *s <= '9') {
	val1 = val1 * 10 + *s - '0';
	INC(s);
      }
      if ('$' == *s) {
	pos = val1;
	val1 = 0;
	goto again2;
      }
    } else if ('*' == *s) { 
      INC(s);
    }

    if ('.' == *s) {
      INC(s);
      if (*s >= '1' && *s <= '9') {
	while (*s >= '0' && *s <= '9') {
	  INC(s);
	}
      } else if ('*' == *s) { 
	INC(s);
      }      
    }
     
    if ('l' == *s) { 
      INC(s);
    }

    switch(*s) {
      CONST char *str,*a;
    case 's': case 'Q': case 'd': case 'c': case 'x': case 'X':
      if (pos < 0 || pos >= store2_len)
	goto error2;
      str = store2[pos].store;
      if (!str)
	goto error2;
      dprint(75,(debugfile,"elm_vmessage: [%c] str=%s\n",*s,str));
      for (a = str; *a; a++) { 
	PUTC1(*a); 
      }
      break;
    default:
      dprint(75,(debugfile,"elm_vmessage: [%c] ????\n",*s));
    error2:
      dprint(75,(debugfile,"elm_vmessage: --- error\n"));
      PUTC1('[');
      PUTC1('?');
      PUTC1(']');
    }
  }

  PUTC1('\0');
#undef PUTC1
#undef INC
#undef PUTC2
#undef NEW_STORE

  for (i = 0; i < store2_len; i++) {
    if (store2[i].store)
      free(store2[i].store);
  }
  free(store2);

  return store1;
}

int lib_error P_((CONST char * format, CONST char *msg, ...));

int lib_error (
#if ANSI_C
			      CONST char * format, 
			      CONST char *msg, ...
#else
			      format, msg, va_alist
#endif
			      )
#if !ANSI_C
     CONST char * format;
     CONST char *msg;
     va_dcl
#endif
{
  int ret = 0;
  va_list vl;
  char * store1;

  dprint(75,(debugfile,"lib_error: format=%s\n",format));
  dprint(75,(debugfile,"              msg=%s\n",msg));
  	            
  Va_start(vl, msg);           /* defined in defs.h */
  
  store1 = elm_vmessage(0,format,msg,vl);

  va_end(vl);

  ret = H(store1);
  free(store1);
  return ret;
}

char *elm_message (
#if ANSI_C
		   CONST char * format, 
		   CONST char *msg, ...
#else
		   format, msg, va_alist
#endif
		)   
#if !ANSI_C
     CONST char * format; 
     CONST char *msg;
     va_dcl
#endif
{
  va_list vl;
  char * store1;

  dprint(75,(debugfile,"elm_message: format=%s\n",format));
  dprint(75,(debugfile,"             msg=%s\n",msg));
  	            
  Va_start(vl, msg);           /* defined in defs.h */
  
  store1 = elm_vmessage(0,format,msg,vl);

  va_end(vl);

  return store1;
}

int elm_sfprintf (
#if ANSI_C
		 char * buffer, int size,
		 CONST char * format, 
		 CONST char *msg, ...
#else
		 buffer, size, format, msg, va_alist
#endif
		)   
#if !ANSI_C
     char * buffer;
     int size;
     CONST char * format; 
     CONST char *msg;
     va_dcl
#endif
{
  va_list vl;
  char * store1;

  dprint(75,(debugfile,"elm_sfprintf: size=%d, format=%s\n",size, format));
  dprint(75,(debugfile,"             msg=%s\n",msg));
  	            
  Va_start(vl, msg);           /* defined in defs.h */
  
  store1 = elm_vmessage(size-1,format,msg,vl);

  va_end(vl);

  strfcpy(buffer,store1,size);
  free(store1);
  return strlen(buffer);
}

int elm_fprintf (
#if ANSI_C
		 FILE *f, CONST char * format, CONST char *msg, ...
#else
		 f, format,msg, va_alist
#endif
		 )
#if !ANSI_C
     FILE *f;
     CONST char * format;
     CONST char *msg;
     va_dcl     
#endif
{
    int ret;

    va_list vl;
    char * store1;
    
    dprint(75,(debugfile,"elm_fprintf: format=%s\n",format));
    dprint(75,(debugfile,"             msg=%s\n",msg));
    
    Va_start(vl, msg);           /* defined in defs.h */
    
    store1 = elm_vmessage(0,format,msg,vl);
    
    va_end(vl);
    
    ret = fputs(store1,f);    
    if (ret != EOF)
	ret = strlen(store1);
    free(store1);
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
