
static char rcsid[] = "@(#)$Id: mk_lockname.c,v 1.2 1998/10/20 19:57:47 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include "headers.h"

static char lock_name[SLEN];

char * mk_lockname(file_to_lock)
     char *file_to_lock;
{
      /** Create the proper name of the lock file for file_to_lock,
            which is presumed to be a spool file full path (see
            get_folder_type()), and put it in the static area lock_name.
            Return lock_name for informational purposes.
       **/

#ifdef XENIX
        /* lock is /tmp/[basename of file_to_lock].mlk */
        elm_sfprintf(lock_name, sizeof lock_name,
		     FRM("/tmp/%.10s.mlk"), rindex(file_to_lock, '/')+1);
#else
        /* lock is [file_to_lock].lock */
        elm_sfprintf(lock_name, sizeof lock_name,
		     FRM("%s.lock"), file_to_lock);
#endif
        return(lock_name);
}

