// resource.hh for bbmail - an tool to display new mail in X11.
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "bbmail.hh"
#include "spoollist.hh"
#include "Baseresource.hh"

class SpoolList;
class BaseResource;

struct FRAME {
  int width;
  int height;
  BTexture texture;
  int bevelWidth;
  XFontStruct *font;
};

struct POSITION {
	int x;
	int y;
	int mask;
};

struct LABEL {
	int width;
	int width0, width1, width2, width3;
	int height;
	bool transparent;
	BTexture texture;
	XFontStruct *font;
	BColor newmail_textColor;
	BColor totalmail_textColor;
	BColor seperator_textColor;
	BColor newmail_boring_textColor;
	BColor totalmail_boring_textColor;
	BColor seperator_boring_textColor;
};

struct MENU {
	BTexture texture;
	BColor textColor;
	BColor highlightColor;
	BColor hitextColor;
	int justify;
	XFontStruct *font;
  int bullet_style;
  int bullet_pos;
};

struct ENVELOPE {
	int width;
	int height;
	BTexture texture;
	BTexture texture_pressed;
  	BColor textColor;
	BColor error_textColor;
	int bevelWidth;
};

struct SHOW {
  bool newmail_counter;
  bool totalmail_counter;
  bool label;
  bool envelope;
  bool onlyAtNewMail;
};

struct REPORT {
  bool auto_raise;
  unsigned int check_delay;
  unsigned int force_check_delay;
  bool force_check;
  int number_of_spoolfiles;
  int number_of_digits;
  char *runCommand;
};


class Resource : public BaseResource
{

  public:
  	Resource(ToolWindow *);
	~Resource(void);

	struct FRAME frame; 
	struct LABEL label;
	struct POSITION position;
	struct ENVELOPE envelope;
	struct SHOW show;
	struct REPORT report;
	struct MENU menu;
	SpoolList *spoolfile;

  /* menu */
 	const int getJustification(void) const {return LeftJustify; }
	int getMenuJustification(void) { return menu.justify; }	
	XFontStruct *getTitleFont(void) { return menu.font; }
	XFontStruct *getMenuFont(void) { return menu.font; }
	unsigned int getBevelWidth(void) { return frame.bevelWidth; }
  BColor *getBorderColor(void) { return frame.texture.getColor(); }
  unsigned int getBorderWidth(void) { return 0; }
  int getBulletStyle(void) { return menu.bullet_style; }
  int getBulletPosition(void) { return menu.bullet_pos; }

  
  enum { AlignDontCare = 1, AlignTop, AlignBottom };
  enum { Right = 1, Left };
  enum { Empty = 0, Round, Square, Triangle, Diamond };
  enum { LeftJustify = 1, RightJustify, CenterJustify };

  protected:
  	virtual void  LoadBBToolResource(void);

  private:
	void Frame(void);
	void SizeAndPosition(void);
	void MailCheckSettings(void);
	void Label(void);
	void Show(void);
	void Envelope(void);
	void MailboxDep(void);
	void Menu(void);
	
	void Clean(void);
};
#endif /* __RESOURCE_HH */
