/*								-*- C++ -*-
 * $Id: WIN_frame.h,v 1.2 1999/08/20 12:16:41 wg Exp $
 *
 * Purpose: base class for all frames
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Frame_h
#define Frame_h

#ifdef __GNUG__
#pragma interface
#endif

class wxIcon;

class wxMenuBar;
class wxMessage;
class wxToolBar;

class wxFrame : public wxPanel {
DECLARE_DYNAMIC_CLASS(wxFrame)
public:
    wxFrame(void);
    wxFrame(wxFrame *parent, Const char *title, int x=-1, int y=-1,
	    int width=-1, int height=-1, int style=wxDEFAULT_FRAME,
	    Constdata char *name=wxFrameNameStr);
    ~wxFrame(void);
    // frame creation
    Bool  Create(wxFrame *parent, Const char *title, int x=-1, int y=-1,
		 int width=-1, int height=-1, int style=wxDEFAULT_FRAME,
		 Constdata char *name=wxFrameNameStr);
    // override resize methods
    void  Centre(int direction=wxBOTH);
    void  GetPosition(int *x, int *y);
    void  GetToolSizes(int *mheight, int *sheight, int *twidth, int *theight);
    void  SetClientSize(int x, int y, int width, int height);
    void  SetSize(int x, int y, int width, int height, int flags=wxSIZE_AUTO);
    void  SetClientSize(int width, int height)
	{ SetClientSize(-1, -1, width, height); }
    void  SetSize(int width, int height)
	{ SetSize(-1, -1, width, height, wxSIZE_USE_EXISTING); }
    // status line
    void  CreateStatusLine(int number=1);
    void  SetStatusText(Const char *text, int number=0);
    Bool  StatusLineExists(void) const;
    // change and query state of frame
    void  Iconize(Bool iconize);
    Bool  Iconized(void) const;
    Bool  IsMapped(void) const;
    void  Maximize(Bool maximize);
    // associated GDI objects
    wxMenuBar* GetMenuBar(void);
    wxToolBar* GetToolBar(void);
    void       SetIcon(wxIcon *icon);
    void       SetMenuBar(wxMenuBar *menubar);
    void       SetToolBar(wxToolBar *toolbar, int alignment=wxALIGN_TOP);
    // miscellaneous
    void  Command(int id);
    void  ChangeColours(void);
    void  LoadAccelerators(char *resource);
    void  MakeModal(Bool mod);
    void  SetModal(Bool mod) { modal = mod; }
    Bool  Show(Bool show);
    // special hints for the window manager
    void  GetBaseSize (int *base_width, int *base_height);
    void  SetBaseSize (int  base_width, int  base_height);
    void  GetIncrement(int *x_inc,      int *y_inc);
    void  SetIncrement(int  x_inc,      int  y_inc);
    void  GetMaxSize  (int *max_width,  int *max_height);
    void  SetMaxSize  (int  max_width,  int  max_height);
    void  GetMinSize  (int *min_width,  int *min_height);
    void  SetMinSize  (int  min_width,  int  min_height);
    // virtual event functions
    Bool  OnCharHook(wxKeyEvent& event);
    Bool  OnHotKey(wxKeyEvent& event);
    void  OnCommand(wxWindow& win, wxCommandEvent& event);
    void  OnDefaultAction(wxItem *initiatingItem);
    void  OnMenuSelect(int id);
protected:
    // resize before calls of OnMove and OnSize
    void PreResize(int x=-1, int y=-1, int width=-1, int height=-1);
protected:
    wxMenuBar  *menubar;
    wxToolBar  *toolbar;
    int        toolbar_pos;
    wxMessage  **status;
    wxIcon     icon;
    int        num_status;
    Bool       being_destroyed;
    Bool       modal, modal_showing;
};

#endif // Frame_h
