/*								-*- C++ -*-
 * $Id: DLG_ps.cpp,v 1.2 1998/03/31 22:19:04 wg Exp $
 *
 * Purpose: postscript dialog
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#define  Uses_wxDialogBase
#define  Uses_wxMessage
#define  Uses_wxPostScriptDC
#define  Uses_wxPrintSetup
#define  Uses_wxRadioBox
#define  Uses_wxText
#include "wx.h"

Bool wxPostScriptDC::PrinterDialog(wxWindow *parent)
{
    Bool answer;

    wxDialogBase *box
	= wxNEW wxDialogBase(NULL, NULL, "Printer Settings",
			     wxOK | wxCANCEL, parent, -1, -1);
    box->SetLabelPosition(wxHORIZONTAL);

    float      xs, ys, xt, yt;
    wxText     *cmd, *flags, *x_scale, *y_scale, *x_trans, *y_trans;
    wxRadioBox *orient, *target;
    wxMessage  *msg;
    char       *str_orient[] = { "Portrait", "Landscape", "EPS" };
    char       *str_target[] = { "Printer", "File", "Preview" };
    wxThePrintSetupData->GetPrinterTranslation(&xt, &yt);
    wxThePrintSetupData->GetPrinterScaling(&xs, &ys);

    // top line
    msg = new wxMessage(box, "Command", 100, -1, 90, -1, wxUSE_BUTTON_FONT);
    msg->SetAlignment(wxALIGN_LEFT);
    msg = new wxMessage(box, "Options",  -1, -1, 280, -1, wxUSE_BUTTON_FONT);
    msg->SetAlignment(wxALIGN_LEFT);
    box->NewLine(0);
    // printer line
    msg = new wxMessage(box, "Printer", 0, -1, 95, -1);
    msg->SetAlignment(wxALIGN_RIGHT);
    cmd     = wxNEW wxText(box, NULL, NULL, wxThePrintSetupData->GetPrinterCommand(), 100, -1,  90);
    flags   = wxNEW wxText(box, NULL, NULL, wxThePrintSetupData->GetPrinterOptions(),  -1, -1, 280);
    box->NewLine();
    // output line
    msg = new wxMessage(box, "Output to", 0, -1, 95, -1);
    msg->SetAlignment(wxALIGN_RIGHT);
    target  = wxNEW wxRadioBox(box, NULL, NULL, 100, -1, 375, -1,
			       3, str_target, 4, wxNO_BORDER | wxHORIZONTAL);
              target->SetSelection(wxThePrintSetupData->GetPrinterMode());
    box->NewLine();
    box->NewLine();
    // orientation line
    msg = new wxMessage(box, "Orientation", 0, -1, 95, -1);
    msg->SetAlignment(wxALIGN_RIGHT);
    orient  = wxNEW wxRadioBox(box, NULL, NULL, 100, -1, 375, -1,
			       3, str_orient, 4, wxNO_BORDER | wxHORIZONTAL);
              orient->SetSelection(wxThePrintSetupData->GetPrinterOrientation());
    box->NewLine();
    // scaling line
    msg = new wxMessage(box, "Scaling", 0, -1, 95, -1);
    msg->SetAlignment(wxALIGN_RIGHT);
    x_scale = wxNEW wxText(box, NULL, NULL, wxFloatToString(xs), 100, -1, 90);
    msg = new wxMessage(box, "times X", -1, -1, 90, -1, wxUSE_BUTTON_FONT);
    msg->SetAlignment(wxALIGN_LEFT);
    y_scale = wxNEW wxText(box, NULL, NULL, wxFloatToString(ys),  -1, -1, 90);
    msg = new wxMessage(box, "times Y", -1, -1, 90, -1, wxUSE_BUTTON_FONT);
    msg->SetAlignment(wxALIGN_LEFT);
    box->NewLine();
    // translation line
    msg = new wxMessage(box, "Offset", 0, -1, 95, -1);
    msg->SetAlignment(wxALIGN_RIGHT);
    x_trans = wxNEW wxText(box, NULL, NULL, wxFloatToString(xt), 100, -1, 90);
    msg = new wxMessage(box, "of X", -1, -1, 90, -1, wxUSE_BUTTON_FONT);
    msg->SetAlignment(wxALIGN_LEFT);
    y_trans = wxNEW wxText(box, NULL, NULL, wxFloatToString(yt),  -1, -1, 90);
    msg = new wxMessage(box, "of Y", -1, -1, 90, -1, wxUSE_BUTTON_FONT);
    msg->SetAlignment(wxALIGN_LEFT);

    // wait for input
    if ((answer = (box->GetInput()==wxOK))) {
	wxThePrintSetupData->SetPrinterCommand(cmd->GetValue());
	wxThePrintSetupData->SetPrinterOptions(flags->GetValue());
	wxThePrintSetupData->SetPrinterOrientation(orient->GetSelection());
	wxThePrintSetupData->SetPrinterMode(target->GetSelection());
	StringToFloat(x_scale->GetValue(), &wxThePrintSetupData->printer_scale_x);
	StringToFloat(y_scale->GetValue(), &wxThePrintSetupData->printer_scale_y);
	StringToFloat(x_trans->GetValue(), &wxThePrintSetupData->printer_translate_x);
	StringToFloat(y_trans->GetValue(), &wxThePrintSetupData->printer_translate_y);
    }
    delete box;
    return answer;
}
