/*								-*- C++ -*-
 * $Id: DLG_font.cpp,v 1.4 1997-02-28 16:04:02+01 mho Exp $
 *
 * Purpose: font dialog box
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1996, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1996, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "DLG_font.h"
#endif

#define  Uses_wxButton
#define  Uses_wxCheckBox
#define  Uses_wxChoice
#define  Uses_wxFontDialog
#define  Uses_wxMessage
#define  Uses_wxText
#include "wx.h"

extern int NUM_COLS;
extern char *wxColourDialogNames[];

/*
 * FONT DIALOG
 */

IMPLEMENT_DYNAMIC_CLASS(wxFontData, wxObject)

wxFontData::wxFontData(void)
{
  // Intialize colour to black.
  fontColour.Set(0, 0, 0);

  showHelp = FALSE;
  allowSymbols = TRUE;
  enableEffects = TRUE;
  initialFont = NULL;
  chosenFont = NULL;
  minSize = 0;
  maxSize = 0;
}

wxFontData::~wxFontData(void)
{
}

void wxFontData::operator=(const wxFontData& data)
{
   fontColour = (wxColour&)data.fontColour;
   showHelp = data.showHelp;
   allowSymbols = data.allowSymbols;
   enableEffects = data.enableEffects;
   initialFont = data.initialFont;
   chosenFont = data.chosenFont;
   minSize = data.minSize;
   maxSize = data.maxSize;
}

/*
 * Generic wxFontDialog
 */

Bool wxGenericFontDialog::fontDialogCancelled = FALSE;

IMPLEMENT_DYNAMIC_CLASS(wxGenericFontDialog, wxDialogBox)

wxGenericFontDialog::wxGenericFontDialog(void)
{
  dialogParent = NULL;
  dialogFont = NULL;
  fontDialogCancelled = FALSE;
}

wxGenericFontDialog::wxGenericFontDialog(wxWindow *parent, wxFontData *data):
  wxDialogBox(parent, "Font", TRUE, 0, 0, 600, 600)
{
  dialogFont = NULL;
  fontDialogCancelled = FALSE;
  Create(parent, data);
}

wxGenericFontDialog::~wxGenericFontDialog(void)
{
}

Bool wxGenericFontDialog::OnClose(void)
{
  fontDialogCancelled = TRUE;
  Show(FALSE);
  return FALSE;
}
 
Bool wxGenericFontDialog::OnCharHook(wxKeyEvent& event)
{
  if (event.KeyCode() == WXK_ESCAPE)
  {
    fontDialogCancelled = TRUE;
    Show(FALSE);
    return TRUE;
  }
  else return FALSE;
}

Bool wxGenericFontDialog::Create(wxWindow *parent, wxFontData *data)
{
  dialogParent = parent;
  
  if (data)
    fontData = *data;

  InitializeFont();
  CreateWidgets();
  
  return TRUE;
}

Bool wxGenericFontDialog::Show(Bool flag)
{
  //wxBeginBusyCursor();
  wxDialogBox::Show(flag);
  //wxEndBusyCursor();
  
  if (flag)
  {
    GetDC()->SetFont(NULL);
    if (fontDialogCancelled)
    {
      fontData.chosenFont = NULL;
      if (dialogFont)
        delete dialogFont;
      return FALSE;
    }
    else
    {
      fontData.chosenFont = dialogFont;
      return TRUE;
    }
  }
  return TRUE;
}


// Internal functions
void wxGenericFontDialog::OnEvent(wxMouseEvent& event)
{
  wxDialogBox::OnEvent(event);
}

void wxGenericFontDialog::OnPaint(void)
{
  wxDialogBox::OnPaint();
  PaintFontBackground();
  PaintFont();
}

static void wxGenericFontOk(wxButton& but, wxCommandEvent& WXUNUSED(event))
{
  wxGenericFontDialog *dialog = (wxGenericFontDialog *)but.GetParent();
  dialog->OnOk();
}

static void wxGenericFontCancel(wxButton& but, wxCommandEvent& WXUNUSED(event))
{
  wxGenericFontDialog *dialog = (wxGenericFontDialog *)but.GetParent();
  dialog->OnCancel();
}

static void wxGenericChangeFont(wxItem& but, wxCommandEvent& WXUNUSED(event))
{
  wxGenericFontDialog *dialog = (wxGenericFontDialog *)but.GetParent();
  dialog->OnChangeFont();
}

static void wxGenericChangeFontText(wxText& text, wxCommandEvent& event)
{
  if (event.GetEventType() == wxEVENT_TYPE_TEXT_ENTER_COMMAND)
  {
    wxGenericFontDialog *dialog = (wxGenericFontDialog *)text.GetParent();
    dialog->OnChangeFont();
  }
}

// Layout sizes
#define SP  5
#define C1  0
#define C2  75
#define C3  200
#define C4  325
#define LWD 60
#define WD  120

void wxGenericFontDialog::CreateWidgets(void)
{
  wxBeginBusyCursor();

  SetHorizontalMargin(2*SP);
  SetVerticalMargin(2*SP);

  char *families[] = { "Roman", "Decorative", "Modern", "Script", "Swiss" };
  char *styles[] = { "Normal", "Italic", "Slant" };
  char *weights[] = { "Normal", "Light", "Bold" };

  wxMessage *msg;

  (void)new wxMessage(this, "Family", C2, SP);
  (void)new wxMessage(this, "Style",  C3, SP);
  (void)new wxMessage(this, "Weight", C4, SP);
  NewLine(SP);

  msg = new wxMessage(this, "Font", C1, -1, LWD, -1);
  msg->SetAlignment(wxALIGN_RIGHT);
  familyChoice = new wxChoice(this, (wxFunction)wxGenericChangeFont, NULL, C2, -1, WD, -1, 5, (char **)families);
  styleChoice = new wxChoice(this, (wxFunction)wxGenericChangeFont,  NULL, C3, -1, WD, -1, 3, (char **)styles);
  weightChoice = new wxChoice(this, (wxFunction)wxGenericChangeFont, NULL, C4, -1, WD, -1, 3, (char **)weights);
  NewLine(SP);

  msg = new wxMessage(this, "Size", C1, -1, LWD, -1);
  msg->SetAlignment(wxALIGN_RIGHT);
  pointSizeText = new wxText(this, (wxFunction)wxGenericChangeFontText, NULL, "", C2, -1, WD, -1, wxPROCESS_ENTER);
  underLineCheckBox = new wxCheckBox(this, (wxFunction)wxGenericChangeFont, "Underline", C3);
  NewLine(SP);

  msg = new wxMessage(this, "Colour", C1, -1, LWD, -1);
  msg->SetAlignment(wxALIGN_RIGHT);
  colourChoice = new wxChoice(this, (wxFunction)wxGenericChangeFont, NULL, C2, -1, 2*WD+SP, -1, NUM_COLS, wxColourDialogNames);
  NewLine(SP);

  // compute size of rectangle
  fontRect.x = C2;
  int dummy; GetCursor(&dummy, &fontRect.y);
  fontRect.height = 100;
  fontRect.width = 3 * WD + 2 * SP - 1;

  NewLine(SP + fontRect.height);

  wxButton *okButton = new wxButton(this, (wxFunction)wxGenericFontOk, "OK", 150, -1, 70, -1);
  (void) new wxButton(this, (wxFunction)wxGenericFontCancel, "Cancel", 225, -1, 70, -1);
  
  familyChoice->SetStringSelection(wxFontFamilyIntToString(dialogFont->GetFamily()));
  styleChoice->SetStringSelection(wxFontStyleIntToString(dialogFont->GetStyle()));
  weightChoice->SetStringSelection(wxFontWeightIntToString(dialogFont->GetWeight()));
  char *name = wxTheColourDatabase->FindName(fontData.fontColour);
  if (name)
    colourChoice->SetStringSelection(name);
    
  underLineCheckBox->SetValue(dialogFont->GetUnderlined());

  char buf[40];
  sprintf(buf, "%d", dialogFont->GetPointSize());
  pointSizeText->SetValue(buf);

  okButton->SetDefault();

  Fit();
  Centre(wxBOTH);

  wxEndBusyCursor();
}

void wxGenericFontDialog::InitializeFont(void)
{
  int fontFamily = wxSWISS;
  int fontWeight = wxNORMAL;
  int fontStyle = wxNORMAL;
  int fontSize = 12;
  int fontUnderline = FALSE;
  if (fontData.initialFont)
  {
    fontFamily = fontData.initialFont->GetFamily();
    fontWeight = fontData.initialFont->GetWeight();
    fontStyle = fontData.initialFont->GetStyle();
    fontSize = fontData.initialFont->GetPointSize();
    fontUnderline = fontData.initialFont->GetUnderlined();
  }
  dialogFont = new wxFont(fontSize, fontFamily, fontStyle, fontWeight, fontUnderline);

}

void wxGenericFontDialog::PaintFontBackground(void)
{
  wxDC *dc = GetDC();

  dc->BeginDrawing();

  dc->SetPen(wxBLACK_PEN);
  dc->SetBrush(wxWHITE_BRUSH);
  dc->DrawRectangle(fontRect.x, fontRect.y, fontRect.width, fontRect.height);
  dc->EndDrawing();
}

void wxGenericFontDialog::PaintFont(void)
{
  wxDC *dc = GetDC();
  dc->BeginDrawing();
  if (dialogFont)
  {
    dc->SetFont(dialogFont);
    // Calculate vertical centre
    float w, h;
    dc->GetTextExtent("X", &w, &h);
    float cx = fontRect.x + 10;
    float cy = (float)(fontRect.y + (fontRect.height/2.0) - (h/2.0));
    dc->SetTextForeground(&fontData.fontColour);
    dc->SetClippingRegion(fontRect.x, fontRect.y, fontRect.width-2.0, fontRect.height-2.0);
    dc->DrawText("ABCDEFGabcdefg12345", cx, cy);
    dc->DestroyClippingRegion();
  }
  dc->EndDrawing();
}

void wxGenericFontDialog::OnOk(void)
{
  Show(FALSE);
}

void wxGenericFontDialog::OnCancel(void)
{
  fontDialogCancelled = TRUE;
  Show(FALSE);
}

void wxGenericFontDialog::OnChangeFont(void)
{
  int fontFamily = wxFontFamilyStringToInt(familyChoice->GetStringSelection());
  int fontWeight = wxFontWeightStringToInt(weightChoice->GetStringSelection());
  int fontStyle = wxFontStyleStringToInt(styleChoice->GetStringSelection());
  int fontSize = atoi(pointSizeText->GetValue());
  int fontUnderline = underLineCheckBox->GetValue();

  dialogFont = new wxFont(fontSize, fontFamily, fontStyle, fontWeight, fontUnderline);
  if (colourChoice->GetStringSelection())
  {
    wxColour *col = wxTheColourDatabase->FindColour(colourChoice->GetStringSelection());
    if (col)
    {
      fontData.fontColour = *col;
    }
  }
  PaintFontBackground();
  PaintFont();
}

char *wxFontWeightIntToString(int weight)
{
  switch (weight)
  {
    case wxLIGHT:
      return "Light";
    case wxBOLD:
      return "Bold";
    case wxNORMAL:
    default:
      return "Normal";
  }
  return "Normal";
}

char *wxFontStyleIntToString(int style)
{
  switch (style)
  {
    case wxITALIC:
      return "Italic";
    case wxSLANT:
      return "Slant";
    case wxNORMAL:
    default:
      return "Normal";
  }
  return "Normal";
}

char *wxFontFamilyIntToString(int family)
{
  switch (family)
  {
    case wxROMAN:
      return "Roman";
    case wxDECORATIVE:
      return "Decorative";
    case wxMODERN:
      return "Modern";
    case wxSCRIPT:
      return "Script";
    case wxSWISS:
    default:
      return "Swiss";
  }
  return "Swiss";
}

int wxFontFamilyStringToInt(char *family)
{
  if (!family)
    return wxSWISS;
    
  if (strcmp(family, "Roman") == 0)
    return wxROMAN;
  else if (strcmp(family, "Decorative") == 0)
    return wxDECORATIVE;
  else if (strcmp(family, "Modern") == 0)
    return wxMODERN;
  else if (strcmp(family, "Script") == 0)
    return wxSCRIPT;
  else return wxSWISS;
}

int wxFontStyleStringToInt(char *style)
{
  if (!style)
    return wxNORMAL;
  if (strcmp(style, "Italic") == 0)
    return wxITALIC;
  else if (strcmp(style, "Slant") == 0)
    return wxSLANT;
  else
    return wxNORMAL;
}

int wxFontWeightStringToInt(char *weight)
{
  if (!weight)
    return wxNORMAL;
  if (strcmp(weight, "Bold") == 0)
    return wxBOLD;
  else if (strcmp(weight, "Light") == 0)
    return wxLIGHT;
  else
    return wxNORMAL;
}
