/* $Id: fatal.c,v 1.5 1998/07/05 16:57:03 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            fatal.c
 *  MODULE OF       shhmsg - library for displaying messages.
 *
 *  DESCRIPTION     Function for displaying an error message and
 *                  abort the program.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "internal.h"
#include "shhmsg.h"

/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          msgFatal
 *
 *  FUNCTION      Show given message and abort the program.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                void msgFatal(const char *format, ...);
 *
 *  INPUT         format, ...
 *                        Arguments used as with printf().
 *
 *  RETURNS       Never returns. The program is aborted.
 *
 *  DESCRIPTION   Prints the name of this program followed by ": " and
 *                the given message on the _msgErrorStream, then aborts
 *                the program.
 */
void
msgFatal(const char *format, ...)
{
    va_list ap;

    fflush(stdout);
    fprintf(_msgErrorStream, "%s: ", msgGetName());
    va_start(ap, format);
    vfprintf(_msgErrorStream, format, ap);
    va_end(ap);
    exit(99);
}
