/* ************************************************************* *
 *   The Amulet User Interface Development Environment           *
 * ************************************************************* *
 *   Created automatically by the Gilt program in Amulet.        *
 *   Do not edit this file directly.                             *
 *   For more information on Amulet, contact amulet@cs.cmu.edu   *
 * ************************************************************* *
 *   Generated on Mon Jun  9 09:18:07 1997

 *   Amulet version 3.0 Beta
 * ************************************************************* */

#include <amulet.h>
// #include SCRIPTING__H
#include SCRIPTING_ADVANCED__H

Am_Object Am_Script_Window;

Am_Slot_Key Am_EXECUTE_COUNTER = Am_Register_Slot_Name ("Am_EXECUTE_COUNTER");

Am_Define_Formula(bool, ok_to_remove_formula) {
  Am_Object window = self.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  return window.Get(Am_SCRIPT_EXECUTE_COMMAND).Valid();
}

Am_Define_Method(Am_Object_Method, void, increment_counter,
		 (Am_Object inter)) {
  Am_Object counter_widget = inter.Get_Sibling(Am_EXECUTE_COUNTER);
  int val = 4*(int)counter_widget.Get(Am_VALUE);
  counter_widget.Set(Am_VALUE, val);
  Am_Object execute_cmd = inter.Get_Sibling(Am_SCRIPT_EXECUTE_COMMAND);
 std::cout << "Setting count of " << execute_cmd << " to " << val <<std::endl <<std::flush;
  execute_cmd.Set(Am_EXECUTE_COUNTER, val);
}
Am_Define_Method(Am_Object_Method, void, count_set, (Am_Object cmd)) {
  Am_Object counter_widget = cmd.Get(Am_SAVED_OLD_OWNER);
  Am_Object execute_cmd =
    counter_widget.Get_Sibling(Am_SCRIPT_EXECUTE_COMMAND);
  int val = cmd.Get(Am_VALUE);
 std::cout << "Setting count of " << execute_cmd << " to " << val <<std::endl <<std::flush;
  execute_cmd.Set(Am_EXECUTE_COUNTER, val);
}

Am_Define_String_Formula(gen_how_invoke_text) {
  char line[300];
  OSTRSTREAM_CONSTR (oss,line,300,std::ios::out);
  Am_Object script_window = self.Get_Owner();
  Am_Object script_execute_command =
       script_window.Get(Am_SCRIPT_EXECUTE_COMMAND);
  Am_Input_Char accel_char = script_execute_command.Get(Am_ACCELERATOR);
  if (accel_char.Valid()) {
    char accel_string[Am_LONGEST_CHAR_STRING];
    accel_char.As_Short_String(accel_string);
    oss << accel_string;
  }
  int before_after = script_execute_command.Get(Am_BEFORE_OR_AFTER);
  if (before_after != 0) {
    if (accel_char.Valid()) oss << ", ";
    if (before_after == am_before_command)
      oss << "before ";
    else if (before_after == am_after_command)
      oss << "after ";
    else Am_ERROR("bad before/after " << before_after);
    Am_Object match_command =
     script_execute_command.Get(Am_BEFORE_OR_AFTER_COMMAND);
    Am_Object real_command = match_command.Get(Am_COMMAND);
    Am_Value v = real_command.Peek(Am_REGISTER_COMMAND);
    if (!v.Valid()) {
      v=real_command.Peek(Am_SHORT_LABEL, Am_NO_DEPENDENCY);
      if (!v.Valid()) v=real_command.Peek(Am_LABEL, Am_NO_DEPENDENCY);
    }
    oss << v;
  }
  // ** deal with time, menus
  oss <<std::ends;
  OSTRSTREAM_COPY(oss,line,300);
  Am_String str(line);
  return str;
}

Am_Object Am_Script_Window_Initialize () {
  Am_Value_List l;
  l.Add (Am_Command.Create(DSTR("File"))
	 .Set(Am_LABEL, "File")
	 .Set(Am_IMPLEMENTATION_PARENT, true) //not undoable
	 .Set(Am_ITEMS, Am_Value_List ()
	       .Add(Am_Standard_OK_Command.Create()
		    .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		    .Set(Am_DO_METHOD, am_script_ok))
	       .Add(Am_Command.Create(DSTR("Cancel"))
		    .Set(Am_LABEL, "Cancel")
		    .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		    .Set(Am_DO_METHOD, script_window_cancel))
	       .Add(Am_Command.Create(DSTR("Remove"))
		    .Set(Am_LABEL, "Remove Script")
		    .Set(Am_ACTIVE, ok_to_remove_formula)
		    .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		    .Set(Am_DO_METHOD, am_script_remove))
	       .Add(Am_Command.Create(DSTR("Execute"))
		    .Set(Am_LABEL, "Execute Script")
		    .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		    .Set(Am_DO_METHOD, am_script_execute))
	       .Add(Am_Command.Create(DSTR("select_members"))
		    .Set(Am_LABEL, "Select Members")
		    .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		    .Set(Am_DO_METHOD, am_script_select_members))
	       .Add(Am_Menu_Line_Command.Create())
	       .Add(Am_About_Amulet_Command.Create())
	       )
	 )
    .Add (Am_Command.Create(DSTR("Edit_Command"))
	  .Set(Am_LABEL, "Edit")
	  .Set(Am_IMPLEMENTATION_PARENT, true) //not undoable
	  .Set(Am_ITEMS, Am_Value_List ()
	       .Add (Am_Undo_Command.Create())
	       .Add (Am_Redo_Command.Create())
	       .Add (Am_Command.Create(DSTR("Cut"))
		     .Set(Am_LABEL, "Cut")
		     .Set(Am_ACTIVE, false)
		     )
	       .Add (Am_Command.Create(DSTR("Copy"))
		     .Set(Am_LABEL, "Copy")
		     .Set(Am_ACTIVE, false)
		     )
	       .Add (Am_Command.Create(DSTR("Paste"))
		     .Set(Am_LABEL, "Paste")
		     .Set(Am_ACTIVE, false)
		     )
	       .Add (Am_Command.Create(DSTR("Insert Commands Before"))
		     .Set(Am_LABEL, "Insert Commands Before")
		     .Set(Am_ACTIVE, am_insert_commands_ok)
		     .Set(Am_DO_METHOD, am_insert_commands_before)
		     .Set(Am_UNDO_METHOD, am_edit_commands_list_undo)
		     .Set(Am_REDO_METHOD, am_edit_commands_list_undo)
		     )
	       .Add (Am_Command.Create(DSTR("Insert Commands After"))
		     .Set(Am_LABEL, "Insert Commands After")
		     .Set(Am_ACTIVE, am_insert_commands_ok)
		     .Set(Am_DO_METHOD, am_insert_commands_after)
		     .Set(Am_UNDO_METHOD, am_edit_commands_list_undo)
		     .Set(Am_REDO_METHOD, am_edit_commands_list_undo)
		     )
	       .Add (Am_Command.Create(DSTR("Delete"))
		     .Set(Am_LABEL, "Delete Commands")
		     .Set(Am_ACTIVE, am_delete_commands_ok)
		     .Set(Am_DO_METHOD, am_delete_script_commands)
		     .Set(Am_UNDO_METHOD, am_edit_commands_list_undo)
		     .Set(Am_REDO_METHOD, am_edit_commands_list_undo)
		     )
	       .Add (Am_Menu_Line_Command.Create())
	       .Add (Am_Command.Create(DSTR("Generalize"))
		     .Set(Am_LABEL, "Generalize")
		     .Set(Am_ACTIVE, am_generalize_script_active)
		     .Set(Am_DO_METHOD, am_do_generalize_script)
			 )
	       .Add (Am_Menu_Line_Command.Create())
	       .Add (Am_Command.Create(DSTR("Invoke"))
	         .Set(Am_LABEL, "How Invoked...")
		 	 .Set(Am_DO_METHOD, pop_up_invoke_options)
		     )
	       )
	  )
    ;
  Am_Script_Window = Am_Window.Create(DSTR("Am_Script_Window"))
    .Set(Am_DESTROY_WINDOW_METHOD, script_window_destroy_method)
    .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    .Set(Am_TITLE, "Script for Commands")
    .Set(Am_ICON_TITLE, "Script Commands")
    .Set(Am_WIDTH , 530)
    .Set(Am_HEIGHT, 400)
    .Set(Am_VISIBLE, false)
    .Add(Am_SCRIPT_EXECUTE_COMMAND, Am_No_Object)
    .Add(Am_SHOW_SCRIPT_COMMAND, Am_No_Object)
    //undo operations in undo window!  weird
    .Set(Am_UNDO_HANDLER, Am_Multiple_Undo_Object.Create())
    ;
  Am_Object sg;
  Am_Script_Window
    .Add_Part(Am_UNDO_MENU_BAR, Am_Menu_Bar.Create()
	      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	      .Set(Am_ITEMS, l))
    .Add_Part(Am_LABEL, Am_Text.Create()
      .Set(Am_LEFT, 4)
      .Set(Am_TOP, Am_Bottom_Of_Sibling(Am_UNDO_MENU_BAR, 5))
      .Set(Am_WIDTH, 210)
      .Set(Am_HEIGHT, 19)
      .Set(Am_TEXT, "Script Editor")
      .Set(Am_FONT, Am_Font(Am_FONT_FIXED, true, false, false, Am_FONT_LARGE))
      .Set(Am_LINE_STYLE, Am_Black)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    )
    .Add_Part(Am_NAME_OBJECT, Am_Text_Input_Widget.Create()
      .Set(Am_FONT, Am_Font(Am_FONT_FIXED, true))
      .Set(Am_LEFT, 10)
      .Set(Am_TOP, Am_Bottom_Of_Sibling(Am_LABEL, 5))
      .Set(Am_WIDTH, 212)
      .Set(Am_HEIGHT, 25)
      .Get_Object(Am_COMMAND)
        .Set(Am_LABEL, "Script Name:")
        .Get_Owner()
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    )
    .Add_Part(Am_ACCELERATOR, Am_Button.Create(DSTR("popup how invoke"))
      .Set(Am_LEAVE_ROOM_FOR_FRINGE, false)
      .Set(Am_LEFT, Am_Right_Of_Sibling(Am_NAME_OBJECT, 35))
      .Set(Am_TOP, Am_From_Sibling(Am_NAME_OBJECT, Am_TOP))
      .Get_Object(Am_COMMAND)
        .Set(Am_LABEL, "How Invoked...")
		.Set(Am_DO_METHOD, pop_up_invoke_options)
        .Get_Owner()
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    )
    .Add_Part(Am_Text.Create(DSTR("invoke_feedback"))
	      .Set(Am_LEFT, Am_Right_Of_Sibling(Am_ACCELERATOR, 8))
	      .Set(Am_TOP, Am_From_Sibling(Am_NAME_OBJECT, Am_TOP))
	      .Set(Am_TEXT, gen_how_invoke_text)
	      )
    .Add_Part(Am_Border_Rectangle.Create()
      .Set(Am_LEFT, 10)
      .Set(Am_TOP, Am_Bottom_Of_Sibling(Am_ACCELERATOR, 5))
      .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH, -20))
      .Set(Am_HEIGHT, Am_Rest_Of_Height_Above(Am_UNDO_OPTIONS, 6))
      .Set(Am_SELECTED, 0)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    )
    .Add_Part(Am_SHORT_LABEL, Am_Text.Create()
      .Set(Am_LEFT, 16)
      .Set(Am_TOP, Am_Bottom_Of_Sibling(Am_ACCELERATOR, 8))
      .Set(Am_TEXT, "Commands:")
      .Set(Am_LINE_STYLE, Am_Black)
    )
    .Add_Part(Am_UNDO_SCROLL_GROUP,
	      sg = Am_Scrolling_Menu.Create(DSTR("cmds_in_script"))
      .Set(Am_LEFT, 18)
      .Set(Am_TOP, Am_Bottom_Of_Sibling(Am_SHORT_LABEL, 3))
      .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH, -34))
      .Set(Am_HEIGHT, Am_Rest_Of_Height_Above(Am_UNDO_OPTIONS, 15))
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	      .Set(Am_H_SCROLL_BAR, true)
      .Get_Object(Am_COMMAND)
	      .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
	      .Get_Owner()
      .Add_Part(Am_INTERACTOR,Am_One_Shot_Interactor.Create(DSTR("select_line_part"))
		.Set(Am_START_WHEN, Am_Input_Char("left_down"))
		.Set(Am_PRIORITY, 10.0)
		.Set (Am_START_WHERE_TEST, am_on_selectable_line_part)
		.Get_Object(Am_COMMAND)
		  .Set (Am_DO_METHOD, am_select_line_part)
		  .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		  .Get_Owner()
		)
      .Add_Part(Am_ARROW_INTERACTOR,Am_One_Shot_Interactor.Create(DSTR("double_clk"))
		.Set(Am_START_WHEN, Am_Input_Char("double_left_down"))
		.Set(Am_PRIORITY, 10.0)
		.Set (Am_START_WHERE_TEST, am_on_selectable_line_part)
		.Get_Object(Am_COMMAND)
		  .Set (Am_DO_METHOD, am_generalize_script_double_click)
		  .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		  .Get_Owner()
		)
      ) ;
  sg.Get_Object(Am_SUB_MENU)
    .Set(Am_V_SPACING, -4)
    .Get_Object(Am_ITEM_PROTOTYPE)
       .Set(Am_PRETEND_TO_BE_LEAF, false);
  sg.Get_Object(Am_COMMAND)
    .Set(Am_DO_METHOD, am_clear_select_line_part);
  Am_Script_Window
    .Set(Am_BOTTOM_OFFSET, 30)
    .Add_Part(Am_UNDO_OPTIONS, Am_Button_Panel.Create()
      .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
      .Set(Am_TOP, Am_Bottom_Is_Bottom_Of_Owner)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
      .Set(Am_LAYOUT, Am_Horizontal_Layout)
      .Set(Am_H_SPACING, 5)
      .Set(Am_FIXED_WIDTH, false)
      .Set(Am_ITEMS, Am_Value_List()
	   .Add(Am_Command.Create(DSTR("OK-menu"))
		.Set(Am_LABEL, "OK")
		.Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		.Set(Am_DO_METHOD, am_script_ok))
	   .Add(Am_Command.Create(DSTR("Cancel"))
		.Set(Am_LABEL, "Cancel")
		.Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		.Set(Am_DO_METHOD, script_window_cancel))
	   .Add(Am_Command.Create(DSTR("Remove"))
		.Set(Am_LABEL, "Remove")
		.Set(Am_ACTIVE, ok_to_remove_formula)
		.Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		.Set(Am_DO_METHOD, am_script_remove))
	   .Add(Am_Command.Create(DSTR("Execute"))
		.Set(Am_LABEL, "Execute")
		.Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		.Set(Am_DO_METHOD, am_script_execute))
	   .Add(Am_Command.Create(DSTR("Step"))
		.Set(Am_LABEL, "Step")
		.Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		.Set(Am_DO_METHOD, am_execute_script_step_one))
	   .Add(Am_Command.Create(DSTR("select_members"))
		.Set(Am_LABEL, "Select Members")
		.Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		.Set(Am_DO_METHOD, am_script_select_members))
	   )
        )
    .Add_Part(Am_EXECUTE_COUNTER, Am_Number_Input_Widget.Create()
	      .Set(Am_LEFT, 200)
	      .Set(Am_TOP, Am_Bottom_Of_Sibling(Am_UNDO_OPTIONS, 2))
	      .Set(Am_VALUE, 0)
	      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	      .Set(Am_COMMAND, Am_Command.Create()
		   .Set(Am_LABEL, "Count")
		   .Set(Am_DO_METHOD, count_set)
		   )
	      .Set(Am_WIDTH, 80)
	      .Set(Am_VALUE, 1)
	      )
    .Add_Part(Am_One_Shot_Interactor.Create(DSTR("incrementer"))
	      .Set(Am_START_WHEN, "Control_u")
	      .Set(Am_DO_METHOD, increment_counter)
	      )
    .Add_Part(Am_Tab_To_Next_Widget_Interactor.Create())
    ;
  return Am_Script_Window;
}
