/*
	setcustomicon.c (from libmikmod for mac)
	
	This silly little program sets the custom icon bit for the shared library.
	Dispose of properly.

	written by Anders F Bjrklund <afb@algonet.se>
 */

#include <stdlib.h>

#include <Files.h>
#include <Finder.h>
#include <Sound.h>

static OSErr SetCustomIconBit( Str63 fileName );

OSErr SetCustomIconBit( Str63 fileName )
{
	OSErr	err;
	FInfo	info;
	
	err = GetFInfo( fileName, 0, &info );
	if ( err != noErr )
		return err;

	info.fdFlags |= kHasCustomIcon;

	err = SetFInfo( fileName, 0, &info );
	if ( err != noErr )
		return err;

	return noErr;
}

int main(int argc, char *argv[])
{
#pragma unused(argc,argv)

	MaxApplZone();

	if ( noErr != SetCustomIconBit( "\plibmikmod" ) )
	{
		SysBeep(8);
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}