/* File "patterns.h":
 * Malaga pattern matching. */

/* This file is part of Malaga, a system for Left Associative Grammars.
 * Copyright (C) 1995-1998 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#define PATTERN_VAR_MAX 5 /* maximum number of pattern variables */

GLOBAL struct {string_t start, end;} pattern_var[PATTERN_VAR_MAX];
/* start and end index of pattern variables */

extern string_t compile_pattern (string_t string);
/* Convert <string> to a pattern to be used as input to "match_pattern".
 * The result pattern must be freed with "free" after usage. */

extern string_t mark_var_pattern (string_t pattern, byte_t pattern_var_no);
/* Mark the pattern so the string matching this pattern will be stored in
 * <pattern_var[pattern_var_no]>, and free <pattern>.
 * The result pattern must be freed with "free" after use. */

extern string_t join_alternatives (string_t pattern1, string_t pattern2);
/* Join <pattern1> and <pattern2> to form an alternative.
 * <pattern1> and <pattern2> will be freed.
 * The result pattern must be freed with "free" after use. */

extern string_t join_concatenation (string_t pattern1, string_t pattern2);
/* Concat <pattern1> and <pattern2>.
 * <pattern1> and <pattern2> will be freed.
 * The result pattern must be freed with "free" after use. */

extern bool_t match_pattern (string_t string, string_t pattern);
/* Test whether <string> matches <pattern> (a string of chars compiled with
 * "compile_pattern") and set substring indices in <pattern_var>.
 * The substrings remain valid till "compile_pattern" is called again. */
