/* File "lexicon.h":
 * All definitions for the run-time lexicon. */

/* This file is part of Malaga, a system for Left Associative Grammars.
 * Copyright (C) 1995-1998 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* the run time lexicon */
GLOBAL struct
{
  long_t *trie;           /* trie with indices to <cat_lists> */
  long_t trie_size;
  long_t trie_root;       /* index of root node in <trie> */

  long_t *cat_lists;      /* lists of categories, stored in <values>
                           * (the last index <i> of each list is
                           * negative, real index is abs(<i>) - 1) */
  long_t cat_lists_size;

  cell_t *values;         /* categories of lexicon entries */
  long_t values_size;

  char *strings;          /* surfaces */
  long_t strings_size;
} lexicon;

/* Read lexicon from file <file_name>. */
extern void read_lexicon_file (string_t file_name);

/* Free all memory used by the lexicon. */
extern void free_lexicon (void);
