/* File "input.h":
 * Support reading and parsing input. */

/* This file is part of Malaga, a system for Left Associative Grammars.
 * Copyright (C) 1995-1998 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#define INPUT_LINE_LENGTH 768 /* suggested length of input buffers */

extern void parse_whitespace (string_t *input); 
/* Read whitespace in *<input> and update *<input>. */

extern long_t parse_integer (string_t *input);
/* Parse the next integer number from *<input> and update *<input>.
 * If there is no integer, an error is reported. */

extern double parse_double (string_t *input);
/* Parse the next double from *<input> and update *<input>.
 * If there is no double, an error is reported. */

extern string_t parse_word (string_t *input);
/* If there is a word in *<input>, parse it up to the next space
 * and update *<input>. Return the word. It must be freed with "free".
 * If there's no word, report an error. */

extern bool_t parse_yes_no (string_t *input);
/* Parse next word in <input>. It must be "yes", "no", "on" or "off".
 * Return TRUE iff next word is "yes" or "on". */

extern void parse_end (string_t input);
/* Test if there are no more arguments in <input>. */

extern void read_line (FILE *stream, string_t buffer, long_t buffer_size);
/* Read user input from <stream> into <buffer> until eof or newline is met.
 * If input is longer than <buffer_size> chars, report an error. */
