/* $Id: crt.c,v 1.6 1999/01/29 22:29:25 marcus Exp $
******************************************************************************

   Graphics library for GGI. CRT specifics

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include "misc_int.h"
#include <ggi/display/x.h>

int GGIwaitraypos(ggi_visual *vis,sint32 *x,sint32 *y)
{
	*x = GGI_RP_DONTCARE;
	*y = GGI_RP_DONTCARE;

	return 1;
}

int GGIsetsplitline(ggi_visual *vis,int y)
{
	struct Xhooks *xhook;
	GGIDPRINT("GOTCHA ! X setting splitline %d !\n",y);

	if (y<0 || y>LIBGGI_MODE(vis)->visible.y) return -1;

	xhook=LIBGGI_PRIVATE(vis);

	if ( xhook->yoff > LIBGGI_MODE(vis)->virt.y-y )
		xhook->yoff = LIBGGI_MODE(vis)->virt.y-y;

	xhook->ysplit=y;

	ggiFlush(vis);

	return 0;
}
