/* $Id: visual.c,v 1.7 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Helper library for the implementation of SYNC mode on targets which are
   inherently ASYNC (e.g. X) and require manual flushes of the framebuffer.

   Mansync initialization.

   Copyright (C) 1998 Marcus Sundberg  [marcus@ggi-project.org]
   Copyright (C) 1998 Steve Cheng      [steve@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************

   Helper library for the implementation of SYNC mode on targets which are
   inherently ASYNC (e.g. X) and require manual flushes of the framebuffer.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/mansync.h>


int GGIdlinit(ggi_visual *visual, const char *args, void *argptr)
{
	_ggi_opmansync *ops = (_ggi_opmansync *) argptr;
	
	if (ops == NULL) {
		ggiPanic("Target tried to use mansync helper in a wrong way!\n");
	}

	ops->init   = _GGI_mansync_init;
	ops->deinit = _GGI_mansync_deinit;
	ops->start  = _GGI_mansync_start;
	ops->stop   = _GGI_mansync_stop;
	ops->ignore = _GGI_mansync_ignore;
	ops->cont   = _GGI_mansync_cont;

	return 0;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
