/* $Id: copybox.c,v 1.9 1998/11/19 01:06:28 marcus Exp $
******************************************************************************
   Graphics library for GGI.

   Copyright (C) 1998 Andrew Apted  [andrew.apted@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "stublib.h"

#define MAX_PIXELS  1024

static inline int copy_one_line(ggi_visual *vis, int x, int y, int w,
				int nx, int ny)
{
	uint8 buf[MAX_PIXELS * sizeof(ggi_pixel)];

	if (nx > x) {
		x  += w; nx += w;
		
		for (; (w > 0); w -= MAX_PIXELS) {

			int ww =  (w < MAX_PIXELS) ? w : MAX_PIXELS;

			ggiGetHLine(vis, x-ww,  y,  ww, buf);
			ggiPutHLine(vis, nx-ww, ny, ww, buf);

			x  -= MAX_PIXELS;
			nx -= MAX_PIXELS;
		}
	} else {
		for (; (w > 0); w -= MAX_PIXELS) {
			
			int ww =  (w < MAX_PIXELS) ? w : MAX_PIXELS;

			ggiGetHLine(vis, x,  y,  ww, buf);
			ggiPutHLine(vis, nx, ny, ww, buf);

			x  += MAX_PIXELS;
			nx += MAX_PIXELS;
		}
	}

	return 0;
}

int GGI_stubs_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	/* Clipping */

	if (nx < LIBGGI_GC(vis)->cliptl.x) {
		int diff = LIBGGI_GC(vis)->cliptl.x - nx;
		x  += diff;
		nx += diff;
		w  -= diff;
	}
	if (ny < LIBGGI_GC(vis)->cliptl.y) {
		int diff = LIBGGI_GC(vis)->cliptl.y - ny;
		y  += diff;
		ny += diff;
		h  -= diff;
	}
	if (nx+w > LIBGGI_GC(vis)->clipbr.x) {
		w = LIBGGI_GC(vis)->clipbr.x - nx;
	}
	if (ny+h > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - ny;
	}

	/* Do the copy */

	if ((h <= 0) || (w <= 0)) {
		return 0;
	}

	if (ny > y) {
		for (y+=h-1, ny+=h-1; (h > 0); h--, y--, ny--) {
			copy_one_line(vis, x, y, w, nx, ny);
		}
	} else {
		for (; (h > 0); h--, y++, ny++) {
			copy_one_line(vis, x, y, w, nx, ny);
		}
	}

	return 0;
}
