/* $Id: gtext.c,v 1.1 1999/05/12 21:14:52 marcus Exp $
******************************************************************************

   LibGGI - Millennium II acceleration for fbdev target

   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <string.h>
#include "m2164w.h"

/* The default LibGGI font */
#include <ggi/internal/font/8x8>

#define FWIDTH	8
#define FHEIGHT	8

int GGI_m2164w_getcharsize(ggi_visual *vis, int *width, int *height)
{
	/* The stubs' font is 8x8, so that is what we return */
	*width = FWIDTH;
	*height = FHEIGHT;

	return 0;
}

static inline void
blitchar(ggi_visual *vis, int x, int y, ggi_pixel color, uint8 *field)
{
	int xp, bp;
	int ywidth = FHEIGHT;

	/* Clipping is done via the PutPixel call ... we should pre-clip */
	while (ywidth--) {
		for (xp=0, bp=0x80; xp < FWIDTH; xp++) {
			if ((*field & bp)) {
				LIBGGIPutPixel(vis, x+xp, y, color);
			}
      			if (!(bp >>= 1)) {
				bp = 0x80;
				field++;
			}
    		}
		y++;
	}
}


static inline void
drawbox(ggi_visual *vis, int x, int y, int w)
{
	volatile uint8 *mmioaddr = FBDEV_PRIV(vis)->mmioaddr;
	int yadd = vis->w_frame_num * LIBGGI_VIRTY(vis);

	y += yadd;

	mga_gcupdate(mmioaddr, M2164W_PRIV(vis), LIBGGI_MODE(vis),
		     LIBGGI_GC(vis), LIBGGI_VIRTX(vis), yadd);

	mga_waitfifo(mmioaddr, 3);
	mga_out32(mmioaddr, M2164W_PRIV(vis)->drawboxcmd, DWGCTL);
	mga_out32(mmioaddr, ((x + w) << 16) | x, FXBNDRY);
	mga_out32(mmioaddr, (y << 16) | FHEIGHT, YDSTLEN | EXECUTE);

	vis->accelactive = 1;
}


int GGI_m2164w_putc(ggi_visual *vis, int x, int y, char c)
{
	ggi_pixel fgcol = LIBGGI_GC_FGCOLOR(vis);

	LIBGGI_GC_FGCOLOR(vis) = LIBGGI_GC_BGCOLOR(vis);
	drawbox(vis, x, y, FWIDTH);
	LIBGGI_GC_FGCOLOR(vis) = fgcol;
	blitchar(vis, x, y, fgcol, font + (((uint8)c) << 3));

	return 0;
}

int GGI_m2164w_puts(ggi_visual *vis, int x, int y, const char *str)
{
	ggi_pixel fgcol = LIBGGI_GC_FGCOLOR(vis);
	int len, count;
	int tlx, brx;

	/* Vertically out of the clipping area ? */
	if ((y+FHEIGHT < LIBGGI_GC(vis)->cliptl.y) ||
	    (y >= LIBGGI_GC(vis)->clipbr.y)) {
		return 0;
	}
	len = strlen(str);
	
	LIBGGI_GC_FGCOLOR(vis) = LIBGGI_GC_BGCOLOR(vis);
	drawbox(vis, x, y, FWIDTH * len);
	LIBGGI_GC_FGCOLOR(vis) = fgcol;

	tlx = LIBGGI_GC(vis)->cliptl.x;
	brx = LIBGGI_GC(vis)->clipbr.x;
	    
	for (count=0; len > 0; len--, str++, x += FWIDTH) {
		/* Horizontally within the clipping area ? */
		if (x+FWIDTH >= tlx && x < brx) {
			blitchar(vis, x, y, fgcol,
				 font + (((uint8)*str) << 3));
			count++;
		}
	}

	return count;
}
