
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <Xm/ComboBoxP.h>
#include <Xm/GrabShellP.h>
#include <Xm/TextFP.h>

#if !defined(CB_IdealEBHeight)
#define CB_IdealEBHeight(w) \
    (((XmComboBoxWidget)(w))->combo_box.ideal_ebheight)
#endif

#if !defined(CB_IdealEBWidth)
#define CB_IdealEBWidth(w) \
    (((XmComboBoxWidget)(w))->combo_box.ideal_ebwidth)
#endif

#if !defined(TextF__)
#define TextF__(w) ((XmTextFieldWidget)(w))->text
#define TextF_ViewHeight(w) (TextF__(w).margin_top)
#define TextF_ViewWidth(w) (TextF__(w).margin_bottom)
#define TextF_FontAverageWidth(w) (TextF__(w).average_char_width)
#endif

void XdbPrintTextFieldResources(Widget w)
{
  Dimension height, width, borderWidth;
  Dimension marginWidth, marginHeight;
  Dimension highlightThickness, shadowThickness;
  int selectThreshold;
  Dimension marginTop, marginBottom;
  Dimension fontAscent, fontDescent;
  Dimension averageCharWidth;
  short columns;

  XtVaGetValues(w,
                XmNmarginWidth, &marginWidth,
                XmNmarginHeight, &marginHeight,
                XmNheight, &height,
                XmNwidth, &width,
                XmNborderWidth, &borderWidth,
                XmNhighlightThickness, &highlightThickness,
                XmNshadowThickness, &shadowThickness,
                XmNselectThreshold, &selectThreshold,
                XmNcolumns, &columns,
                NULL);

  marginTop = TextF_ViewHeight(w);
  marginBottom = TextF_ViewWidth(w);
  fontAscent = TextF_FontAscent(w);
  fontDescent = TextF_FontDescent(w);
  averageCharWidth = TextF_FontAverageWidth(w); 

  fprintf(stderr,"TextField Resource(s):\n");
  fprintf(stderr,"MarginWidth (%d)\n",(int) marginWidth);
  fprintf(stderr,"MarginHeight (%d)\n",(int) marginHeight);
  fprintf(stderr,"Height (%d)\n",(int) height);
  fprintf(stderr,"Width (%d)\n",(int) width);
  fprintf(stderr,"BorderWidth (%d)\n",(int) borderWidth);
  fprintf(stderr,"HighlightThickness (%d)\n",(int) highlightThickness);
  fprintf(stderr,"ShadowThickness (%d)\n",(int) shadowThickness);
  fprintf(stderr,"SelectThreshold (%d)\n",(int) selectThreshold);
  fprintf(stderr,"marginTop (%d)\n", (int) marginTop);
  fprintf(stderr,"marginBottom (%d)\n", (int) marginBottom);
  fprintf(stderr,"fontAscent (%d)\n", (int) fontAscent);
  fprintf(stderr,"fontDescent (%d)\n", (int) fontDescent);
  fprintf(stderr,"averageCharWidth (%d)\n", (int) averageCharWidth);
  fprintf(stderr,"columns (%d)\n", (int) columns);
}

void XdbPrintComboBoxResources(Widget w)
{
  Dimension arrowSize, arrowSpacing;
  Dimension marginWidth, marginHeight;
  unsigned char matchBehavior;

  XtVaGetValues(w,
                XmNarrowSize, &arrowSize,
                XmNarrowSpacing, &arrowSpacing,
                XmNmarginWidth, &marginWidth,
                XmNmarginHeight, &marginHeight,
                XmNmatchBehavior, &matchBehavior,
                NULL);

  fprintf(stderr,"ComboBox Resource(s):\n");
  fprintf(stderr,"ArrowSize (%d)\n",(int) arrowSize);
  fprintf(stderr,"ArrowSpacing (%d)\n",(int) arrowSpacing);
  fprintf(stderr,"MarginWidth (%d)\n",(int) marginWidth);
  fprintf(stderr,"MarginHeight (%d)\n",(int) marginHeight);
  fprintf(stderr,"IdealEBHeight (%d)\n",(int) CB_IdealEBHeight(w));
  fprintf(stderr,"IdealEBWidth (%d)\n",(int) CB_IdealEBWidth(w));
  fprintf(stderr,"HitRectX(%d)\n",(int) CB_HitRect(w).x);
  fprintf(stderr,"HitRectY(%d)\n",(int) CB_HitRect(w).y);
  fprintf(stderr,"HitRectWidth(%d)\n",(int) CB_HitRect(w).width);
  fprintf(stderr,"HitRectHeight(%d)\n",(int) CB_HitRect(w).height);
  fprintf(stderr,"MatchBehavior(%d)\n",(int) matchBehavior);

  XdbPrintTextFieldResources(CB_EditBox(w));
}

void XdbPrintGrabShellResources(Widget w)
{
  int grabStyle = -1;
  Boolean ownerEvents, saveUnder, overrideRedirect;
  Dimension shadowThickness;

  XtVaGetValues(w,
                XmNgrabStyle, &grabStyle,
                XtNoverrideRedirect, &overrideRedirect,
                XmNownerEvents, &ownerEvents,
                XtNsaveUnder, &saveUnder,
                XmNshadowThickness, &shadowThickness,
                NULL);

  fprintf(stderr,"GrabShell Resource(s):\n");
  fprintf(stderr,"GrabStyle (%d)\n",grabStyle);
  fprintf(stderr,"OverrideRedirect (%d)\n",(int) overrideRedirect);
  fprintf(stderr,"OwnerEvents (%d)\n",(int) ownerEvents);
  fprintf(stderr,"SaveUnder (%d)\n",(int) saveUnder);
  fprintf(stderr,"ShadowThickness (%d)\n",(int) shadowThickness);
}

void XdbPrintPrimitiveResources(Widget w)
{
  Dimension highlightThickness, shadowThickness, borderWidth;
  
  XtVaGetValues(w,
                XmNhighlightThickness, &highlightThickness,
                XmNshadowThickness, &shadowThickness,
                XmNborderWidth, &borderWidth,
                NULL);
  fprintf(stderr,"Primitive Resource(s) for %s:\n", XtName(w));
  fprintf(stderr,"highlightThickness (%d)\n", highlightThickness);
  fprintf(stderr,"shadowThickness (%d)\n", shadowThickness);
  fprintf(stderr,"borderWidth (%d)\n", borderWidth);
}

void XdbPrintResources(Widget w)
{
   if (XmIsComboBox(w))
   {
      XdbPrintComboBoxResources(w);
   }
   else if (XmIsGrabShell(w))
   {
      XdbPrintGrabShellResources(w);
   }

   if (XmIsPrimitive(w))
   {
      XdbPrintPrimitiveResources(w);
   }
}

