/**
 *
 * $Id: ColorObjP.h,v 1.1 1997/02/22 04:41:55 miers Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_COLOROBJP_H
#define XM_COLOROBJP_H

#include <Xm/ColorObj.h>
#include <Xm/VendorSP.h>

#ifdef __cplusplus
extern "C" {
#endif


#define XmNuseIconFileCache	"useIconFileCache"
#define XmCUseIconFileCache	"UseIconFileCache"

typedef PixelSet Colors[NUM_COLORS];

typedef struct _ColorObjPart {
    XtArgsProc RowColInitHook;
    PixelSet *myColors;
    int myScreen;
    Display *display;
    Colors *colors;
    int numScreens;
    Atom *atoms;
    Boolean colorIsRunning;
    Boolean done;
    int *colorUse;
    int	primary;
    int	secondary;
    int	text;
    int	active;
    int	inactive;
    Boolean useColorObj;
    Boolean useText;
    Boolean useTextForList;
    Boolean useMask;
    Boolean useMultiColorIcons;
    Boolean useIconFileCache;
} ColorObjPart;

typedef struct _ColorObjRec {
    CorePart core;
    CompositePart composite;
    ShellPart shell;
    WMShellPart wm;
    ColorObjPart color_obj;
} ColorObjRec;

typedef struct _ColorObjClassPart {
    XtPointer        extension;
} ColorObjClassPart;

typedef struct _ColorObjClassRec{
    CoreClassPart      		core_class;
    CompositeClassPart 		composite_class;
    ShellClassPart  		shell_class;
    WMShellClassPart   		wm_shell_class;
    ColorObjClassPart		color_obj_class;
} ColorObjClassRec;

extern ColorObjClassRec _xmColorObjClassRec;

extern void _XmColorObjCreate(Widget w, ArgList al, Cardinal *acPtr);
extern Boolean _XmGetPixelData(int screen, int *colorUse, PixelSet *pixelSet,
			       short *a, short *i, short *p, short *s);
extern Boolean _XmGetIconControlInfo(Screen *screen,
				     Boolean *useMaskRtn,
				     Boolean *useMultiColorIconsRtn,
				     Boolean *useIconFileCacheRtn);
extern Boolean _XmUseColorObj(void);

#ifdef __cplusplus
}
#endif

#endif

