@echo off

REM  
REM   THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
REM   PURSUANT TO THE 3DFX GLIDE GENERAL PUBLIC LICENSE. THERE IS NO RIGHT
REM   TO USE THE GLIDE TRADEMARK WITHOUT PRIOR WRITTEN PERMISSION OF 3DFX
REM   INTERACTIVE, INC. A COPY OF THIS LICENSE MAY BE OBTAINED FROM THE 
REM   DISTRIBUTOR OR BY CONTACTING 3DFX INTERACTIVE INC(info@3dfx.com). 
REM   THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
REM   EXPRESSED OR IMPLIED. SEE THE 3DFX GLIDE GENERAL PUBLIC LICENSE FOR A
REM   FULL TEXT OF THE NON-WARRANTY PROVISIONS.  
REM   
REM   USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
REM   RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
REM   TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
REM   AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
REM   SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
REM   THE UNITED STATES.  
REM   
REM   COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS RESERVED

REM ------------------------------------------
REM CSETUP.BAT SET UP 3DFX BUILD ENVIRONMENT
REM ------------------------------------------

IF "%1"=="MSVC"   SET CTARGET=MSVC
IF "%1"=="msvc"   SET CTARGET=MSVC
IF "%1"=="WATDOS" SET CTARGET=WATDOS
IF "%1"=="watdos" SET CTARGET=WATDOS
IF "%CTARGET%"=="" GOTO USAGE

REM ------------------------------------------
REM STORE THE PATH
REM ------------------------------------------
IF NOT "%OLDPATH%"=="" GOTO DONTSTORE
SET OLDPATH=%PATH%
:DONTSTORE


REM ---------------------------------------------------------
REM SET THE FOLLOWING VARIABLES (before attempting to compile
REM ---------------------------------------------------------

set NMAKE=c:\nmake

REM You must set BUILD_DRIVE to the drive that you are building on ex:
set BUILD_DRIVE=c:

REM You must set BUILD_ROOT to the root of where you extracted your
REM source kit to ex:
set BUILD_ROOT=c:\3dfx\msvc\devel

REM You must set MASM to the location of your Microsoft Assembler
REM directory ex:
set MASM=d:\masm611

REM You must set MSVC to the location of your Microsoft Visual C++
REM compiler ex:
set MSVC=c:\msdev

REM You must set WATCOM to the location of your Watcom compiler files ex:
set WATCOM=d:\watcom

REM You must set FX_DLL_BUILD to 1 if you are attempting to build a Glide
REM DLL.  However, if you would just like to build static libs it must
REM be UN-set  (set FX_DLL_BUILD=).  You must also UN-set this to build
REM for DOS.
REM set FX_DLL_BUILD=1 (will build .dll)
set FX_DLL_BUILD=

REM Set FX_PCI_TARGET=NT for Windows NT builds only.
REM Unset it set (FX_PCI_TARGET=) for all other builds.
REM set FX_PCI_TARGET=NT

REM ------------------------------------------
REM CHECK CRITICAL VARS
REM ------------------------------------------
IF NOT "%BUILD_DRIVE%"=="" GOTO DRIVEDEFD
ECHO You must set the environment variable BUILD_DRIVE
ECHO   to the driver letter of the source tree.
ECHO eg. SET BUILD_DRIVE=d:
GOTO END
:DRIVEDEFD
IF NOT "%BUILD_ROOT%"=="" GOTO ROOTDEFD
ECHO You must set the environment variable BUILD_ROOT
ECHO    to the root directory of the source tree.
ECHO eg. SET BUILD_ROOT=\3dfx\devel 
ECHO NOTE: BUILD_ROOT doesn't need a drive letter.
GOTO END
:ROOTDEFD
IF NOT "%MASM%=="" GOTO MASMDEFD
ECHO You must set the environment variable MASM
ECHO    To the install directory for 
ECHO    Microsoft Assember VERSION 6.11 ( or greater )
ECHO eg. SET MASM=C:\DEVEL\MASM611
GOTO END
:MASMDEFD


REM ------------------------------------------
REM   SET COMMON VARS
REM ------------------------------------------
SET BUILD_ROOT_CVG=%BUILD_ROOT%\cvg
SET BUILD_ROOT_SWLIBS=%BUILD_ROOT%\swlibs
SET FX_GLIDE_HW=CVG
SET FX_HW_PROJECTS=GLIDE
SET HAL_HW=1
SET FX_NO_GEN_BOF=1
Rem SET FX_GLIDE_CTRISETUP=1

REM ------------------------------------------
REM SWITCH TO COMPILER
REM ------------------------------------------
GOTO %CTARGET%

REM ------------------------------------------
REM MSVC Targetting Win32
REM ------------------------------------------
:MSVC
IF NOT "%MSVC%"=="" GOTO MSVCDEFD
ECHO You must set the environment variable MSVC
ECHO   to the install directory for Microsoft 
ECHO   visual C/C++ 4.2 or greater
ECHO eg. SET MSVC=C:\devel\msdev
GOTO END
:MSVCDEFD
SET PATH=%MSVC%\bin;%OLDPATH%;%MASM%\bin

SET INCLUDE=%MSVC%\INCLUDE;%MSVC%\MFC\INCLUDE;%BUILD_ROOT_SWLIBS%\include
SET INCLUDE=%INCLUDE%;%BUILD_ROOT_SWLIBS%\include\nmake;%MASM%\INCLUDE

SET LIB=%MSVC%\lib;%MSVC%\MFC\lib;%MASM%\lib
SET AT_LOADER_MG=1

SET FX_COMPILER=MICROSOFT
SET FX_TARGET=WIN32
SET FX_HOST=DOS
GOTO END


REM ------------------------------------------
REM Watcom Targetting Dos
REM ------------------------------------------
:WATDOS
IF NOT "%WATCOM%"=="" GOTO WATDEFD1
ECHO You must set the environment variable WATCOM
ECHO   to the install directory for Watcom
ECHO   C/C++ 10.6 or greater
ECHO eg. SET WATCOM=C:\devel\WATCOM
GOTO END
:WATDEFD1
SET PATH=%WATCOM%\binnt;%WATCOM%\binw;%OLDPATH%;%NMAKE%;%MASM%\bin

SET INCLUDE=%WATCOM%\H;%WATCOM%\H\NT
SET INCLUDE=%INCLUDE%;%BUILD_ROOT_SWLIBS%\include\nmake;%MASM%\INCLUDE

SET LIB=%WATCOM%\LIB386\DOS;%MASM%\lib

SET FX_COMPILER=WATCOM
SET FX_TARGET=DOS
SET FX_HOST=DOS
SET FX_WATCOM_REG_CALL=
GOTO END

:USAGE
ECHO CSETUP.BAT - Set up 3Dfx Software Build Environment
ECHO USAGE: CSETUP buildspec
ECHO where buildspec is:
ECHO         msvc   - Microsoft Visual C Targetting Win32
ECHO         watdos - Watcom C/C++ 10.6 Targetting Dos
GOTO END

:END
set CTARGET=

