/********************************************************************************
*                                                                               *
*                               Test Splitter Window                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* $Id: splitter.cpp,v 1.3 1999/11/13 06:15:17 jeroen Exp $                      *
********************************************************************************/
#include "fx.h"
#include <stdio.h>
#include <stdlib.h>


/*******************************************************************************/

/* Generated by reswrap from file minidoc1.gif */
const unsigned char minidoc1[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf1,0x00,0x00,0xbf,0xbf,0xbf,
  0x00,0x00,0x00,0xff,0xff,0xff,0x7f,0x7f,0x7f,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,
  0x10,0x00,0x00,0x02,0x39,0x84,0x8f,0x89,0xc1,0x1d,0x7a,0x82,0x98,0x93,0x41,0x20,
  0x87,0x16,0xf2,0x29,0x49,0x71,0xcd,0x27,0x68,0x9b,0x16,0x0c,0x09,0x18,0x56,0xea,
  0x52,0x9a,0x5b,0xba,0xb6,0x14,0x0d,0xcb,0xf3,0x1b,0xd9,0x6e,0xad,0x1b,0x70,0x78,
  0x06,0x56,0x0b,0x17,0x71,0x28,0x89,0x86,0xa0,0xec,0x02,0x05,0x14,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderopen.gif */
const unsigned char minifolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x7f,0x7f,0x7f,0xff,0xff,0xff,0xd9,0xd9,0xd9,0xff,0xff,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xdc,0x2c,0x10,0xba,0x37,0x6a,0x15,0x13,0x88,0x41,0x4a,0x27,0x43,
  0x14,0x29,0x9b,0x67,0x82,0x56,0x18,0x68,0xdc,0xe9,0x12,0x42,0x20,0xce,0x62,0x11,
  0x6f,0x69,0x1e,0xc3,0x72,0xfb,0xb9,0xb2,0x18,0xeb,0x47,0xbc,0xad,0x4a,0xc4,0x93,
  0x6c,0xc5,0x7a,0x99,0x62,0x4c,0x1a,0x2d,0xc0,0x04,0x50,0xaf,0x58,0x6c,0x66,0xcb,
  0x6d,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderclosed.gif */
const unsigned char minifolderclosed[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x3b,0x08,0xba,0xdc,0x1b,0x10,0x3a,0x16,0xc4,0xb0,0x22,0x4c,0x50,0xaf,0xcf,0x91,
  0xc4,0x15,0x64,0x69,0x92,0x01,0x31,0x7e,0xac,0x95,0x8e,0x58,0x7b,0xbd,0x41,0x21,
  0xc7,0x74,0x11,0xef,0xb3,0x5a,0xdf,0x9e,0x1c,0x6f,0x97,0x03,0xba,0x7c,0xa1,0x64,
  0x48,0x05,0x20,0x38,0x9f,0x50,0xe8,0x66,0x4a,0x75,0x24,0x00,0x00,0x3b
  };


/*******************************************************************************/


// Mini application object
class SplitterWindow : public FXMainWindow {
  FXDECLARE(SplitterWindow)
protected:
  FXMenuBar         *menubar;
  FXMenuPane        *filemenu;
  FXMenuPane        *modemenu;
  FXSplitter        *splitter;
  FXStatusbar       *status;
  FXVerticalFrame*   group1;
  FXVerticalFrame*   group2;
  FXVerticalFrame*   group3;
  
protected:
  SplitterWindow(){}

public:
  long onCmdReverse(FXObject*,FXSelector,void*);
  long onCmdNormal(FXObject*,FXSelector,void*);
  long onCmdHorizontal(FXObject*,FXSelector,void*);
  long onCmdVectical(FXObject*,FXSelector,void*);
  long onCmdTracking(FXObject*,FXSelector,void*);
  long onUpdTracking(FXObject*,FXSelector,void*);
  
public:
  enum {
    ID_REVERSE=FXMainWindow::ID_LAST,
    ID_NORMAL,
    ID_HORIZONTAL,
    ID_VERTICAL,
    ID_TRACKING,
    ID_LAST
    };
    
public:
  SplitterWindow(FXApp* a);
  virtual void create();
  };



/*******************************************************************************/
  
// Map
FXDEFMAP(SplitterWindow) SplitterWindowMap[]={
  FXMAPFUNC(SEL_COMMAND,  SplitterWindow::ID_REVERSE,   SplitterWindow::onCmdReverse),
  FXMAPFUNC(SEL_COMMAND,  SplitterWindow::ID_NORMAL,    SplitterWindow::onCmdNormal),
  FXMAPFUNC(SEL_COMMAND,  SplitterWindow::ID_HORIZONTAL,SplitterWindow::onCmdHorizontal),
  FXMAPFUNC(SEL_COMMAND,  SplitterWindow::ID_VERTICAL,  SplitterWindow::onCmdVectical),
  FXMAPFUNC(SEL_COMMAND,  SplitterWindow::ID_TRACKING,  SplitterWindow::onCmdTracking),
  FXMAPFUNC(SEL_UPDATE,   SplitterWindow::ID_TRACKING,  SplitterWindow::onUpdTracking),
  };


// Object implementation
FXIMPLEMENT(SplitterWindow,FXMainWindow,SplitterWindowMap,ARRAYNUMBER(SplitterWindowMap))


// Make some windows
SplitterWindow::SplitterWindow(FXApp* a):FXMainWindow(a,"Splitter Test",NULL,NULL,DECOR_ALL,0,0,800,600){
  FXGIFIcon *folder_open;
  FXGIFIcon *folder_closed;
  FXGIFIcon *doc;
  int i;
  
  // Folder open icon
  folder_open=new FXGIFIcon(getApp(),minifolderopen);
  
  // Folder closed icon
  folder_closed=new FXGIFIcon(getApp(),minifolderclosed);

  // Document icon
  doc=new FXGIFIcon(getApp(),minidoc1);
  
  // Menu bar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // Status bar
  status=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  
  // File menu
  filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"Quit\tCtl-Q",NULL,getApp(),FXApp::ID_QUIT,MENU_DEFAULT);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  
  // Mode menu
  modemenu=new FXMenuPane(this);
  new FXMenuCommand(modemenu,"Reverse\t\tReverse split order",NULL,this,ID_REVERSE);
  new FXMenuCommand(modemenu,"Normal\t\tNormal split order",NULL,this,ID_NORMAL);
  new FXMenuCommand(modemenu,"Horizontal\t\tHorizontal split",NULL,this,ID_HORIZONTAL);
  new FXMenuCommand(modemenu,"Vertical\t\tVertical split",NULL,this,ID_VERTICAL);
  new FXMenuCommand(modemenu,"Tracking\t\tToggle continuous tracking mode",NULL,this,ID_TRACKING);
  new FXMenuTitle(menubar,"&Mode",NULL,modemenu);
    
  // Main window interior
  splitter=new FXSplitter(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_REVERSED|SPLITTER_TRACKING);
  group1=new FXVerticalFrame(splitter,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  group2=new FXVerticalFrame(splitter,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  group3=new FXVerticalFrame(splitter,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y);

  FXTreeList *tree=new FXTreeList(group1,0,NULL,0,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|LAYOUT_RIGHT|TREELIST_SHOWS_LINES|TREELIST_SHOWS_BOXES);
  FXTreeItem *branch,*twig,*leaf,*topmost;

  topmost=tree->addItemLast(0,"Top",folder_open,folder_closed);
  tree->expandTree(topmost);
    tree->addItemLast(topmost,"First",doc,doc);
    tree->addItemLast(topmost,"Second",doc,doc);
    tree->addItemLast(topmost,"Third",doc,doc);
    branch=tree->addItemLast(topmost,"Fourth",folder_open,folder_closed);
    tree->expandTree(branch);
      tree->addItemLast(branch,"Fourth-First",doc,doc);
      tree->addItemLast(branch,"Fourth-Second",doc,doc);
      twig=tree->addItemLast(branch,"Fourth-Third",folder_open,folder_closed);
        tree->addItemLast(twig,"Fourth-Third-First",doc,doc);
        tree->addItemLast(twig,"Fourth-Third-Second",doc,doc);
        tree->addItemLast(twig,"Fourth-Third-Third",doc,doc);
        leaf=tree->addItemLast(twig,"Fourth-Third-Fourth",folder_open,folder_closed);
          tree->addItemLast(leaf,"Fourth-Third-Fourth-First",doc,doc);
          tree->addItemLast(leaf,"Fourth-Third-Fourth-Second",doc,doc);
          tree->addItemLast(leaf,"Fourth-Third-Fourth-Third",doc,doc);
      twig=tree->addItemLast(branch,"Fourth-Fourth",folder_open,folder_closed);
        tree->addItemLast(twig,"Fourth-Fourth-First",doc,doc);
        tree->addItemLast(twig,"Fourth-Fourth-Second",doc,doc);
        tree->addItemLast(twig,"Fourth-Fourth-Third",doc,doc);
        for(i=0; i<10; i++){
          char name[50];
          sprintf(name,"%09d",i);
          tree->addItemLast(twig,name,doc,doc);
          }
      twig=tree->addItemLast(branch,"Fourth-Fifth",folder_open,folder_closed);
      tree->expandTree(twig);
        tree->addItemLast(twig,"Fourth-Fifth-First",doc,doc);
        tree->addItemLast(twig,"Fourth-Fifth-Second",doc,doc);
        tree->addItemLast(twig,"Fourth-Fifth-Third",doc,doc);
        for(i=0; i<10; i++){
          char name[50];
          sprintf(name,"%09d",i);
          tree->addItemLast(twig,name,doc,doc);
          }
    tree->addItemLast(topmost,"Fifth",doc,doc);
    tree->addItemLast(topmost,"Sixth",doc,doc);
    branch=tree->addItemLast(topmost,"Seventh",folder_open,folder_closed);
      tree->addItemLast(branch,"Seventh-First",doc,doc);
      tree->addItemLast(branch,"Seventh-Second",doc,doc);
      tree->addItemLast(branch,"Seventh-Third",doc,doc);
    tree->addItemLast(topmost,"Eighth",doc,doc);
    
  
  new FXLabel(group2,"Matrix",NULL,LAYOUT_CENTER_X);
  new FXHorizontalSeparator(group2,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  FXMatrix* matrix=new FXMatrix(group2,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X);
  
  new FXLabel(matrix,"Alpha:",NULL,JUSTIFY_RIGHT|LAYOUT_FILL_X|LAYOUT_CENTER_Y);
  new FXTextField(matrix,2,NULL,0,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
  new FXLabel(matrix,"Beta:",NULL,JUSTIFY_RIGHT|LAYOUT_FILL_X|LAYOUT_CENTER_Y);
  new FXTextField(matrix,2,NULL,0,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
  new FXLabel(matrix,"Gamma:",NULL,JUSTIFY_RIGHT|LAYOUT_FILL_X|LAYOUT_CENTER_Y);
  new FXTextField(matrix,2,NULL,0,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN);
  
  new FXCheckButton(group2,"Continuous Tracking\tSplitter continuously tracks split changes",this,ID_TRACKING);
  
  new FXLabel(group3,"Quite a Stretch",NULL,LAYOUT_CENTER_X);
  new FXHorizontalSeparator(group3,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  FXMatrix* mat=new FXMatrix(group3,3,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  new FXButton(mat,"One\nStretch the row\nStretch in Y\nStretch in X\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_ROW);
  new FXButton(mat,"Two\nStretch in Y\nStretch in X\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X);
  new FXButton(mat,"Three\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_ROW);
  
  new FXButton(mat,"Four\nStretch the column\nStretch the row\nStretch in Y\nStretch in X\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN);
  new FXButton(mat,"Five\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN);
  new FXButton(mat,"Six\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  new FXButton(mat,"Seven\nStretch the column\nStretch the row\nCenter in Y\nCenter in X\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN);
  new FXButton(mat,"Eight\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_COLUMN);
  new FXButton(mat,"Nine\nStretch the column\nStretch the row\nStretch in Y\tThe possibilities are endless..",NULL,NULL,0,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_FILL_Y|LAYOUT_FILL_ROW|LAYOUT_FILL_COLUMN);
  
  // Make a tool tip
  new FXTooltip(getApp(),0);
  }
  

long SplitterWindow::onCmdReverse(FXObject*,FXSelector,void*){
  splitter->setSplitterStyle(splitter->getSplitterStyle()|SPLITTER_REVERSED);
  return 1;
  }


long SplitterWindow::onCmdNormal(FXObject*,FXSelector,void*){
  splitter->setSplitterStyle(splitter->getSplitterStyle()&~SPLITTER_REVERSED);
  return 1;
  }

long SplitterWindow::onCmdHorizontal(FXObject*,FXSelector,void*){
  splitter->setSplitterStyle(splitter->getSplitterStyle()&~SPLITTER_VERTICAL);
  return 1;
  }

long SplitterWindow::onCmdVectical(FXObject*,FXSelector,void*){
  splitter->setSplitterStyle(splitter->getSplitterStyle()|SPLITTER_VERTICAL);
  return 1;
  }

long SplitterWindow::onCmdTracking(FXObject*,FXSelector,void*){
  splitter->setSplitterStyle(splitter->getSplitterStyle()^SPLITTER_TRACKING);
  return 1;
  }

long SplitterWindow::onUpdTracking(FXObject* sender,FXSelector,void*){
  if(splitter->getSplitterStyle()&SPLITTER_TRACKING){
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
    }
  else{
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
    }
  return 1;
  }



// Start
void SplitterWindow::create(){
  FXMainWindow::create();
  show();
  }


/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){
  FXApp* application=new FXApp("Splitter","Test");
  application->init(argc,argv);
  SplitterWindow* mainwindow=new SplitterWindow(application);
  application->create();
  mainwindow->show();
  application->run();
  }


