/********************************************************************************
*                                                                               *
*                    O p e n G L   C a n v a s   O b j e c t                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLCanvas.cpp,v 1.7 1999/11/08 20:31:47 jeroen Exp $                    *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXVisual.h"
#include "FXGLVisual.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXCursor.h"
#include "FXGLCanvas.h"

/*
  To do:
  - GL Context is part of the window, as it contains much stuff
    we don't share it with other windows.
  - Need shared display list facility
*/



/*******************************************************************************/


// Map
FXDEFMAP(FXGLCanvas) FXGLCanvasMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXGLCanvas::onPaint),
  FXMAPFUNC(SEL_MOTION,0,FXGLCanvas::onMotion),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXGLCanvas::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXGLCanvas::onLeftBtnRelease),
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS,0,FXGLCanvas::onMiddleBtnPress),
  FXMAPFUNC(SEL_MIDDLEBUTTONRELEASE,0,FXGLCanvas::onMiddleBtnRelease),
  FXMAPFUNC(SEL_RIGHTBUTTONPRESS,0,FXGLCanvas::onRightBtnPress),
  FXMAPFUNC(SEL_RIGHTBUTTONRELEASE,0,FXGLCanvas::onRightBtnRelease),
  FXMAPFUNC(SEL_KEYPRESS,0,FXGLCanvas::onKeyPress),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXGLCanvas::onKeyRelease),
  };


// Object implementation
FXIMPLEMENT(FXGLCanvas,FXWindow,FXGLCanvasMap,ARRAYNUMBER(FXGLCanvasMap))

  
// For serialization
FXGLCanvas::FXGLCanvas(){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  ctx=0;
  }


// Make a canvas
FXGLCanvas::FXGLCanvas(FXComposite* p,FXGLVisual *vis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXWindow(p,opts,x,y,w,h){
  flags|=FLAG_ENABLED|FLAG_SHOWN;
  visual=vis;
  target=tgt;
  message=sel;
  ctx=0;
  }


// Canvas is an object drawn by another
long FXGLCanvas::onPaint(FXObject*,FXSelector,void* ptr){
  return target && target->handle(this,MKUINT(message,SEL_PAINT),ptr);
  }


// Handle buttons if not handled in derived class
long FXGLCanvas::onLeftBtnPress(FXObject*,FXSelector,void* ptr){
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    grab();
    if(target) target->handle(this,MKUINT(message,SEL_LEFTBUTTONPRESS),ptr);
    return 1;
    }
  return 0;
  }

long FXGLCanvas::onLeftBtnRelease(FXObject*,FXSelector,void* ptr){
  if(isEnabled()){
    ungrab();
    if(target) target->handle(this,MKUINT(message,SEL_LEFTBUTTONRELEASE),ptr);
    return 1;
    }
  return 0;
  }

long FXGLCanvas::onMiddleBtnPress(FXObject*,FXSelector,void* ptr){
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    grab();
    if(target) target->handle(this,MKUINT(message,SEL_MIDDLEBUTTONPRESS),ptr);
    return 1;
    }
  return 0;
  }

long FXGLCanvas::onMiddleBtnRelease(FXObject*,FXSelector,void* ptr){
  if(isEnabled()){
    ungrab();
    if(target) target->handle(this,MKUINT(message,SEL_MIDDLEBUTTONRELEASE),ptr);
    return 1;
    }
  return 0;
  }

long FXGLCanvas::onRightBtnPress(FXObject*,FXSelector,void* ptr){
  flags&=~FLAG_TIP;
  if(isEnabled()){
    handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
    grab();
    if(target) target->handle(this,MKUINT(message,SEL_RIGHTBUTTONPRESS),ptr);
    return 1;
    }
  return 0;
  }

long FXGLCanvas::onRightBtnRelease(FXObject*,FXSelector,void* ptr){
  if(isEnabled()){
    ungrab();
    if(target) target->handle(this,MKUINT(message,SEL_RIGHTBUTTONRELEASE),ptr);
    return 1;
    }
  return 0;
  }


// Mouse moved
long FXGLCanvas::onMotion(FXObject*,FXSelector,void* ptr){
  return isEnabled() && target && target->handle(this,MKUINT(message,SEL_MOTION),ptr);
  }


// Handle keyboard press/release 
long FXGLCanvas::onKeyPress(FXObject*,FXSelector,void* ptr){
  flags&=~FLAG_TIP;
  return isEnabled() && target && target->handle(this,MKUINT(message,SEL_KEYPRESS),ptr);
  }


long FXGLCanvas::onKeyRelease(FXObject*,FXSelector,void* ptr){
  return isEnabled() && target && target->handle(this,MKUINT(message,SEL_KEYRELEASE),ptr);
  }


/*******************************************************************************/


// Create X window (GL CANVAS)
void FXGLCanvas::create(){
  FXWindow::create();
#ifdef HAVE_OPENGL
  if(!ctx){
    if(!visual->info){ fxerror("%s::create(): visual unsuitable for OpenGL.\n",getClassName()); }
#ifndef FX_NATIVE_WIN32
    ctx=glXCreateContext(getApp()->display,(XVisualInfo*)visual->info,NULL,TRUE);
#else
    // Make that the pixel format of the device context 
    HDC hdc=::GetDC((HWND)xid);
    if(SetPixelFormat(hdc,visual->pixelformat,visual->info)){
      ctx=(void*)wglCreateContext(hdc);
      if(!ctx){ fxerror("%s::create(): wglCreateContext() failed.\n"); }
      }
    else
      fxerror("%s::create(): SetPixelFormat() failed.\n");
    ::ReleaseDC((HWND)xid,hdc);
#endif
    }
#endif
  }


// Detach the GL Canvas
void FXGLCanvas::detach(){
#ifdef HAVE_OPENGL
  if(ctx){
    // Will this leak memory?
    ctx=0;
    }
#endif
  FXWindow::detach();
  }


// Destroy the GL Canvas
void FXGLCanvas::destroy(){
#ifdef HAVE_OPENGL
  if(ctx){
#ifndef FX_NATIVE_WIN32
    glXDestroyContext(getApp()->display,(GLXContext)ctx);
#else
    wglDeleteContext((HGLRC)ctx);
#endif
    ctx=0;
    }
#endif
  FXWindow::destroy();
  }


// Move window
void FXGLCanvas::move(FXint x,FXint y){
  FXWindow::move(x,y);
  if(target){
    FXEvent event;
    event.type=SEL_CONFIGURE;
    event.window=xid;
    event.rect.x=xpos;
    event.rect.y=ypos;
    event.rect.w=width;
    event.rect.h=height;
    event.synthetic=TRUE;
    target->handle(this,MKUINT(message,SEL_CONFIGURE),&event);
    }
  }


// Move and resize
void FXGLCanvas::position(FXint x,FXint y,FXint w,FXint h){
  FXWindow::position(x,y,w,h);
  if(target){
    FXEvent event;
    event.type=SEL_CONFIGURE;
    event.window=xid;
    event.rect.x=xpos;
    event.rect.y=ypos;
    event.rect.w=width;
    event.rect.h=height;
    event.synthetic=TRUE;
    target->handle(this,MKUINT(message,SEL_CONFIGURE),&event);
    }
  }


// Resize
void FXGLCanvas::resize(FXint w,FXint h) {
  FXWindow::resize(w,h);
  if(target){
    FXEvent event;
    event.type=SEL_CONFIGURE;
    event.window=xid;
    event.rect.x=xpos;
    event.rect.y=ypos;
    event.rect.w=width;
    event.rect.h=height;
    event.synthetic=TRUE;
    target->handle(this,MKUINT(message,SEL_CONFIGURE),&event);
    }
  }


//  Make the rendering context of GL Canvas current
FXbool FXGLCanvas::makeCurrent(){
#ifdef HAVE_OPENGL
  if(ctx){
#ifndef FX_NATIVE_WIN32
    return glXMakeCurrent(getApp()->display,xid,(GLXContext)ctx);
#else
    HDC hdc=::GetDC((HWND)xid);
    BOOL bStatus=wglMakeCurrent(hdc,(HGLRC)ctx);
    return bStatus;
#endif
    }
#endif
  return FALSE;
  }
  
  
//  Make the rendering context of GL Canvas current
FXbool FXGLCanvas::makeNonCurrent(){
#ifdef HAVE_OPENGL
  if(ctx){
#ifndef FX_NATIVE_WIN32
    return glXMakeCurrent(getApp()->display,None,(GLXContext)NULL);
#else
    HDC hdc=wglGetCurrentDC();
    BOOL bStatus=wglMakeCurrent(NULL,NULL);
    ::ReleaseDC((HWND)xid,hdc);
    return bStatus;
#endif
    }
#endif
  return FALSE;
  }


// Used by GL to swap the buffers in double buffer mode, or flush a single buffer
void FXGLCanvas::swapBuffers(){
#ifdef HAVE_OPENGL
#ifndef FX_NATIVE_WIN32
  glXSwapBuffers(getApp()->display,xid);
#else
  SwapBuffers(wglGetCurrentDC());
#endif
#endif
  }


// This function only available on Mesa
void FXGLCanvas::swapSubBuffers(FXint x,FXint y,FXint w,FXint h){
#if defined(HAVE_OPENGL) && !defined(FX_NATIVE_WIN32)
#ifdef HAVE_MESA
#ifdef GLX_MESA_copy_sub_buffer
  glXCopySubBufferMESA(getApp()->display,xid,x,height-y-h-1,w,h);
#else
  glXSwapBuffers(getApp()->display,xid);
#endif
#endif
#endif
  }


// Close and release any resources
FXGLCanvas::~FXGLCanvas(){
#ifdef HAVE_OPENGL
  if(ctx){
#ifndef FX_NATIVE_WIN32
    glXDestroyContext(getApp()->display,(GLXContext)ctx);
#else
    wglDeleteContext((HGLRC)ctx);
#endif
    }
#endif
  }
