/********************************************************************************
*                                                                               *
*                     D i r e c t o r y   L i s t   O b j e c t                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDirList.cpp,v 1.13 1999/11/16 21:24:45 jeroen Exp $                    *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXBMPIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXComposite.h"
#include "FXCanvas.h"
#include "FXShell.h"
#include "FXScrollbar.h"
#include "FXScrollWindow.h"
#include "FXTreeList.h"
#include "FXDirList.h"
#include "FXFileDict.h"



/*
  Notes:
  - One can never create items in constructor:- createItem() may be overloaded!
  - Instead of FXTreeItems, callbacks should pass pointer to directory?
  - Clipboard of a filenames.
  - Should do drag and drop and such.
  - Should be able to set initial directory/filename path, i.e. open all from
    root through last pathname segment which really exists.
  - Clipboard, DND, etc. support.
  - We should NOT assume the root's name is just '/'.  It could be C:\ etc.
  - Try read icons from <path>/.dir.gif and <path>/.opendir.gif!
  - Special icon for root.
*/


#define REFRESHINTERVAL     1000          // Interval between refreshes
#define REFRESHFREQUENCY    32            // File systems not supporting mod-time, refresh every nth time

/*******************************************************************************/

/* Generated by reswrap from file minifolderopen.gif */
const unsigned char minifolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x7f,0x7f,0x7f,0xff,0xff,0xff,0xd9,0xd9,0xd9,0xff,0xff,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xdc,0x2c,0x10,0xba,0x37,0x6a,0x15,0x13,0x88,0x41,0x4a,0x27,0x43,
  0x14,0x29,0x9b,0x67,0x82,0x56,0x18,0x68,0xdc,0xe9,0x12,0x42,0x20,0xce,0x62,0x11,
  0x6f,0x69,0x1e,0xc3,0x72,0xfb,0xb9,0xb2,0x18,0xeb,0x47,0xbc,0xad,0x4a,0xc4,0x93,
  0x6c,0xc5,0x7a,0x99,0x62,0x4c,0x1a,0x2d,0xc0,0x04,0x50,0xaf,0x58,0x6c,0x66,0xcb,
  0x6d,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderclosed.gif */
const unsigned char minifolderclosed[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x3b,0x08,0xba,0xdc,0x1b,0x10,0x3a,0x16,0xc4,0xb0,0x22,0x4c,0x50,0xaf,0xcf,0x91,
  0xc4,0x15,0x64,0x69,0x92,0x01,0x31,0x7e,0xac,0x95,0x8e,0x58,0x7b,0xbd,0x41,0x21,
  0xc7,0x74,0x11,0xef,0xb3,0x5a,0xdf,0x9e,0x1c,0x6f,0x97,0x03,0xba,0x7c,0xa1,0x64,
  0x48,0x05,0x20,0x38,0x9f,0x50,0xe8,0x66,0x4a,0x75,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minidoc.gif */
const unsigned char minidoc[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xbf,0xbf,0xbf,
  0x80,0x80,0x80,0xff,0xff,0xff,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x36,0x08,0x10,0xdc,0xae,0x70,0x89,0x49,0xe7,0x08,0x51,0x56,0x3a,0x04,0x86,0xc1,
  0x46,0x11,0x24,0x01,0x8a,0xd5,0x60,0x2a,0x21,0x6a,0xad,0x9a,0xab,0x9e,0xae,0x30,
  0xb3,0xb5,0x0d,0xb7,0xf2,0x9e,0xdf,0x31,0x14,0x90,0x27,0xf4,0xd5,0x86,0x83,0xa4,
  0x72,0x09,0x2c,0x39,0x9f,0xa6,0x04,0x00,0x3b
  };

/* Generated by reswrap from file miniapp.gif */
const unsigned char miniapp[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x38,0x08,0xba,0xdc,0x10,0x30,0xca,0x09,0x85,0xbd,0xf8,0x86,0x11,0x44,0xf9,0x60,
  0xf8,0x6d,0x9d,0x58,0x10,0x03,0x8a,0x92,0x02,0xe5,0x72,0x02,0x21,0xcf,0xb4,0xcc,
  0xd6,0x38,0x71,0xe7,0xf4,0xce,0xdb,0xb0,0xdf,0xcc,0xf7,0x23,0xf2,0x48,0xae,0xd7,
  0x60,0xc9,0x6c,0x3a,0x07,0x8e,0xe8,0x22,0x01,0x00,0x3b
  };
    
  
const unsigned char floppy[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,
  0x00,0x00,0x00,0x00,0x0d,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x70,0xdd,0x78,0x88,
  0xff,0xff,0x88,0x88,0x77,0x0d,0x78,0x77,0x00,0x00,0x77,0x78,0x77,0x0d,0x78,0x88,
  0x77,0x77,0x88,0x88,0x77,0x0d,0x78,0x88,0x88,0x88,0x88,0x98,0x77,0x0d,0x7f,0xff,
  0xff,0xff,0xf0,0x00,0x00,0x0d,0xd7,0x88,0x88,0x88,0x78,0x70,0x7f,0x80,0xdd,0x77,
  0x77,0x77,0x78,0x77,0x77,0x80,0xdd,0xdd,0xdd,0xdd,0x78,0x88,0x88,0x80,0xdd,0xdd,
  0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,
  0xdd,0xdd,0x78,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,
  0xdd,0xdd,0xd7,0x77,0x77,0x7d
  };

const unsigned char harddisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x77,0x77,
  0x77,0x77,0x77,0x77,0x77,0x0d,0x78,0xff,0xff,0xff,0xff,0xff,0x87,0x70,0x78,0x77,
  0x77,0x77,0x77,0x77,0x87,0x70,0x78,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x78,0x88,
  0x88,0x88,0x88,0x82,0x87,0x70,0x7f,0xff,0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,
  0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char cdrom[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,
  0x00,0x00,0x00,0x00,0x00,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x0d,0x7f,0x88,
  0xff,0xff,0xf8,0x88,0x87,0x0d,0x7f,0xa2,0x00,0x00,0x00,0x00,0x87,0x0d,0x7f,0x88,
  0x88,0x87,0x78,0x88,0x00,0x0d,0x7f,0xff,0xff,0x78,0xf8,0x88,0xa7,0x0d,0xd7,0x77,
  0x77,0x78,0x8f,0x88,0xbe,0x70,0xdd,0xdd,0xd7,0x88,0x87,0x07,0xe8,0x80,0xdd,0xdd,
  0xd7,0x88,0xa0,0xd0,0x88,0x80,0xdd,0xdd,0xd7,0x8a,0xa7,0x07,0xf8,0x80,0xdd,0xdd,
  0xdd,0x7a,0xeb,0xb8,0x8f,0x0d,0xdd,0xdd,0xdd,0x7e,0xeb,0xb8,0x88,0x0d,0xdd,0xdd,
  0xdd,0xd7,0x7b,0xb8,0x77,0xdd,0xdd,0xdd,0xdd,0xdd,0xd7,0x77,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char networkdisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0x00,0x00,0xdd,0xdd,0xdd,0x00,0x00,0x00,0xbf,0x30,0x00,0x00,0x00,0x88,0x88,
  0x88,0x33,0x30,0x88,0x88,0x88,0xdd,0xdd,0xdd,0xd8,0x0d,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xd0,0x0d,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x78,0xff,
  0xff,0xff,0xff,0xff,0x87,0x0d,0x78,0x77,0x77,0x77,0x77,0x77,0x87,0x70,0x78,0x88,
  0x88,0x88,0x88,0x88,0x87,0x70,0x78,0x88,0x88,0x88,0x88,0x82,0xa7,0x70,0x7f,0xff,
  0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,
  0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char zipdisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x7f,0x77,
  0x77,0x77,0x77,0x77,0x77,0x0d,0x7f,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x7f,0x88,
  0x8f,0xff,0xff,0xf8,0x87,0x70,0x7f,0x88,0xf0,0x00,0x00,0x0f,0x87,0x70,0x7f,0x98,
  0x70,0x00,0x00,0x07,0x87,0x70,0x7f,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x7f,0xff,
  0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,
  0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

  
/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXDirItem,FXTreeItem,NULL,0)

  
/*******************************************************************************/

// Map
FXDEFMAP(FXDirList) FXDirListMap[]={
  FXMAPFUNC(SEL_DRAGGED,0,FXDirList::onDragged),
  FXMAPFUNC(SEL_TIMEOUT,FXDirList::ID_REFRESH,FXDirList::onRefresh),
  FXMAPFUNC(SEL_DND_ENTER,0,FXDirList::onDNDEnter),
  FXMAPFUNC(SEL_DND_LEAVE,0,FXDirList::onDNDLeave),
  FXMAPFUNC(SEL_DND_DROP,0,FXDirList::onDNDDrop),
  FXMAPFUNC(SEL_DND_MOTION,0,FXDirList::onDNDMotion),
  FXMAPFUNC(SEL_DND_REQUEST,0,FXDirList::onDNDRequest),
  FXMAPFUNC(SEL_BEGINDRAG,0,FXDirList::onBeginDrag),
  FXMAPFUNC(SEL_ENDDRAG,0,FXDirList::onEndDrag),
  FXMAPFUNC(SEL_EXPANDED,0,FXDirList::onItemExpanded),
  FXMAPFUNC(SEL_COLLAPSED,0,FXDirList::onItemCollapsed),
  FXMAPFUNC(SEL_SELECTION_REQUEST,0,FXDirList::onSelectionRequest),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_SHOW_HIDDEN,FXDirList::onUpdShowHidden),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_HIDE_HIDDEN,FXDirList::onUpdHideHidden),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_TOGGLE_HIDDEN,FXDirList::onUpdToggleHidden),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_SHOW_FILES,FXDirList::onUpdShowFiles),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_HIDE_FILES,FXDirList::onUpdHideFiles),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_TOGGLE_FILES,FXDirList::onUpdToggleFiles),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_SET_PATTERN,FXDirList::onUpdSetPattern),
  FXMAPFUNC(SEL_UPDATE,FXDirList::ID_SORT_REVERSE,FXDirList::onUpdSortReverse),
  FXMAPFUNC(SEL_OPENED,0,FXDirList::onItemOpened),
  FXMAPFUNC(SEL_CLOSED,0,FXDirList::onItemClosed),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXDirList::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXDirList::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXDirList::onCmdGetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_SHOW_HIDDEN,FXDirList::onCmdShowHidden),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_HIDE_HIDDEN,FXDirList::onCmdHideHidden),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_TOGGLE_HIDDEN,FXDirList::onCmdToggleHidden),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_SHOW_FILES,FXDirList::onCmdShowFiles),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_HIDE_FILES,FXDirList::onCmdHideFiles),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_TOGGLE_FILES,FXDirList::onCmdToggleFiles),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_SET_PATTERN,FXDirList::onCmdSetPattern),
  FXMAPFUNC(SEL_COMMAND,FXDirList::ID_SORT_REVERSE,FXDirList::onCmdSortReverse),
  };


// Object implementation
FXIMPLEMENT(FXDirList,FXTreeList,FXDirListMap,ARRAYNUMBER(FXDirListMap))

  
// For serialization
FXDirList::FXDirList(){
  refresh=NULL;
  counter=0;
  }


// Directory List Widget
FXDirList::FXDirList(FXComposite *p,FXint nvis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXTreeList(p,nvis,tgt,sel,opts,x,y,w,h),pattern("*"){
  associations=new FXFileDict(getApp());
  open_folder=new FXGIFIcon(getApp(),minifolderopen);
  closed_folder=new FXGIFIcon(getApp(),minifolderclosed);
  mini_doc=new FXGIFIcon(getApp(),minidoc);
  mini_app=new FXGIFIcon(getApp(),miniapp);
  cdromicon=new FXBMPIcon(getApp(),cdrom,0,IMAGE_ALPHAGUESS);
  harddiskicon=new FXBMPIcon(getApp(),harddisk,0,IMAGE_ALPHAGUESS);
  networkicon=new FXBMPIcon(getApp(),networkdisk,0,IMAGE_ALPHAGUESS);
  floppyicon=new FXBMPIcon(getApp(),floppy,0,IMAGE_ALPHAGUESS);
  zipdiskicon=new FXBMPIcon(getApp(),zipdisk,0,IMAGE_ALPHAGUESS);
  matchmode=FILEMATCH_FILE_NAME|FILEMATCH_PERIOD|FILEMATCH_NOESCAPE;
#ifdef WIN32
  matchmode|=FILEMATCH_CASEFOLD;
#endif
  sortfunc=cmpFName;
  refresh=NULL;
  counter=0;
  }


// Create X window
void FXDirList::create(){
  FXTreeList::create();
  if(!refresh) refresh=getApp()->addTimeout(REFRESHINTERVAL,this,ID_REFRESH);
  open_folder->create();
  closed_folder->create();
  mini_doc->create();
  mini_app->create();
  cdromicon->create();
  harddiskicon->create();
  networkicon->create();
  floppyicon->create();
  zipdiskicon->create();
  scanRootDir(FALSE);
  }


// Detach disconnects the icons
void FXDirList::detach(){
  if(refresh) refresh=getApp()->removeTimeout(refresh);
  open_folder->detach();
  closed_folder->detach();
  mini_doc->detach();
  mini_app->detach();
  cdromicon->detach();
  harddiskicon->detach();
  networkicon->detach();
  floppyicon->detach();
  zipdiskicon->detach();
  FXTreeList::detach();
  }


// Destroy zaps the icons
void FXDirList::destroy(){
  if(refresh) refresh=getApp()->removeTimeout(refresh);
  open_folder->destroy();
  closed_folder->destroy();
  mini_doc->destroy();
  mini_app->destroy();
  FXTreeList::destroy();
  }


// Create item
FXTreeItem* FXDirList::createItem(const FXString& text,FXIcon* oi,FXIcon* ci,void* ptr){ 
  return (FXTreeItem*) new FXDirItem(text,oi,ci,ptr); 
  }


// Compare file names
FXbool FXDirList::cmpFName(const FXTreeItem* a,const FXTreeItem* b){
  return strcmp(((FXDirItem*)a)->label.text(),((FXDirItem*)b)->label.text())>=0;
  }


// Compare file names
FXbool FXDirList::cmpRName(const FXTreeItem* a,const FXTreeItem* b){
  return strcmp(((FXDirItem*)a)->label.text(),((FXDirItem*)b)->label.text())<=0;
  }


// Helper function 
FXchar *FXDirList::getpath(const FXTreeItem* item,FXchar* pathname) const {
  register FXchar *ptr=pathname;
  register const FXchar *p;
  register FXuint ss=0;
  const FXchar *stack[100];
  FXASSERT(pathname);
  while(item){
    stack[ss++]=item->label.text();
    item=item->parent;
    }
  FXASSERT(ss<100);
  if(ss){
    p=stack[--ss];
    FXASSERT(p);
    while(*p){*ptr++=*p++;}
    if(ss){
      while(1){
        p=stack[--ss];
        FXASSERT(p);
        while(*p){*ptr++=*p++;}
        if(!ss) break;
        *ptr++=PATHSEP;
        }
      }
    }
  *ptr='\0';
  FXASSERT((ptr-pathname)<MAXPATHLEN);
  return pathname;
  }


// Helper function:- this is one ugly mother
FXTreeItem* FXDirList::getitem(FXchar* pathname){
  FXchar buffer[MAXPATHLEN];
  register FXchar *ptr=pathname;
  register FXchar *p;
  FXbool changed;
  FXTreeItem *item,*it;
  recalc();
  update();
  if(!firstitem){
    scanRootDir(FALSE);
    }
  if(!firstitem) return NULL;
  ptr=strchr(pathname,PATHSEP);
  if(!ptr) return firstitem;
  ptr=ptr+1;
  p=strchr(ptr,PATHSEP);
  if(p) *p=0;
  item=firstitem;
  while(*ptr){
    //FXTRACE((100,"searching for %s\n",ptr));
    for(it=item->first; it; it=it->next){   // First try with what we've got
      if(strcmp(ptr,it->label.text())==0) goto x;
      }
    getpath(item,buffer);
    //FXTRACE((100,"listing subdirs of %s\n",buffer));
    changed=listSubDir((FXDirItem*)item,buffer);      // Didn't find it, try relist
    if(!changed) return item;                         // No change, its not there!
    if(!item->first)                                  // Now have knowledge of subitems
      item->state&=~FXDirItem::HASITEMS; 
    else 
      item->state|=FXDirItem::HASITEMS;
  //////// Missing update here somewhere...
    sortChildItems(item);                             // Sort items
    //FXTRACE((100,"searching for %s again\n",ptr));
    for(it=item->first; it; it=it->next){             // Try find it again with new list
      if(strcmp(ptr,it->label.text())==0) goto x;
      }
    //FXTRACE((100,"%s not found\n",ptr));
    return item;                                      // No luck!
x:  item=it;
    if(!p) break;
    ptr=p+1;
    if(*ptr==0) break;
    p=strchr(ptr,PATHSEP);
    if(p) *p=0;
    }
  return item;
  }
      
    
// Somebody wants our selection
long FXDirList::onSelectionRequest(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handle through base class first
  if(FXTreeList::onSelectionRequest(sender,sel,ptr)) return 1;
  
//   // Otherwise (most likely) its the string from this text we return
//   // Strictly speaking, we should return ALL selected items, not just the current one
//   if(currentitem && isItemSelected(currentitem)){
//     if(event->target==stringType){
//       FXCALLOC(&data,FXuchar,MAXPATHLEN+1);
//       getpath(currentitem,(FXchar*)data);
//       setDNDData(event->origin,stringType,data,strlen((FXchar*)data)+1);
//       }
//     }
  return 0;
  }


/*******************************************************************************/


// Handle drag-and-drop enter
long FXDirList::onDNDEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXTreeList::onDNDEnter(sender,sel,ptr);
  return 1;
  }


// Handle drag-and-drop leave
long FXDirList::onDNDLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXTreeList::onDNDLeave(sender,sel,ptr);
  return 1;
  }


// Handle drag-and-drop motion
long FXDirList::onDNDMotion(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  if(startAutoScroll(event->win_x,event->win_y,FALSE)) return 1;
  FXTreeList::onDNDMotion(sender,sel,ptr);
  return 1;
  }


// Handle drag-and-drop drop
long FXDirList::onDNDDrop(FXObject* sender,FXSelector sel,void* ptr){
  FXTreeList::onDNDDrop(sender,sel,ptr);
  return 1;
  }


// Somebody wants our dragged data
long FXDirList::onDNDRequest(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handle through base class first
  if(FXTreeList::onDNDRequest(sender,sel,ptr)) return 1;

  // Find what type they wanted
  return 0;
  }


// Start a drag operation
long FXDirList::onBeginDrag(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXTreeList::onBeginDrag(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onBeginDrag %08x\n",getClassName(),this));
  return 1;
  }


// End drag operation
long FXDirList::onEndDrag(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXTreeList::onEndDrag(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onEndDrag %08x\n",getClassName(),this));
  return 1;
  }


// Dragged stuff around
long FXDirList::onDragged(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXTreeList::onDragged(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onDragged %08x\n",getClassName(),this));
  return 1;
  }


/*******************************************************************************/


// Open up the path down to the given string
long FXDirList::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  if(ptr){ setCurrentFile((const FXchar*)ptr); }
  return 1;
  }


// Open up the path down to the given string
long FXDirList::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setCurrentFile(*((FXString*)ptr));
  return 1;
  }


// Obtain value of the current item
long FXDirList::onCmdGetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetStringValue: NULL pointer.\n",getClassName()); }
  *((FXString*)ptr)=getCurrentFile();
  return 1;
  }


// Toggle hidden files
long FXDirList::onCmdToggleHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(!showHiddenFiles());
  return 1;
  }


// Update toggle hidden files widget
long FXDirList::onUpdToggleHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Show hidden files
long FXDirList::onCmdShowHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(TRUE);
  return 1;
  }


// Update show hidden files widget
long FXDirList::onUpdShowHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Hide hidden files
long FXDirList::onCmdHideHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(FALSE);
  return 1;
  }


// Update hide hidden files widget
long FXDirList::onUpdHideHidden(FXObject* sender,FXSelector,void*){
  if(!showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Toggle files display
long FXDirList::onCmdToggleFiles(FXObject*,FXSelector,void*){
  showFiles(!showFiles());
  return 1;
  }


// Update toggle files widget
long FXDirList::onUpdToggleFiles(FXObject* sender,FXSelector,void*){
  if(showFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Show files
long FXDirList::onCmdShowFiles(FXObject*,FXSelector,void*){
  showFiles(TRUE);
  return 1;
  }


// Update show files widget
long FXDirList::onUpdShowFiles(FXObject* sender,FXSelector,void*){
  if(showFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Hide files
long FXDirList::onCmdHideFiles(FXObject*,FXSelector,void*){
  showFiles(FALSE);
  return 1;
  }


// Update hide files widget
long FXDirList::onUpdHideFiles(FXObject* sender,FXSelector,void*){
  if(!showFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Change pattern
long FXDirList::onCmdSetPattern(FXObject*,FXSelector,void* ptr){
  if(!ptr) return 0;
  setPattern((const char*)ptr);
  return 1;
  }


// Update pattern
long FXDirList::onUpdSetPattern(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETVALUE,SEL_COMMAND),(void*)pattern.text());
  return 1;
  }


// Reverse sort order
long FXDirList::onCmdSortReverse(FXObject*,FXSelector,void*){
  if(sortfunc==cmpFName) sortfunc=cmpRName; 
  else if(sortfunc==cmpRName) sortfunc=cmpFName;
  scanRootDir(TRUE);
  return 1;
  }


// Update sender
long FXDirList::onUpdSortReverse(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpRName)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Close directory
long FXDirList::onItemClosed(FXObject* sender,FXSelector sel,void* ptr){
  FXDirItem *item=(FXDirItem*)ptr;
  if(!(item->state&FXDirItem::FOLDER)) return 0;
  FXTreeList::onItemClosed(sender,sel,ptr);
  FXTRACE((100,"%s::onItemClosed: %s\n",getClassName(),item->label.text()));
  return 1;
  }


// Open directory:- just determine presence of subdirs
long FXDirList::onItemOpened(FXObject* sender,FXSelector sel,void* ptr){
  FXDirItem *item=(FXDirItem*)ptr;
  FXchar path[MAXPATHLEN];
  FXbool changed;
  if(!(item->state&FXDirItem::FOLDER)) return 0;
  FXTreeList::onItemOpened(sender,sel,ptr);
  
  // Get path to item
  getpath(item,path);
  
  FXTRACE((100,"%s::onItemOpened: %s path=%s\n",getClassName(),item->label.text(),path));
  
  // List stuff in item directory
  changed=listSubDir(item,path);
  
  // Now we know for sure whether we really have subitems or not
  if(!item->first) item->state&=~FXDirItem::HASITEMS; else item->state|=FXDirItem::HASITEMS;
  //////// Missing update here somewhere...
  // Sort items
  if(changed){
    sortChildItems(item);
    }
  return 1;
  }


// Item opened
long FXDirList::onItemExpanded(FXObject* sender,FXSelector sel,void* ptr){
  FXDirItem *item=(FXDirItem*)ptr;
  FXchar path[MAXPATHLEN];
  FXbool changed;
  if(!(item->state&FXDirItem::FOLDER)) return 0;

  // Expand tree item
  FXTreeList::onItemExpanded(sender,sel,ptr);
  
  // Get path to item
  getpath(item,path);
  
  FXTRACE((100,"%s::onItemExpanded: %s path=%s\n",getClassName(),item->label.text(),path));
  
  // List stuff in item directory
  changed=listSubDir(item,path);
  
  // Now we know for sure whether we really have subitems or not
  if(!item->first) item->state&=~FXDirItem::HASITEMS; else item->state|=FXDirItem::HASITEMS;
  //////// Missing update here somewhere...
  
  // Sort items
  if(changed){
    sortChildItems(item);
    }
  return 1;
  }


// Item closed
long FXDirList::onItemCollapsed(FXObject* sender,FXSelector sel,void* ptr){
  FXDirItem *item=(FXDirItem*)ptr;
  if(!(item->state&FXDirItem::FOLDER)) return 0;

  FXTRACE((100,"%s::onItemCollapsed: %s\n",getClassName(),item->label.text()));
  
  // Collapse tree item
  FXTreeList::onItemCollapsed(sender,sel,ptr);
  
  // As a memory saving feature, all knowledge below this item
  // is deleted; we'll just recreate it when its reexpanded!
  //removeItems(item->first,item->last);
  //recalc();
  return 1;
  }


// Refresh
long FXDirList::onRefresh(FXObject*,FXSelector,void*){
  FXbool changed;
  FXTRACE((400,"%s::onRefresh\n",getClassName()));
  changed=scanRootDir(FALSE);
  if(changed) recalc();
  refresh=getApp()->addTimeout(REFRESHINTERVAL,this,ID_REFRESH);
  counter=(counter+1)%REFRESHFREQUENCY;
  return 0;///// Should return 1 if there are changes
  }


// List root directories
FXbool FXDirList::listRoots(){
  if(firstitem) return FALSE;
#ifndef WIN32
  addItemLast(NULL,createItem("/",harddiskicon,harddiskicon,NULL));
#else
  DWORD drivemask=GetLogicalDrives();
  TCHAR drivename[10];
  drivename[1]=TEXT(':');
  drivename[2]=TEXT('\\');
  drivename[3]=0;
  for(drivename[0]=TEXT('a'); drivename[0]<=TEXT('z'); drivename[0]++){
    if(drivemask&1){
      UINT drivetype=GetDriveType(drivename);
      switch(drivetype){
        case DRIVE_REMOVABLE:
          if(drivename[0]==TEXT('a') || drivename[0]==TEXT('b')){
            addItemLast(NULL,createItem(drivename,floppyicon,floppyicon,NULL));
            }
          else{
            addItemLast(NULL,createItem(drivename,zipdiskicon,zipdiskicon,NULL));
            }
          break;
        case DRIVE_FIXED:
          addItemLast(NULL,createItem(drivename,harddiskicon,harddiskicon,NULL));
          break;
        case DRIVE_REMOTE:
          addItemLast(NULL,createItem(drivename,networkicon,networkicon,NULL));
          break;
        case DRIVE_CDROM:
          addItemLast(NULL,createItem(drivename,cdromicon,cdromicon,NULL));
          break;
        case DRIVE_RAMDISK:
          addItemLast(NULL,createItem(drivename,open_folder,closed_folder,NULL));
          break;
        case DRIVE_UNKNOWN:
        case DRIVE_NO_ROOT_DIR:
        default:
          break;
        }
      }
    drivemask>>=1;
    }
#endif
  return TRUE;
  }
  

// Scan root directory for changes
FXbool FXDirList::scanRootDir(FXbool relist){
  FXbool changed=FALSE;
  FXchar pathname[MAXPATHLEN];
  FXDirItem *item;
  long filetime;
#ifndef WIN32
  struct stat info;
#else
  HANDLE hFile;
  FILETIME ftLastWriteTime;
  FXdouble tmp;
#endif
  
  // Root directory name
  pathname[0]=PATHSEP;
  pathname[1]='\0';
  
  // Create root item if we don't have one yet
  if(!firstitem){
    item=(FXDirItem*)createItem(pathname,harddiskicon,harddiskicon,NULL);
    item->parent=NULL;
    item->next=NULL;
    item->prev=NULL;
    item->inext=NULL;
    item->iprev=NULL;
    item->list=NULL;
    item->date=0;
    item->state=FXDirItem::FOLDER|FXDirItem::HASITEMS;
    item->first=NULL;
    item->last=NULL;
    firstitem=lastitem=item;
    changed=TRUE;
    }
  
  item=(FXDirItem*)firstitem;

  // Item is directory; check regardless of children
  if((item->state&FXDirItem::FOLDER) && (item->state&FXDirItem::EXPANDED)){
    
#ifndef WIN32
    
    // Refresh subitems of root if necessary
    if(stat(pathname,&info)==0){
      filetime=FXMAX(info.st_mtime,info.st_ctime);
      if(relist || (item->date!=filetime) || ((filetime==0) && (counter==0))){
        if(listSubDir(item,pathname)){
          sortChildItems(item);
          changed=TRUE;
          }
        }
      item->date=filetime;
      }

#else
    
    // Refresh subitems of root if necessary
    hFile=CreateFile(pathname,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_FLAG_BACKUP_SEMANTICS,NULL);
    if(hFile!=INVALID_HANDLE_VALUE){
      if(GetFileTime(hFile,NULL,NULL,&ftLastWriteTime)){

        // FIX ME:- a year is a bit more than 365*24*3600=31536000 seconds

        // Convert to seconds since Jan 1, 1601
        tmp=(FXdouble)ftLastWriteTime.dwLowDateTime*1.0E-7 + (FXdouble)ftLastWriteTime.dwHighDateTime*429.4967296;
        
        // Subtract #seconds between Jan 1, 1601 and Jan 1, 1970
        tmp = tmp-11636784000.0;

        // Convert to long
        filetime=(long)tmp;

        if(relist || (item->date!=filetime) || (filetime==0) && (counter==0)){
          if(listSubDir(item,pathname)){
            sortChildItems(item);
            changed=TRUE;
            }
          }
        item->date=filetime;
        }
      CloseHandle(hFile);
      }

#endif
    
    // Then check subdirectories
    changed|=scanSubDir(item,pathname,relist);
    }
  return changed;
  }


// Scan sub directories
FXbool FXDirList::scanSubDir(FXDirItem *par,FXchar *pathname,FXbool relist){
  FXbool changed=FALSE;
  FXchar *pathtail,*pathend;
  FXDirItem *item;
  long filetime;
#ifndef WIN32
  struct stat info;
#else
  HANDLE hFile;
  FILETIME ftLastWriteTime;
  FXdouble tmp;
#endif

  if(par->first){
    
    // Build path prefix
    pathend=pathtail=pathname+strlen(pathname);
    if(*(pathtail-1)!=PATHSEP) *pathtail++=PATHSEP;
    
    // Loop over contents
    for(item=(FXDirItem*)par->first; item; item=(FXDirItem*)item->next){
      
      // Item is directory; check regardless of children
      if((item->state&FXDirItem::FOLDER) && (item->state&FXDirItem::EXPANDED)){
        
        // Sub item path
        strcpy(pathtail,item->label.text());
        
#ifndef WIN32
        
        // Refresh subitems of item if necessary
        if(stat(pathname,&info)==0){
          filetime=FXMAX(info.st_mtime,info.st_ctime);
          if(relist || (item->date!=filetime) || ((filetime==0) && (counter==0))){
            if(listSubDir(item,pathname)){
              sortChildItems(item);
              changed=TRUE;
              }
            }
          item->date=filetime;
          }
        
#else
        
        // Refresh subitems of item if necessary
        hFile=CreateFile(pathname,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_FLAG_BACKUP_SEMANTICS,NULL);
        if(hFile!=INVALID_HANDLE_VALUE){
          if(GetFileTime(hFile,NULL,NULL,&ftLastWriteTime)){
            
            // FIX ME:- a year is a bit more than 365*24*3600=31536000 seconds

            // Convert to seconds since Jan 1, 1601
            tmp=(FXdouble)ftLastWriteTime.dwLowDateTime*1.0E-7 + (FXdouble)ftLastWriteTime.dwHighDateTime*429.4967296;

            // Subtract #seconds between Jan 1, 1601 and Jan 1, 1970
            tmp = tmp-11636784000.0;

            // Convert to long
            filetime=(long)tmp;
            
            if(relist || (item->date!=filetime) || ((filetime==0) && (counter==0))){
              if(listSubDir(item,pathname)){
                sortChildItems(item);
                changed=TRUE;
                }
              }
            item->date=filetime;
            }
          CloseHandle(hFile);
          }
        
#endif
        
        // Then check subdirectories
        changed|=scanSubDir(item,pathname,relist);
        }
      }
    *pathend='\0';
    }
  return changed;
  }




// List subdirectories
FXbool FXDirList::listSubDir(FXDirItem *par,FXchar *pathname){
  FXDirItem *after,*before,*newlist,*item,*it;
  FXIcon *openicon,*closedicon;
  FXchar *pathtail,*pathend,*name,*ext;
  FXbool changed=FALSE;
  FXFileAssoc *fileassoc;
  long filetime;
#ifndef WIN32
  struct dirent *dp;
  struct stat info;
  DIR *dirp;
  int islink;
#else
  WIN32_FIND_DATA ffData;
  HANDLE hFindFile;
  DWORD dwBinaryType;
  FXdouble tmp;
#endif
  
  // Find end of original pathname
  pathend=pathtail=pathname+strlen(pathname);
  
  // Build new insert-order list
  after=NULL;
  before=par->list;
  newlist=NULL;
  if(!par->first) before=NULL;

#ifndef WIN32

  // Get directory stream pointer
  dirp=opendir(pathname);

  // Managed to open directory
  if(dirp){

    // Insert a '/' if needed
    if(*(pathtail-1)!=PATHSEP) *pathtail++=PATHSEP;

    // Process directory entries
    while((dp=readdir(dirp))!=NULL){
      name=dp->d_name;

      // A dot special file?
      if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

      // Hidden file or directory normally not shown
      if(name[0]=='.' && !(options&DIRLIST_SHOWHIDDEN)) continue;

      // Build full pathname
      strcpy(pathtail,name);

      // Get File info
      if(lstat(pathname,&info)!=0) continue;

      // If its a link, get the file info
      islink=S_ISLNK(info.st_mode);
      if(islink && stat(pathname,&info)!=0) continue;

      // If it is not a directory, and not showing files and matching pattern skip it
      if(!S_ISDIR(info.st_mode) && !((options&DIRLIST_SHOWFILES) && fxfilematch(pattern.text(),name,matchmode))) continue;

      // File change/mod time
      filetime=FXMAX(info.st_mtime,info.st_ctime);
#else

  // Insert a '\' if needed
  if(*(pathtail-1)!=PATHSEP) *pathtail++=PATHSEP;
  
  // Get file find handle and first file's info
  strcpy(pathtail,"*");
  hFindFile=FindFirstFile(pathname,&ffData);

  // Found first file?
  if(hFindFile!=INVALID_HANDLE_VALUE){

    // Loop over directory entries
    do{
      name=ffData.cFileName;

      // A dot special file?
      if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

      // Hidden file or directory normally not shown
      if((ffData.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN || name[0]=='.') && !(options&DIRLIST_SHOWHIDDEN)) continue;

      // If it is not a directory, and not showing files and matching pattern skip it
      if(!(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) && !((options&DIRLIST_SHOWFILES) && fxfilematch(pattern.text(),name,matchmode))) continue;

      // Build full pathname
      strcpy(pathtail,name);

      // FIX ME:- a year is a bit more than 365*24*3600=31536000 seconds

      // Convert to seconds since Jan 1, 1601
      tmp=(FXdouble)ffData.ftLastWriteTime.dwLowDateTime*1.0E-7 + (FXdouble)ffData.ftLastWriteTime.dwHighDateTime*429.4967296;
        
      // Subtract #seconds between Jan 1, 1601 and Jan 1, 1970
      tmp = tmp-11636784000.0;

      // Convert to long
      filetime=(long)tmp;

#endif
    
      // Find it
      for(item=before; item; item=item->inext){
        if(strcmp(item->label.text(),name)==0){
          while(before!=item){
            it=before;
            before=before->inext;
            if(it->prev) it->prev->next=it->next; else it->parent->first=it->next;
            if(it->next) it->next->prev=it->prev; else it->parent->last=it->prev;
            if(currentitem==it) currentitem=NULL;
            if(anchoritem==it) anchoritem=NULL;
            if(extentitem==it) extentitem=NULL;
            removeItems(it->first,it->last);
            changed=TRUE;
            delete it;
            }
          before=item->inext;
          if(before) before->iprev=NULL;
          item->inext=NULL;
          item->iprev=NULL;
          goto fnd;
          }
        }

      // Not found; prepend before list
      item=(FXDirItem*)createItem(name,open_folder,closed_folder,NULL);
      item->prev=par->last;
      item->next=NULL;
      item->parent=par;
      item->first=NULL;
      item->last=NULL;
      item->label=name;
      item->iprev=NULL;
      item->inext=NULL;
      item->list=NULL;
      item->state=FXDirItem::HASITEMS;
      item->date=0;
      if(item->prev) item->prev->next=item; else par->first=item;
      par->last=item;
      changed=TRUE;

      // Next gets hung after this one
fnd:  item->iprev=after;
      if(after) after->inext=item; else newlist=item;

      // Fill item with updated information, if data has changed
 
#ifndef WIN32
    
      // Anything about the file changed?
      if((item->date!=filetime) || (filetime==0)){

        // Item flags
        if(info.st_mode&(S_IXUSR|S_IXGRP|S_IXOTH)) item->state|=FXDirItem::EXECUTABLE; else item->state&=~FXDirItem::EXECUTABLE;
        if(S_ISDIR(info.st_mode)) item->state|=FXDirItem::FOLDER; else item->state&=~(FXDirItem::FOLDER|FXDirItem::HASITEMS);
        if(S_ISLNK(info.st_mode)) item->state|=FXDirItem::SYMLINK; else item->state&=~FXDirItem::SYMLINK;
        if(S_ISCHR(info.st_mode)) item->state|=FXDirItem::CHARDEV; else item->state&=~FXDirItem::CHARDEV;
        if(S_ISBLK(info.st_mode)) item->state|=FXDirItem::BLOCKDEV; else item->state&=~FXDirItem::BLOCKDEV;
        if(S_ISFIFO(info.st_mode)) item->state|=FXDirItem::FIFO; else item->state&=~FXDirItem::FIFO;
        if(S_ISSOCK(info.st_mode)) item->state|=FXDirItem::SOCK; else item->state&=~FXDirItem::SOCK;

        // Is it a directory?
        if(item->state&FXDirItem::FOLDER){
          openicon=open_folder;
          closedicon=closed_folder;
          if(par->parent && par->parent->parent==NULL){
            if(par->label=="hosts" || par->label=="net"){
              openicon=networkicon;
              closedicon=networkicon;
              }
            else if(par->label=="mnt"){
              if(item->label=="cdrom"){
                openicon=cdromicon;
                closedicon=cdromicon;
                }
              else if(item->label=="zip"){
                openicon=zipdiskicon;
                closedicon=zipdiskicon;
                }
              else if(item->label=="floppy"){
                openicon=floppyicon;
                closedicon=floppyicon;
                }
              }
            }
          }

        // Document
        else{

          // Is it an executable?
          if(item->state&FXDirItem::EXECUTABLE){
            openicon=mini_app;
            closedicon=mini_app;
            }
          else{
            openicon=mini_doc;
            closedicon=mini_doc;
            }

          // Try use association table
          if(associations){

            // Try find association for this file, starting with the 
            // whole filename, then successively smaller extensions.
            fileassoc=associations->associate(name);
            if(!fileassoc){
              ext=strchr(name,'.');
              while(ext){
                fileassoc=associations->associate(ext+1);
                if(fileassoc) break;
                ext=strchr(ext+1,'.');
                }
              }

            // If we have an association, grab the icon
            if(fileassoc){
              if(fileassoc->miniicon){ openicon=closedicon=fileassoc->miniicon; }
              }
            }
          }

        // Update item information
        item->openIcon=openicon;
        item->closedIcon=closedicon;
        item->size=info.st_size;
        item->assoc=fileassoc;
        item->date=filetime;
        
        // Create item
        if(id()) item->create();

        // Info has changed
        changed=TRUE;
        }

#else

      // Anything about the file changed?
      if((item->date!=filetime) || (filetime==0)){

        // Item flags
        if(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) item->state|=FXDirItem::FOLDER; else item->state&=~(FXDirItem::FOLDER|FXDirItem::HASITEMS);
        if(!GetBinaryType(pathname,&dwBinaryType)) item->state&=~FXDirItem::EXECUTABLE; else item->state|=FXDirItem::EXECUTABLE;

        // Is it a directory?
        if(item->state&FXDirItem::FOLDER){
          openicon=open_folder;
          closedicon=closed_folder;
          }

        // Document
        else{

          // Is it an executable?
          if(item->state&FXDirItem::EXECUTABLE){
            openicon=mini_app;
            closedicon=mini_app;
            }
          else{
            openicon=mini_doc;
            closedicon=mini_doc;
            }

          // Try use association table
          if(associations){

            // Use whole filename; this is damn convenient!!
            fileassoc=associations->associate(name);
            if(!fileassoc){
              ext=strchr(name,'.');
              if(ext){
                fileassoc=associations->associate(ext+1);
                }
              }

            // If we have an association, grab the icon
            if(fileassoc){
              if(fileassoc->miniicon){ openicon=closedicon=fileassoc->miniicon; }
              }
            }
          }

        // Update item information
        item->openIcon=openicon;
        item->closedIcon=closedicon;
        item->size=ffData.nFileSizeLow;
        item->assoc=fileassoc;
        item->date=filetime;

        // Create item
        if(id()) item->create();

        // Info has changed
        changed=TRUE;
        }

#endif

      // Next one goes after item
      after=item;
      }
#ifdef WIN32
    while(FindNextFile(hFindFile,&ffData));
#endif
    
  // Close it
#ifndef WIN32
    closedir(dirp);
#else
    FindClose(hFindFile);
#endif
    }

  // Wipe items remaining in list:- they have disappeared!!
  while(before){
    it=before;
    before=before->inext;
    if(it->prev) it->prev->next=it->next; else it->parent->first=it->next;
    if(it->next) it->next->prev=it->prev; else it->parent->last=it->prev;
    if(currentitem==it) currentitem=NULL;
    if(anchoritem==it) anchoritem=NULL;
    if(extentitem==it) extentitem=NULL;
    removeItems(it->first,it->last);
    changed=TRUE;
    delete it;
    }

  // Remember new list
  par->list=newlist;

  // Restore original path
  *pathend='\0';
  return changed;
  }


// Is directory
FXbool FXDirList::isItemDirectory(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemDirectory: item is NULL.\n",getClassName()); }
  return (item->state&FXDirItem::FOLDER)!=0;
  }


// Is file
FXbool FXDirList::isItemFile(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemFile: item is NULL.\n",getClassName()); }
  return (item->state&(FXDirItem::FOLDER|FXDirItem::CHARDEV|FXDirItem::BLOCKDEV|FXDirItem::FIFO|FXDirItem::SOCK))==0;
  }


// Is executable
FXbool FXDirList::isItemExecutable(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemExecutable: item is NULL.\n",getClassName()); }
  return (item->state&FXDirItem::EXECUTABLE)!=0;
  }


// Obtain full pathname down from root
FXString FXDirList::getItemPathname(const FXTreeItem* item) const {
  FXchar path[MAXPATHLEN];
  if(item==NULL){ fxerror("%s::getItemPathname: item is NULL.\n",getClassName()); }
  getpath(item,path);
  return FXString(path);
  }


// Obtain item's file name only
FXString FXDirList::getItemFilename(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::getItemFilename: item is NULL.\n",getClassName()); }
  return item->label;
  }


// Open all intermediate directories down toward given one
void FXDirList::setDirectory(const FXString& path){
  FXchar abspath[MAXPATHLEN+1];
  FXTreeItem *item;
  if(path.empty()) return;
  fxabspath(abspath,NULL,path.text());
  while(!fxistopdir(abspath) && !fxisdir(abspath)){
    fxupdir(abspath,abspath);
    }
  FXTRACE((100,"setDirectory(%s)\n",abspath));
  item=getitem(abspath);
  if(item!=currentitem){
    makeItemVisible(item);
    if(currentitem) closeItem(currentitem);
    setCurrentItem(item);
    if(currentitem) openItem(currentitem);
    }
  }


// Return directory part of path to current item
FXString FXDirList::getDirectory() const {
  const FXTreeItem* item=currentitem;
  while(item){
    if(item->state&FXDirItem::FOLDER) return getItemPathname(item);
    item=item->parent;
    }
  return FXString(NULL);
  }


// Set current (dir/file) name path
void FXDirList::setCurrentFile(const FXString& file){
  FXchar abspath[MAXPATHLEN+1];
  FXTreeItem *item;
  if(file.empty()) return;
  fxabspath(abspath,NULL,file.text());
  while(!fxistopdir(abspath) && !fxexists(abspath)){
    fxupdir(abspath,abspath);
    }
  FXTRACE((100,"setCurrentFile(%s)\n",abspath));
  item=getitem(abspath);
  if(item!=currentitem){
    makeItemVisible(item);
    if(currentitem) closeItem(currentitem);
    setCurrentItem(item);
    if(currentitem) openItem(currentitem);
    }
  }


// Get current (dir/file) name path
FXString FXDirList::getCurrentFile() const {
  if(currentitem) return getItemPathname(currentitem);
  return FXString(NULL);
  }



// Get list style
FXbool FXDirList::showFiles() const { 
  return (options&DIRLIST_SHOWFILES)!=0; 
  }


// Change list style
void FXDirList::showFiles(FXbool showing){
  FXuint opts=options;
  if(showing) opts|=DIRLIST_SHOWFILES; else opts&=~DIRLIST_SHOWFILES;
  if(options!=opts){
    options=opts;
    scanRootDir(TRUE);
    }
  }


// Return TRUE if showing hidden files
FXbool FXDirList::showHiddenFiles() const {
  return (options&DIRLIST_SHOWHIDDEN)!=0;
  }


// Change show hidden files mode
void FXDirList::showHiddenFiles(FXbool showing){
  FXuint opts=options;
  if(showing) opts|=DIRLIST_SHOWHIDDEN; else opts&=~DIRLIST_SHOWHIDDEN;
  if(opts!=options){
    options=opts;
    scanRootDir(TRUE);
    }
  }


// Set associations
void FXDirList::setAssociations(FXFileDict* assoc){
  associations=assoc;
  }


// Set the pattern to filter
void FXDirList::setPattern(const FXString& ptrn){
  if(ptrn.empty()) return;
  if(pattern!=ptrn){
    pattern=ptrn;
    scanRootDir(TRUE);
    }
  }


// Change file match mode
void FXDirList::setMatchMode(FXuint mode){
  if(matchmode!=mode){
    matchmode=mode;
    scanRootDir(TRUE);
    }
  }


// Save data
void FXDirList::save(FXStream& store) const {
  FXTreeList::save(store);
  store << associations;
  store << pattern;
  store << matchmode;
  store << closed_folder;
  store << open_folder;
  store << mini_doc;
  store << mini_app;
  }


// Load data
void FXDirList::load(FXStream& store){ 
  FXTreeList::load(store);
  store >> associations; 
  store >> pattern;     
  store >> matchmode;   
  store >> closed_folder;
  store >> open_folder;  
  store >> mini_doc;     
  store >> mini_app;     
  }


// Cleanup
FXDirList::~FXDirList(){
  removeAllItems();
  if(refresh) getApp()->removeTimeout(refresh);
  delete associations;
  delete closed_folder;
  delete open_folder;
  delete mini_doc;
  delete mini_app;
  delete cdromicon;
  delete harddiskicon;
  delete networkicon;
  delete floppyicon;
  delete zipdiskicon;
  associations=(FXFileDict*)-1;
  closed_folder=(FXGIFIcon*)-1;
  open_folder=(FXGIFIcon*)-1;
  mini_doc=(FXGIFIcon*)-1;
  mini_app=(FXGIFIcon*)-1;
  cdromicon=(FXIcon*)-1;
  harddiskicon=(FXIcon*)-1;
  networkicon=(FXIcon*)-1;
  floppyicon=(FXIcon*)-1;
  zipdiskicon=(FXIcon*)-1;
  refresh=(FXTimer*)-1;
  }


