/********************************************************************************
*                                                                               *
*                      C o l o r   N a m e   F u n c t i o n s                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXColorNames.cpp,v 1.3 1999/10/13 04:28:16 jeroen Exp $                  *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "fxkeys.h"



// Massive color database
const FXNamedColor fxcolornames[]={ 
  {"AliceBlue",            240,248,255},
  {"AntiqueWhite",         250,235,215},
  {"AntiqueWhite1",        255,239,219},
  {"AntiqueWhite2",        238,223,204},
  {"AntiqueWhite3",        205,192,176},
  {"AntiqueWhite4",        139,131,120},
  {"Aquamarine",           127,255,212},
  {"Aquamarine1",          127,255,212},
  {"Aquamarine2",          118,238,198},
  {"Aquamarine3",          102,205,170},
  {"Aquamarine4",           69,139,116},
  {"Azure",                240,255,255},
  {"Azure1",               240,255,255},
  {"Azure2",               224,238,238},
  {"Azure3",               193,205,205},
  {"Azure4",               131,139,139},
  {"Beige",                245,245,220},
  {"Bisque",               255,228,196},
  {"Bisque1",              255,228,196},
  {"Bisque2",              238,213,183},
  {"Bisque3",              205,183,158},
  {"Bisque4",              139,125,107},
  {"Black",                  0,  0,  0},
  {"BlanchedAlmond",       255,235,205},
  {"Blue",                   0,  0,255},
  {"Blue1",                  0,  0,255},
  {"Blue2",                  0,  0,238},
  {"Blue3",                  0,  0,205},
  {"Blue4",                  0,  0,139},
  {"BlueViolet",           138, 43,226},
  {"Brown",                165, 42, 42},
  {"Brown1",               255, 64, 64},
  {"Brown2",               238, 59, 59},
  {"Brown3",               205, 51, 51},
  {"Brown4",               139, 35, 35},
  {"Burlywood",            222,184,135},
  {"Burlywood1",           255,211,155},
  {"Burlywood2",           238,197,145},
  {"Burlywood3",           205,170,125},
  {"Burlywood4",           139,115, 85},
  {"CadetBlue",             95,158,160},
  {"CadetBlue1",           152,245,255},
  {"CadetBlue2",           142,229,238},
  {"CadetBlue3",           122,197,205},
  {"CadetBlue4",            83,134,139},
  {"Chartreuse",           127,255,  0},
  {"Chartreuse1",          127,255,  0},
  {"Chartreuse2",          118,238,  0},
  {"Chartreuse3",          102,205,  0},
  {"Chartreuse4",           69,139,  0},
  {"Chocolate",            210,105, 30},
  {"Chocolate1",           255,127, 36},
  {"Chocolate2",           238,118, 33},
  {"Chocolate3",           205,102, 29},
  {"Chocolate4",           139, 69, 19},
  {"Coral",                255,127, 80},
  {"Coral1",               255,114, 86},
  {"Coral2",               238,106, 80},
  {"Coral3",               205, 91, 69},
  {"Coral4",               139, 62, 47},
  {"CornflowerBlue",       100,149,237},
  {"Cornsilk",             255,248,220},
  {"Cornsilk1",            255,248,220},
  {"Cornsilk2",            238,232,205},
  {"Cornsilk3",            205,200,177},
  {"Cornsilk4",            139,136,120},
  {"Cyan",                   0,255,255},
  {"Cyan1",                  0,255,255},
  {"Cyan2",                  0,238,238},
  {"Cyan3",                  0,205,205},
  {"Cyan4",                  0,139,139},
  {"DarkBlue",               0,  0,139},
  {"DarkCyan",               0,139,139},
  {"DarkGoldenrod",        184,134, 11},
  {"DarkGoldenrod1",       255,185, 15},
  {"DarkGoldenrod2",       238,173, 14},
  {"DarkGoldenrod3",       205,149, 12},
  {"DarkGoldenrod4",       139,101,  8},
  {"DarkGray",             169,169,169},
  {"DarkGreen",              0,100,  0},
  {"DarkGrey",             169,169,169},
  {"DarkKhaki",            189,183,107},
  {"DarkMagenta",          139,  0,139},
  {"DarkOliveGreen",        85,107, 47},
  {"DarkOliveGreen1",      202,255,112},
  {"DarkOliveGreen2",      188,238,104},
  {"DarkOliveGreen3",      162,205, 90},
  {"DarkOliveGreen4",      110,139, 61},
  {"DarkOrange",           255,140,  0},
  {"DarkOrange1",          255,127,  0},
  {"DarkOrange2",          238,118,  0},
  {"DarkOrange3",          205,102,  0},
  {"DarkOrange4",          139, 69,  0},
  {"DarkOrchid",           153, 50,204},
  {"DarkOrchid1",          191, 62,255},
  {"DarkOrchid2",          178, 58,238},
  {"DarkOrchid3",          154, 50,205},
  {"DarkOrchid4",          104, 34,139},
  {"DarkRed",              139,  0,  0},
  {"DarkSalmon",           233,150,122},
  {"DarkSeaGreen",         143,188,143},
  {"DarkSeaGreen1",        193,255,193},
  {"DarkSeaGreen2",        180,238,180},
  {"DarkSeaGreen3",        155,205,155},
  {"DarkSeaGreen4",        105,139,105},
  {"DarkSlateBlue",         72, 61,139},
  {"DarkSlateGray",         47, 79, 79},
  {"DarkSlateGray1",       151,255,255},
  {"DarkSlateGray2",       141,238,238},
  {"DarkSlateGray3",       121,205,205},
  {"DarkSlateGray4",        82,139,139},
  {"DarkSlateGrey",         47, 79, 79},
  {"DarkTurquoise",          0,206,209},
  {"DarkViolet",           148,  0,211},
  {"DeepPink",             255, 20,147},
  {"DeepPink1",            255, 20,147},
  {"DeepPink2",            238, 18,137},
  {"DeepPink3",            205, 16,118},
  {"DeepPink4",            139, 10, 80},
  {"DeepSkyBlue",            0,191,255},
  {"DeepSkyBlue1",           0,191,255},
  {"DeepSkyBlue2",           0,178,238},
  {"DeepSkyBlue3",           0,154,205},
  {"DeepSkyBlue4",           0,104,139},
  {"DimGray",              105,105,105},
  {"DimGrey",              105,105,105},
  {"DodgerBlue",            30,144,255},
  {"DodgerBlue1",           30,144,255},
  {"DodgerBlue2",           28,134,238},
  {"DodgerBlue3",           24,116,205},
  {"DodgerBlue4",           16, 78,139},
  {"Firebrick",            178, 34, 34},
  {"Firebrick1",           255, 48, 48},
  {"Firebrick2",           238, 44, 44},
  {"Firebrick3",           205, 38, 38},
  {"Firebrick4",           139, 26, 26},
  {"FloralWhite",          255,250,240},
  {"ForestGreen",           34,139, 34},
  {"Gainsboro",            220,220,220},
  {"GhostWhite",           248,248,255},
  {"Gold",                 255,215,  0},
  {"Gold1",                255,215,  0},
  {"Gold2",                238,201,  0},
  {"Gold3",                205,173,  0},
  {"Gold4",                139,117,  0},
  {"Goldenrod",            218,165, 32},
  {"Goldenrod1",           255,193, 37},
  {"Goldenrod2",           238,180, 34},
  {"Goldenrod3",           205,155, 29},
  {"Goldenrod4",           139,105, 20},
  {"Gray",                 190,190,190},
  {"Gray0",                  0,  0,  0},
  {"Gray1",                  3,  3,  3},
  {"Gray10",                26, 26, 26},
  {"Gray100",              255,255,255},
  {"Gray11",                28, 28, 28},
  {"Gray12",                31, 31, 31},
  {"Gray13",                33, 33, 33},
  {"Gray14",                36, 36, 36},
  {"Gray15",                38, 38, 38},
  {"Gray16",                41, 41, 41},
  {"Gray17",                43, 43, 43},
  {"Gray18",                46, 46, 46},
  {"Gray19",                48, 48, 48},
  {"Gray2",                  5,  5,  5},
  {"Gray20",                51, 51, 51},
  {"Gray21",                54, 54, 54},
  {"Gray22",                56, 56, 56},
  {"Gray23",                59, 59, 59},
  {"Gray24",                61, 61, 61},
  {"Gray25",                64, 64, 64},
  {"Gray26",                66, 66, 66},
  {"Gray27",                69, 69, 69},
  {"Gray28",                71, 71, 71},
  {"Gray29",                74, 74, 74},
  {"Gray3",                  8,  8,  8},
  {"Gray30",                77, 77, 77},
  {"Gray31",                79, 79, 79},
  {"Gray32",                82, 82, 82},
  {"Gray33",                84, 84, 84},
  {"Gray34",                87, 87, 87},
  {"Gray35",                89, 89, 89},
  {"Gray36",                92, 92, 92},
  {"Gray37",                94, 94, 94},
  {"Gray38",                97, 97, 97},
  {"Gray39",                99, 99, 99},
  {"Gray4",                 10, 10, 10},
  {"Gray40",               102,102,102},
  {"Gray41",               105,105,105},
  {"Gray42",               107,107,107},
  {"Gray43",               110,110,110},
  {"Gray44",               112,112,112},
  {"Gray45",               115,115,115},
  {"Gray46",               117,117,117},
  {"Gray47",               120,120,120},
  {"Gray48",               122,122,122},
  {"Gray49",               125,125,125},
  {"Gray5",                 13, 13, 13},
  {"Gray50",               127,127,127},
  {"Gray51",               130,130,130},
  {"Gray52",               133,133,133},
  {"Gray53",               135,135,135},
  {"Gray54",               138,138,138},
  {"Gray55",               140,140,140},
  {"Gray56",               143,143,143},
  {"Gray57",               145,145,145},
  {"Gray58",               148,148,148},
  {"Gray59",               150,150,150},
  {"Gray6",                 15, 15, 15},
  {"Gray60",               153,153,153},
  {"Gray61",               156,156,156},
  {"Gray62",               158,158,158},
  {"Gray63",               161,161,161},
  {"Gray64",               163,163,163},
  {"Gray65",               166,166,166},
  {"Gray66",               168,168,168},
  {"Gray67",               171,171,171},
  {"Gray68",               173,173,173},
  {"Gray69",               176,176,176},
  {"Gray7",                 18, 18, 18},
  {"Gray70",               179,179,179},
  {"Gray71",               181,181,181},
  {"Gray72",               184,184,184},
  {"Gray73",               186,186,186},
  {"Gray74",               189,189,189},
  {"Gray75",               191,191,191},
  {"Gray76",               194,194,194},
  {"Gray77",               196,196,196},
  {"Gray78",               199,199,199},
  {"Gray79",               201,201,201},
  {"Gray8",                 20, 20, 20},
  {"Gray80",               204,204,204},
  {"Gray81",               207,207,207},
  {"Gray82",               209,209,209},
  {"Gray83",               212,212,212},
  {"Gray84",               214,214,214},
  {"Gray85",               217,217,217},
  {"Gray86",               219,219,219},
  {"Gray87",               222,222,222},
  {"Gray88",               224,224,224},
  {"Gray89",               227,227,227},
  {"Gray9",                 23, 23, 23},
  {"Gray90",               229,229,229},
  {"Gray91",               232,232,232},
  {"Gray92",               235,235,235},
  {"Gray93",               237,237,237},
  {"Gray94",               240,240,240},
  {"Gray95",               242,242,242},
  {"Gray96",               245,245,245},
  {"Gray97",               247,247,247},
  {"Gray98",               250,250,250},
  {"Gray99",               252,252,252},
  {"Green",                  0,255,  0},
  {"Green1",                 0,255,  0},
  {"Green2",                 0,238,  0},
  {"Green3",                 0,205,  0},
  {"Green4",                 0,139,  0},
  {"GreenYellow",          173,255, 47},
  {"Grey",                 190,190,190},
  {"Grey0",                  0,  0,  0},
  {"Grey1",                  3,  3,  3},
  {"Grey10",                26, 26, 26},
  {"Grey100",              255,255,255},
  {"Grey11",                28, 28, 28},
  {"Grey12",                31, 31, 31},
  {"Grey13",                33, 33, 33},
  {"Grey14",                36, 36, 36},
  {"Grey15",                38, 38, 38},
  {"Grey16",                41, 41, 41},
  {"Grey17",                43, 43, 43},
  {"Grey18",                46, 46, 46},
  {"Grey19",                48, 48, 48},
  {"Grey2",                  5,  5,  5},
  {"Grey20",                51, 51, 51},
  {"Grey21",                54, 54, 54},
  {"Grey22",                56, 56, 56},
  {"Grey23",                59, 59, 59},
  {"Grey24",                61, 61, 61},
  {"Grey25",                64, 64, 64},
  {"Grey26",                66, 66, 66},
  {"Grey27",                69, 69, 69},
  {"Grey28",                71, 71, 71},
  {"Grey29",                74, 74, 74},
  {"Grey3",                  8,  8,  8},
  {"Grey30",                77, 77, 77},
  {"Grey31",                79, 79, 79},
  {"Grey32",                82, 82, 82},
  {"Grey33",                84, 84, 84},
  {"Grey34",                87, 87, 87},
  {"Grey35",                89, 89, 89},
  {"Grey36",                92, 92, 92},
  {"Grey37",                94, 94, 94},
  {"Grey38",                97, 97, 97},
  {"Grey39",                99, 99, 99},
  {"Grey4",                 10, 10, 10},
  {"Grey40",               102,102,102},
  {"Grey41",               105,105,105},
  {"Grey42",               107,107,107},
  {"Grey43",               110,110,110},
  {"Grey44",               112,112,112},
  {"Grey45",               115,115,115},
  {"Grey46",               117,117,117},
  {"Grey47",               120,120,120},
  {"Grey48",               122,122,122},
  {"Grey49",               125,125,125},
  {"Grey5",                 13, 13, 13},
  {"Grey50",               127,127,127},
  {"Grey51",               130,130,130},
  {"Grey52",               133,133,133},
  {"Grey53",               135,135,135},
  {"Grey54",               138,138,138},
  {"Grey55",               140,140,140},
  {"Grey56",               143,143,143},
  {"Grey57",               145,145,145},
  {"Grey58",               148,148,148},
  {"Grey59",               150,150,150},
  {"Grey6",                 15, 15, 15},
  {"Grey60",               153,153,153},
  {"Grey61",               156,156,156},
  {"Grey62",               158,158,158},
  {"Grey63",               161,161,161},
  {"Grey64",               163,163,163},
  {"Grey65",               166,166,166},
  {"Grey66",               168,168,168},
  {"Grey67",               171,171,171},
  {"Grey68",               173,173,173},
  {"Grey69",               176,176,176},
  {"Grey7",                 18, 18, 18},
  {"Grey70",               179,179,179},
  {"Grey71",               181,181,181},
  {"Grey72",               184,184,184},
  {"Grey73",               186,186,186},
  {"Grey74",               189,189,189},
  {"Grey75",               191,191,191},
  {"Grey76",               194,194,194},
  {"Grey77",               196,196,196},
  {"Grey78",               199,199,199},
  {"Grey79",               201,201,201},
  {"Grey8",                 20, 20, 20},
  {"Grey80",               204,204,204},
  {"Grey81",               207,207,207},
  {"Grey82",               209,209,209},
  {"Grey83",               212,212,212},
  {"Grey84",               214,214,214},
  {"Grey85",               217,217,217},
  {"Grey86",               219,219,219},
  {"Grey87",               222,222,222},
  {"Grey88",               224,224,224},
  {"Grey89",               227,227,227},
  {"Grey9",                 23, 23, 23},
  {"Grey90",               229,229,229},
  {"Grey91",               232,232,232},
  {"Grey92",               235,235,235},
  {"Grey93",               237,237,237},
  {"Grey94",               240,240,240},
  {"Grey95",               242,242,242},
  {"Grey96",               245,245,245},
  {"Grey97",               247,247,247},
  {"Grey98",               250,250,250},
  {"Grey99",               252,252,252},
  {"Honeydew",             240,255,240},
  {"Honeydew1",            240,255,240},
  {"Honeydew2",            224,238,224},
  {"Honeydew3",            193,205,193},
  {"Honeydew4",            131,139,131},
  {"HotPink",              255,105,180},
  {"HotPink1",             255,110,180},
  {"HotPink2",             238,106,167},
  {"HotPink3",             205, 96,144},
  {"HotPink4",             139, 58, 98},
  {"IndianRed",            205, 92, 92},
  {"IndianRed1",           255,106,106},
  {"IndianRed2",           238, 99, 99},
  {"IndianRed3",           205, 85, 85},
  {"IndianRed4",           139, 58, 58},
  {"Ivory",                255,255,240},
  {"Ivory1",               255,255,240},
  {"Ivory2",               238,238,224},
  {"Ivory3",               205,205,193},
  {"Ivory4",               139,139,131},
  {"Khaki",                240,230,140},
  {"Khaki1",               255,246,143},
  {"Khaki2",               238,230,133},
  {"Khaki3",               205,198,115},
  {"Khaki4",               139,134, 78},
  {"Lavender",             230,230,250},
  {"LavenderBlush",        255,240,245},
  {"LavenderBlush1",       255,240,245},
  {"LavenderBlush2",       238,224,229},
  {"LavenderBlush3",       205,193,197},
  {"LavenderBlush4",       139,131,134},
  {"LawnGreen",            124,252,  0},
  {"LemonChiffon",         255,250,205},
  {"LemonChiffon1",        255,250,205},
  {"LemonChiffon2",        238,233,191},
  {"LemonChiffon3",        205,201,165},
  {"LemonChiffon4",        139,137,112},
  {"LightBlue",            173,216,230},
  {"LightBlue1",           191,239,255},
  {"LightBlue2",           178,223,238},
  {"LightBlue3",           154,192,205},
  {"LightBlue4",           104,131,139},
  {"LightCoral",           240,128,128},
  {"LightCyan",            224,255,255},
  {"LightCyan1",           224,255,255},
  {"LightCyan2",           209,238,238},
  {"LightCyan3",           180,205,205},
  {"LightCyan4",           122,139,139},
  {"LightGoldenrod",       238,221,130},
  {"LightGoldenrod1",      255,236,139},
  {"LightGoldenrod2",      238,220,130},
  {"LightGoldenrod3",      205,190,112},
  {"LightGoldenrod4",      139,129, 76},
  {"LightGoldenrodYellow", 250,250,210},
  {"LightGray",            211,211,211},
  {"LightGreen",           144,238,144},
  {"LightGrey",            211,211,211},
  {"LightPink",            255,182,193},
  {"LightPink1",           255,174,185},
  {"LightPink2",           238,162,173},
  {"LightPink3",           205,140,149},
  {"LightPink4",           139, 95,101},
  {"LightSalmon",          255,160,122},
  {"LightSalmon1",         255,160,122},
  {"LightSalmon2",         238,149,114},
  {"LightSalmon3",         205,129, 98},
  {"LightSalmon4",         139, 87, 66},
  {"LightSeaGreen",         32,178,170},
  {"LightSkyBlue",         135,206,250},
  {"LightSkyBlue1",        176,226,255},
  {"LightSkyBlue2",        164,211,238},
  {"LightSkyBlue3",        141,182,205},
  {"LightSkyBlue4",         96,123,139},
  {"LightSlateBlue",       132,112,255},
  {"LightSlateGray",       119,136,153},
  {"LightSlateGrey",       119,136,153},
  {"LightSteelBlue",       176,196,222},
  {"LightSteelBlue1",      202,225,255},
  {"LightSteelBlue2",      188,210,238},
  {"LightSteelBlue3",      162,181,205},
  {"LightSteelBlue4",      110,123,139},
  {"LightYellow",          255,255,224},
  {"LightYellow1",         255,255,224},
  {"LightYellow2",         238,238,209},
  {"LightYellow3",         205,205,180},
  {"LightYellow4",         139,139,122},
  {"LimeGreen",             50,205, 50},
  {"Linen",                250,240,230},
  {"Magenta",              255,  0,255},
  {"Magenta1",             255,  0,255},
  {"Magenta2",             238,  0,238},
  {"Magenta3",             205,  0,205},
  {"Magenta4",             139,  0,139},
  {"Maroon",               176, 48, 96},
  {"Maroon1",              255, 52,179},
  {"Maroon2",              238, 48,167},
  {"Maroon3",              205, 41,144},
  {"Maroon4",              139, 28, 98},
  {"MediumAquamarine",     102,205,170},
  {"MediumBlue",             0,  0,205},
  {"MediumOrchid",         186, 85,211},
  {"MediumOrchid1",        224,102,255},
  {"MediumOrchid2",        209, 95,238},
  {"MediumOrchid3",        180, 82,205},
  {"MediumOrchid4",        122, 55,139},
  {"MediumPurple",         147,112,219},
  {"MediumPurple1",        171,130,255},
  {"MediumPurple2",        159,121,238},
  {"MediumPurple3",        137,104,205},
  {"MediumPurple4",         93, 71,139},
  {"MediumSeaGreen",        60,179,113},
  {"MediumSlateBlue",      123,104,238},
  {"MediumSpringGreen",      0,250,154},
  {"MediumTurquoise",       72,209,204},
  {"MediumVioletRed",      199, 21,133},
  {"MidnightBlue",          25, 25,112},
  {"MintCream",            245,255,250},
  {"MistyRose",            255,228,225},
  {"MistyRose1",           255,228,225},
  {"MistyRose2",           238,213,210},
  {"MistyRose3",           205,183,181},
  {"MistyRose4",           139,125,123},
  {"Moccasin",             255,228,181},
  {"NavajoWhite",          255,222,173},
  {"NavajoWhite1",         255,222,173},
  {"NavajoWhite2",         238,207,161},
  {"NavajoWhite3",         205,179,139},
  {"NavajoWhite4",         139,121, 94},
  {"Navy",                   0,  0,128},
  {"NavyBlue",               0,  0,128},
  {"OldLace",              253,245,230},
  {"OliveDrab",            107,142, 35},
  {"OliveDrab1",           192,255, 62},
  {"OliveDrab2",           179,238, 58},
  {"OliveDrab3",           154,205, 50},
  {"OliveDrab4",           105,139, 34},
  {"Orange",               255,165,  0},
  {"Orange1",              255,165,  0},
  {"Orange2",              238,154,  0},
  {"Orange3",              205,133,  0},
  {"Orange4",              139, 90,  0},
  {"OrangeRed",            255, 69,  0},
  {"OrangeRed1",           255, 69,  0},
  {"OrangeRed2",           238, 64,  0},
  {"OrangeRed3",           205, 55,  0},
  {"OrangeRed4",           139, 37,  0},
  {"Orchid",               218,112,214},
  {"Orchid1",              255,131,250},
  {"Orchid2",              238,122,233},
  {"Orchid3",              205,105,201},
  {"Orchid4",              139, 71,137},
  {"PaleGoldenrod",        238,232,170},
  {"PaleGreen",            152,251,152},
  {"PaleGreen1",           154,255,154},
  {"PaleGreen2",           144,238,144},
  {"PaleGreen3",           124,205,124},
  {"PaleGreen4",            84,139, 84},
  {"PaleTurquoise",        175,238,238},
  {"PaleTurquoise1",       187,255,255},
  {"PaleTurquoise2",       174,238,238},
  {"PaleTurquoise3",       150,205,205},
  {"PaleTurquoise4",       102,139,139},
  {"PaleVioletRed",        219,112,147},
  {"PaleVioletRed1",       255,130,171},
  {"PaleVioletRed2",       238,121,159},
  {"PaleVioletRed3",       205,104,137},
  {"PaleVioletRed4",       139, 71, 93},
  {"PapayaWhip",           255,239,213},
  {"PeachPuff",            255,218,185},
  {"PeachPuff1",           255,218,185},
  {"PeachPuff2",           238,203,173},
  {"PeachPuff3",           205,175,149},
  {"PeachPuff4",           139,119,101},
  {"Peru",                 205,133, 63},
  {"Pink",                 255,192,203},
  {"Pink1",                255,181,197},
  {"Pink2",                238,169,184},
  {"Pink3",                205,145,158},
  {"Pink4",                139, 99,108},
  {"Plum",                 221,160,221},
  {"Plum1",                255,187,255},
  {"Plum2",                238,174,238},
  {"Plum3",                205,150,205},
  {"Plum4",                139,102,139},
  {"PowderBlue",           176,224,230},
  {"Purple",               160, 32,240},
  {"Purple1",              155, 48,255},
  {"Purple2",              145, 44,238},
  {"Purple3",              125, 38,205},
  {"Purple4",               85, 26,139},
  {"Red",                  255,  0,  0},
  {"Red1",                 255,  0,  0},
  {"Red2",                 238,  0,  0},
  {"Red3",                 205,  0,  0},
  {"Red4",                 139,  0,  0},
  {"RosyBrown",            188,143,143},
  {"RosyBrown1",           255,193,193},
  {"RosyBrown2",           238,180,180},
  {"RosyBrown3",           205,155,155},
  {"RosyBrown4",           139,105,105},
  {"RoyalBlue",             65,105,225},
  {"RoyalBlue1",            72,118,255},
  {"RoyalBlue2",            67,110,238},
  {"RoyalBlue3",            58, 95,205},
  {"RoyalBlue4",            39, 64,139},
  {"SaddleBrown",          139, 69, 19},
  {"Salmon",               250,128,114},
  {"Salmon1",              255,140,105},
  {"Salmon2",              238,130, 98},
  {"Salmon3",              205,112, 84},
  {"Salmon4",              139, 76, 57},
  {"SandyBrown",           244,164, 96},
  {"SeaGreen",              46,139, 87},
  {"SeaGreen1",             84,255,159},
  {"SeaGreen2",             78,238,148},
  {"SeaGreen3",             67,205,128},
  {"SeaGreen4",             46,139, 87},
  {"Seashell",             255,245,238},
  {"Seashell1",            255,245,238},
  {"Seashell2",            238,229,222},
  {"Seashell3",            205,197,191},
  {"Seashell4",            139,134,130},
  {"Sienna",               160, 82, 45},
  {"Sienna1",              255,130, 71},
  {"Sienna2",              238,121, 66},
  {"Sienna3",              205,104, 57},
  {"Sienna4",              139, 71, 38},
  {"SkyBlue",              135,206,235},
  {"SkyBlue1",             135,206,255},
  {"SkyBlue2",             126,192,238},
  {"SkyBlue3",             108,166,205},
  {"SkyBlue4",              74,112,139},
  {"SlateBlue",            106, 90,205},
  {"SlateBlue1",           131,111,255},
  {"SlateBlue2",           122,103,238},
  {"SlateBlue3",           105, 89,205},
  {"SlateBlue4",            71, 60,139},
  {"SlateGray",            112,128,144},
  {"SlateGray1",           198,226,255},
  {"SlateGray2",           185,211,238},
  {"SlateGray3",           159,182,205},
  {"SlateGray4",           108,123,139},
  {"SlateGrey",            112,128,144},
  {"Snow",                 255,250,250},
  {"Snow1",                255,250,250},
  {"Snow2",                238,233,233},
  {"Snow3",                205,201,201},
  {"Snow4",                139,137,137},
  {"SpringGreen",            0,255,127},
  {"SpringGreen1",           0,255,127},
  {"SpringGreen2",           0,238,118},
  {"SpringGreen3",           0,205,102},
  {"SpringGreen4",           0,139, 69},
  {"SteelBlue",             70,130,180},
  {"SteelBlue1",            99,184,255},
  {"SteelBlue2",            92,172,238},
  {"SteelBlue3",            79,148,205},
  {"SteelBlue4",            54,100,139},
  {"Tan",                  210,180,140},
  {"Tan1",                 255,165, 79},
  {"Tan2",                 238,154, 73},
  {"Tan3",                 205,133, 63},
  {"Tan4",                 139, 90, 43},
  {"Thistle",              216,191,216},
  {"Thistle1",             255,225,255},
  {"Thistle2",             238,210,238},
  {"Thistle3",             205,181,205},
  {"Thistle4",             139,123,139},
  {"Tomato",               255, 99, 71},
  {"Tomato1",              255, 99, 71},
  {"Tomato2",              238, 92, 66},
  {"Tomato3",              205, 79, 57},
  {"Tomato4",              139, 54, 38},
  {"Turquoise",             64,224,208},
  {"Turquoise1",             0,245,255},
  {"Turquoise2",             0,229,238},
  {"Turquoise3",             0,197,205},
  {"Turquoise4",             0,134,139},
  {"Violet",               238,130,238},
  {"VioletRed",            208, 32,144},
  {"VioletRed1",           255, 62,150},
  {"VioletRed2",           238, 58,140},
  {"VioletRed3",           205, 50,120},
  {"VioletRed4",           139, 34, 82},
  {"Wheat",                245,222,179},
  {"Wheat1",               255,231,186},
  {"Wheat2",               238,216,174},
  {"Wheat3",               205,186,150},
  {"Wheat4",               139,126,102},
  {"White",                255,255,255},
  {"WhiteSmoke",           245,245,245},
  {"Yellow",               255,255,  0},
  {"Yellow1",              255,255,  0},
  {"Yellow2",              238,238,  0},
  {"Yellow3",              205,205,  0},
  {"Yellow4",              139,139,  0},
  {"YellowGreen",          154,205, 50},
  };


// Number of color names
const FXuint fxnumcolornames=ARRAYNUMBER(fxcolornames);


// Get RGB value from color name
FXColor fxcolorfromname(const FXchar* colorname){
  FXint l,h,m,eq,r,g,b;
  FXchar *p,c;
  FXchar name[100];
  if(!colorname){fxerror("fxcolorfromname: NULL colorname argument.\n");}
  for(p=name; (c=*colorname); colorname++){ 
    if(isspace(c)) continue; 
    *p++=c;
    }
  *p++='\0';
  if(name[0]=='#'){
    l=strlen(name)-1;
    if(l==3 && sscanf(name+1,"%01x%01x%01x",&r,&g,&b)==3){
      return FXRGB((r*17),(g*17),(b*17));
      }
    if(l==6 && sscanf(name+1,"%02x%02x%02x",&r,&g,&b)==3){
      return FXRGB(r,g,b);
      }
    if(l==9 && sscanf(name+1,"%03x%03x%03x",&r,&g,&b)==3){
      return FXRGB((r/16),(g/16),(b/16));
      }
    if(l==12 && sscanf(name+1,"%04x%04x%04x",&r,&g,&b)==3){
      return FXRGB((r/257),(g/257),(b/257));
      }
    }
  else{
    l=0;
    h=ARRAYNUMBER(fxcolornames)-1;
    do{
      m=(h+l)>>1;
      eq=fxstrcasecmp(name,fxcolornames[m].name);
      if(eq==0) return FXRGB(fxcolornames[m].r,fxcolornames[m].g,fxcolornames[m].b);
      if(eq<0) h=m-1; else l=m+1;
      }
    while(h>=l);
    }
  return FXRGBA(0,0,0,0);
  }


// Get color name from RGB
FXchar* fxnamefromcolor(FXchar* colorname,FXColor rgb){
  register FXint r,g,b;
  register FXuint i;
  if(!colorname){fxerror("fxnamefromcolor: NULL colorname argument.\n");}
  r=FXREDVAL(rgb);
  g=FXGREENVAL(rgb);
  b=FXBLUEVAL(rgb);
  for(i=0; i<ARRAYNUMBER(fxcolornames); i++){
    if(r==fxcolornames[i].r && g==fxcolornames[i].g && b==fxcolornames[i].b){
      strcpy(colorname,fxcolornames[i].name);
      return colorname;
      }
    }
  sprintf(colorname,"#%02x%02x%02x",r,g,b);
  return colorname;
  }

