/********************************************************************************
*                                                                               *
*              F O X   P r i v a t e   I n c l u d e   F i l e s                *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: xincs.h,v 1.3 1999/10/20 14:25:53 jeroen Exp $                           *
********************************************************************************/
#ifndef XINCS_H
#define XINCS_H


////////////////////  DO NOT INCLUDE THIS PRIVATE HEADER FILE  //////////////////


/************************  Platform  Dependent  Headers  ***********************/

// Basic includes
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>
#include <float.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <time.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef WIN32
#include <grp.h>
#include <pwd.h>
#else
#ifdef _MSC_VER		/* Microsoft Visual C++ */
#include <direct.h>
#define stat _stat
#define lstat _stat
#define getcwd _getcwd
#define mkdir _mkdir
#endif
#ifdef __BORLANDC__	/* Borland C++ Builder */
#include <dir.h>
#endif
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#ifndef __MINGW32__
#include <sys/select.h>
#endif
#endif
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#define NAMLEN(dirent) strlen((dirent)->d_name)
#else
#define dirent direct
#define NAMLEN(dirent) (dirent)->d_namlen
#ifdef HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif
#ifdef HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif
#ifdef HAVE_NDIR_H
#include <ndir.h>
#endif
#endif
#ifdef HAVE_XSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#endif

// MS-Windows 
#ifdef FX_NATIVE_WIN32
#ifndef STRICT
#define STRICT
#endif
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#include <windows.h>
#if !defined(__CYGWIN__) && !defined(__MINGW32__)
#include <commctrl.h>   // For _TrackMouseEvent
#endif

// X windows includes
#else
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xcms.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#ifdef HUMMINGBIRD
#include <X11/XlibXtra.h>
#endif
#ifdef HAVE_XSHM
#include <X11/extensions/XShm.h>
#endif
#endif

// OpenGL includes
#ifdef HAVE_OPENGL
#include <GL/gl.h>
#include <GL/glu.h>
#ifndef FX_NATIVE_WIN32
#include <GL/glx.h>
#endif
#endif

// Maximum path length
#ifdef WIN32
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
#endif

// Printer stuff
#ifdef WIN32
#if !defined(__CYGWIN__) && !defined(__MINGW32__)
#include <winspool.h>
#endif
#endif

// XDND Version
#define XDND_PROTOCOL_VERSION   3

/***********************  Platform  Dependent  Typedefs  ***********************/


/***********************  Platform  Dependent  Globals  ************************/

// Drag type for plain text strings
#ifndef FX_NATIVE_WIN32
#define stringType  XA_STRING
#else
#define stringType  CF_TEXT
#endif

// Shared library support
#ifndef FXAPI
#ifdef WIN32
#ifdef FOXDLL
#ifdef FOXDLL_EXPORTS
#define FXAPI __declspec(dllexport)
#else
#define FXAPI __declspec(dllimport)
#endif
#endif
#endif
#endif

#ifndef FXAPI
#define FXAPI
#endif

#ifdef FX_NATIVE_WIN32

// Return the state of the mouse buttons & modifier keys (see definition of enum FXModifierMasks)
extern FXAPI unsigned int fxmodifierkeys();

// Convert font size (in decipoints) to device logical units
extern FXAPI int fxpointsize_to_height(HDC hdc,unsigned size);

// Convert logical units to decipoints
extern FXAPI unsigned fxheight_to_pointsize(HDC hdc,int height);

#endif


#endif
