/********************************************************************************
*                                                                               *
*                        S p i n   B u t t o n   W i d g e t                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXSpinner.h,v 1.6 1999/11/09 23:58:37 jeroen Exp $                       *
********************************************************************************/
#ifndef FXSPINNER_H
#define FXSPINNER_H



//  Options
enum FXSpinnerOptions {
  SPIN_NORMAL  =  0x00000000,
  SPIN_NUMBERS =  0x00000000,
  SPIN_CYCLIC  =  0x00008000,       // Cyclic spinner
  SPIN_NOTEXT  =  0x00010000,       // No text visible
  SPIN_NOMAX   =  0x00020000,       // Spin all the way up to infinity
  SPIN_NOMIN   =  0x00040000        // Spin all the way down to -infinity
  };

  
//  Spinner control
class FXAPI FXSpinner : public FXPacker {
  FXDECLARE(FXSpinner)
protected:
  FXTextField   *textField;
  FXArrowButton *upButton;
  FXArrowButton *downButton;
  FXint          range[2];          // Reported data range
  FXint          incr;
  FXint          pos;
protected:
  FXSpinner();
  void updateText();
  virtual void layout();
private:
  FXSpinner(const FXSpinner&);
  FXSpinner& operator=(const FXSpinner&);
public:
  long onUpdIncrement(FXObject*,FXSelector,void*);
  long onCmdIncrement(FXObject*,FXSelector,void*);
  long onUpdDecrement(FXObject*,FXSelector,void*);
  long onCmdDecrement(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdSetIntRange(FXObject*,FXSelector,void*);
  long onCmdGetIntRange(FXObject*,FXSelector,void*);
public:
  enum{
    ID_INCREMENT=FXPacker::ID_LAST,
    ID_DECREMENT,
    ID_LAST
    };
public:
  FXSpinner(FXComposite *p,FXint cols,FXObject *tgt=NULL,FXSelector sel=0,FXuint opts=SPIN_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void disable();
  virtual void enable();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void increment();
  void decrement();
  FXbool isCyclic() const;
  void setCyclic(FXbool);
  FXbool isTextVisible() const;
  void setTextVisible(FXbool);
  void setValue(FXint value);
  FXint getValue() const { return pos; }
  void setMinMax(FXint minimum,FXint maximum);
  void getMinMax(FXint& minimum,FXint& maximum) const;
  FXint getMinValue() const { return range[0]; }
  FXint getMaxValue() const { return range[1]; }
  void setIncrement(FXint increment);
  FXint getIncrement() const { return incr; }
  void setText(const FXString& text);
  FXString getText() const;
  void setHelpText(const FXString&  text);
  FXString getHelpText() const;
  void setTipText(const FXString&  text);
  FXString getTipText() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXSpinner();
  };

#endif
