/********************************************************************************
*                                                                               *
*                      M e n u   T i t l e   W i d g e t                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuTitle.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                     *
********************************************************************************/
#ifndef FXMENUTITLE_H
#define FXMENUTITLE_H


class FXMenuPane;


// Menu title button
class FXAPI FXMenuTitle : public FXMenuCaption {
  FXDECLARE(FXMenuTitle)
protected:
  FXMenuPane *pane;
protected:
  FXMenuTitle(){}
private:
  FXMenuTitle(const FXMenuTitle&);
  FXMenuTitle &operator=(const FXMenuTitle&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onCmdPost(FXObject*,FXSelector,void*);
  long onCmdUnpost(FXObject*,FXSelector,void*);
public:
  FXMenuTitle(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXMenuPane* pup=NULL,FXuint opts=LAYOUT_LEFT);
  virtual void create();
  virtual void detach();
  virtual FXbool canFocus() const;
  virtual void setFocus();
  virtual void killFocus();
  void setPopup(FXMenuPane *pup){ pane = pup; }
  FXMenuPane* getPopup() const { return pane; }
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXbool contains(FXint parentx,FXint parenty) const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXMenuTitle();
  };



#endif
