/********************************************************************************
*                                                                               *
*                            L i s t   W i d g e t                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXList.h,v 1.6 1999/11/09 23:58:37 jeroen Exp $                          *
********************************************************************************/
#ifndef FXLIST_H
#define FXLIST_H



// List options
enum FXListStyle {
  LIST_EXTENDEDSELECT    = 0,             // Extended selection mode
  LIST_SINGLESELECT      = 0x00100000,    // At most one selected item
  LIST_BROWSESELECT      = 0x00200000,    // Always exactly one selected item
  LIST_MULTIPLESELECT    = LIST_SINGLESELECT|LIST_BROWSESELECT,  // Multiple selection mode
  LIST_AUTOSELECT        = 0x00400000     // Automatically select under cursor
  };


// List item
class FXAPI FXListItem : public FXObject {
  FXDECLARE(FXListItem)
  friend class FXList;
protected:
  FXString  label;
  FXIcon   *icon;
  void     *data;
  FXuint    state;
protected:
  FXListItem():icon(NULL),data(NULL),state(0){}
  virtual void draw(const FXList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h);
  void drawFocus(const FXList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const;
protected:
  enum{
    SELECTED  = 1,
    MARKED    = 2,
    FOCUS     = 4,
    DISABLED  = 8,
    DRAGGABLE = 16
    };
public:
  FXListItem(const FXString& text,FXIcon* ic=NULL,void* ptr=NULL):label(text),icon(ic),data(ptr),state(0){}
  void setText(const FXString& txt){ label=txt; }
  FXString getText() const { return label; }
  void setIcon(FXIcon* icn){ icon=icn; }
  FXIcon* getIcon() const { return icon; }
  void setData(void* ptr){ data=ptr; }
  void* getData() const { return data; }
  FXbool hasFocus() const { return (state&FOCUS)!=0; }
  FXbool isSelected() const { return (state&SELECTED)!=0; }
  FXbool isEnabled() const { return (state&DISABLED)==0; }
  FXbool isDraggable() const { return (state&DRAGGABLE)!=0; }
  virtual FXint getWidth(const FXList* list) const;
  virtual FXint getHeight(const FXList* list) const;
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXListItem(){}
  };

  
// Item collate function
typedef FXint (*FXListSortFunc)(const FXListItem*,const FXListItem*);


// List widget
class FXAPI FXList : public FXScrollArea {
  FXDECLARE(FXList)
protected:
  FXListItem   **items;
  FXint          nitems;
  FXint          anchor;
  FXint          current;
  FXint          extent;
  FXColor        textColor;
  FXColor        selbackColor;
  FXColor        seltextColor;
  FXint          itemWidth;
  FXint          itemHeight;
  FXint          visible;
  FXListSortFunc sortfunc;
  FXFont        *font;
  FXString       help;
protected:
  FXList();
  FXbool mark(FXint fm,FXint to,FXuint sel);
  FXbool restore(FXint fm,FXint to);
  virtual void layout();
  void recompute();
  virtual FXListItem *createItem(const FXString& text,FXIcon* icon,void* ptr);
private:
  FXList(const FXList&);
  FXList &operator=(const FXList&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
  long onClicked(FXObject*,FXSelector,void*);
  long onDoubleClicked(FXObject*,FXSelector,void*);
  long onTripleClicked(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
public:
  FXList(FXComposite *p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXint getContentWidth();
  virtual FXint getContentHeight();
  virtual void recalc();
  virtual FXbool canFocus() const;
  FXint getNumItems() const { return nitems; }
  FXint getNumVisible() const { return visible; }
  void setNumVisible(FXint nvis);
  FXListItem *retrieveItem(FXint index) const;
  FXint insertItem(FXint index,FXListItem* item);
  FXint replaceItem(FXint index,FXListItem* item);
  FXint appendItem(FXListItem* item);
  FXint insertItem(FXint index,const FXString& text,FXIcon *icon=NULL,void* ptr=NULL);
  FXint replaceItem(FXint index,const FXString& text,FXIcon *icon=NULL,void* ptr=NULL);
  FXint appendItem(const FXString& text,FXIcon *icon=NULL,void* ptr=NULL);
  void removeItem(FXint index);
  void clearItems();
  FXint getItemWidth() const { return itemWidth; }
  FXint getItemHeight() const { return itemHeight; }
  FXint getItemAt(FXint x,FXint y) const;
  FXint findItem(const FXString& text,FXuint len=2147483647) const;
  void makeItemVisible(FXint index);
  void setItemText(FXint index,const FXString& text);
  FXString getItemText(FXint index) const;
  void setItemIcon(FXint index,FXIcon* icon);
  FXIcon* getItemIcon(FXint index) const;
  void setItemData(FXint index,void* ptr);
  void* getItemData(FXint index) const;
  FXbool isItemSelected(FXint index) const;
  FXbool isItemCurrent(FXint index) const;
  FXbool isItemVisible(FXint index) const;
  FXbool isItemEnabled(FXint index) const;
  void updateItem(FXint index);
  FXbool enableItem(FXint index);
  FXbool disableItem(FXint index);
  FXbool selectItem(FXint index);
  FXbool deselectItem(FXint index);
  FXbool toggleItem(FXint index);
  void setCurrentItem(FXint index);
  FXint getCurrentItem() const { return current; }
  void setAnchorItem(FXint index);
  FXint getAnchorItem() const { return anchor; }
  FXbool extendSelection(FXint index);
  FXbool killSelection();
  void sortItems();
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getSelBackColor() const { return selbackColor; }
  void setSelBackColor(FXColor clr);
  FXColor getSelTextColor() const { return seltextColor; }
  void setSelTextColor(FXColor clr);
  FXListSortFunc getSortFunc() const { return sortfunc; }
  void setSortFunc(FXListSortFunc func){ sortfunc=func; }
  FXuint getListStyle() const;
  void setListStyle(FXuint style);
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXList();
  };


#endif
