/********************************************************************************
*                                                                               *
*                           D r a w a b l e   A r e a                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDrawable.h,v 1.4 1999/11/04 20:46:37 jeroen Exp $                     *
********************************************************************************/
#ifndef FXDRAWABLE_H
#define FXDRAWABLE_H


class FXVisual;


class FXAPI FXDrawable : public FXId {
  FXDECLARE_ABSTRACT(FXDrawable)
  friend class FXDC;
  friend class FXDCWindow;
protected:
  FXVisual     *visual;                 // Visual for this window
  FXint         width;                  // Width
  FXint         height;                 // Height
protected:
  FXDrawable();
  FXDrawable(FXApp* a,FXint w,FXint h);
private:
  FXDrawable(const FXDrawable&);
  FXDrawable &operator=(const FXDrawable&);
#ifdef FX_NATIVE_WIN32
  virtual HDC GetDC() const { return NULL; }
  virtual int ReleaseDC(HDC) const { return 0; }
#endif
public:
  
  // Width of drawable
  FXint getWidth() const { return width; }

  // Height of drawable
  FXint getHeight() const { return height; }

  // Get the visual
  FXVisual* getVisual() const { return visual; }

  // Change visual
  void setVisual(FXVisual* vis);
  
  // Create drawable surface
  virtual void create();
  
  // Detach from drawable surface
  virtual void detach();

  // Destroy drawable surface
  virtual void destroy();
  
  // Save object to stream
  virtual void save(FXStream& store) const;
  
  // Load object from stream
  virtual void load(FXStream& store);
  
  // Cleanup
  virtual ~FXDrawable();
  };
  
    
#endif
