
# ------------------------------------------------------------------------
# 	Nmakefile for BLT library using VC++.
#
#  	Please note this file may or may not be up-to-date.  
#	The Makefile.vc file in this directory (it uses the Cygwin
#	tools) is what I use to build BLT.  
#
# ------------------------------------------------------------------------

!INCLUDE ../win/makedefs

TOOLS32		=	C:/Program Files/Microsoft Visual Studio/Vc98
prefix		=	C:/Program Files/Tcl

AR		=	lib.exe
LD		=	link.exe
CC 	     	=	cl.exe
rc32	     	=	rc.exe

# ------------------------------------------------------------------------
# 	C Compiler options 
# ------------------------------------------------------------------------

DEFINES       	=	-D_X86_=1 -D__STDC__ -DWIN32 -DCONSOLE -D_MT \
			$(DEBUG_DEFINES) $(SHLIB_DEFINES)
EXTRA_CFLAGS	=	-nologo -W3 

!IF "$(SHARED)" == "1"
SHLIB_DEFINES 	= 	-D_DLL
SHLIB_TARGET  	= 	build-dll
LIBS		=	$(COMMON_LIBS) 
!ELSE
SHLIB_DEFINES 	= 	-D_CTYPE_DISABLE_MACROS
LIBS		=	$(COMMON_LIBS) $(EXTRA_LIBS)
!ENDIF

!IF "$(DEBUG)" == "1"
CFLAGS  	= 	-Z7 -Od
DEBUG_LDFLAGS 	= 	-debug:full -debugtype:cv  
D		=	d
builddir	=	.\Debug
!ELSE
CFLAGS		=	-Ox -GB -GD 
DEBUG_LDFLAGS 	= 	-debug:full -debugtype:cv  
D		=
builddir	=	.\Release
!ENDIF

MSVCRT		=	msvcrt$(DBG).lib
TK_LIB	      	= 	$(TKDIR)/win/$(builddir)/tk$(v2)$(D).lib  
TCL_LIB		= 	$(TCLDIR)/win/$(builddir)/tcl$(v2)$(D).lib 

# ------------------------------------------------------------------------
# 	Linker flags and options 
# ------------------------------------------------------------------------

JPEGLIB		=	$(JPEGDIR)/libjpeg.lib

COMMON_LDFLAGS  =	-nodefaultlib -release -nologo -warn:3 \
			-machine:IX86 -align:0x1000 \
			$(DEBUG_LDFLAGS)

DLLENTRY	=	@12
SHLIB_LDFLAGS 	= 	$(COMMON_LDFLAGS) \
			-subsystem:console -entry:mainCRTStartup \
			-subsystem:windows -entry:WinMainCRTStartup \
			-entry:_DllMainCRTStartup$(DLLENTRY) -dll  

LDFLAGS		=	$(COMMON_LDFLAGS) \
			-fixed:NO -stack:2300000 

COMMON_LIBS	=	$(TK_LIB) $(TCL_LIB) \
			$(MSVCRT) \
			kernel32.lib user32.lib 

EXTRA_LIBS	=	$(OLELIB) \
			$(JPEGLIB) \
			gdi32.lib \
			oldnames.lib \
			advapi32.lib \
			winspool.lib 

# ------------------------------------------------------------------------
# 	Source and target installation directories 
# ------------------------------------------------------------------------

srcdir	     	=	.
instdirs	=	$(prefix) $(exec_prefix) $(bindir) $(libdir) \
			$(includedir)
instdirs     	=	$(exec_prefix) $(prefix) $(libdir)

# ------------------------------------------------------------------------
# 	Directories containing Tcl and Tk include files and libraries
# ------------------------------------------------------------------------

JPEGDIR		=	$(srcdir)/../../jpeg-6b
TCLDIR     	=	$(srcdir)/../../tcl$(v3)
TKDIR     	=	$(srcdir)/../../tk$(v3)
INCLUDES	=	-I. -I$(srcdir) \
			-I"$(TOOLS32)/include" \
			-I$(TCLDIR)/win \
			-I$(TCLDIR)/generic \
			-I$(TKDIR)/win \
			-I$(TKDIR)/generic \
			-I$(TKDIR)/xlib \
			-I$(JPEGDIR) 
SHLIB_LD_LIBS	=	$(COMMON_LIBS) $(EXTRA_LIBS)

# ------------------------------------------------------------------------
# 	You don't need to edit anything beyond this point
# ------------------------------------------------------------------------

#N_OBJS		=	bltTed.o
V3_OBJS		=	bltTri.o bltGrMt.o 

DEMO_OBJS	=	tkConsole.o bltWinMain.o
TK_OBJS		=	tkButton.o tkFrame.o \
			tkScrollbar.o 

OBJS		=	bltGraph.o bltGrAxis.o \
			bltGrBar.o bltGrElem.o \
			bltGrGrid.o bltGrHairs.o \
			bltGrLegd.o bltGrLine.o \
			bltGrMarker.o bltGrMisc.o \
			bltGrPen.o bltGrPs.o \
			bltBeep.o bltBgexec.o \
			bltBitmap.o bltBusy.o \
			bltContainer.o bltCutbuffer.o \
			bltDebug.o bltDnd.o \
			bltHierbox.o bltHtext.o \
			bltSpline.o bltTable.o \
			bltTabset.o bltVector.o \
			bltWatch.o bltWinop.o \
			bltCanvEps.o bltInit.o \
			bltBind.o bltColor.o \
			bltConfig.o bltImage.o \
			bltList.o bltChain.o \
			bltNsUtil.o bltParse.o \
			bltPs.o bltText.o \
			bltTile.o \
			bltWinPipe.o bltWinUtil.o \
			bltWinPrnt.o \
			bltUtil.o bltWindow.o \
			$(TK_OBJS) $(N_OBJS) pure_api.o

NOT_YET		=	bltContainer.o \
			bltCutBuffer.o bltColor.o

HEADERS		=	blt.h

shell_name	= 	bltwish
version		=	$(BLT_MAJOR_VERSION)$(BLT_MINOR_VERSION)
demo		=	$(shell_name).exe
demo2		=	$(shell_name)$(version).exe
lib_name	=	BLT$(version)
BLT_DLL		=	$(lib_name).dll		
BLT_LIB		=	$(lib_name).lib

CC_SWITCHES	=	$(CFLAGS) $(EXTRA_CFLAGS) $(DEFINES) $(INCLUDES)
VPATH		= 	$(srcdir)

all: build-library $(SHLIB_TARGET) build-demo

install: all install-dirs install-lib install-headers install-demo

build-demo: $(SHLIB_TARGET) $(demo)

build-library: $(BLT_LIB)

build-dll: build-library $(BLT_DLL)

$(demo): build-library $(DEMO_OBJS)
	$(RM) $@
	set LIB="$(TOOLS32)\lib"
	$(LD) $(LDFLAGS) $(DEMO_OBJS) -out:$@ $(BLT_LIB) $(LIBS) 

$(BLT_LIB):  $(OBJS)
	$(RM) $@
	$(AR) -out:$@ $(OBJS)

$(BLT_DLL): $(BLT_LIB) $(OBJS)
	$(RM) $@
	set LIB="$(TOOLS32)\lib"
	$(LD) $(SHLIB_LDFLAGS) -out:$@ $(OBJS) $(SHLIB_LD_LIBS)

install-dirs:
	@for i in $(instdirs) ; do \
	    if test ! -d "$$i" ; then \
		echo " mkdir $$i" ; \
		mkdir "$$i" ; \
	    fi ; \
        done

install-demo: 
	$(INSTALL) $(demo) $(bindir)/$(demo)
	$(INSTALL) $(demo) $(bindir)/$(demo2)

install-lib: install-dirs $(BLT_DLL) $(BLT_LIB)
	$(INSTALL_DATA) $(BLT_DLL) $(bindir)
	$(INSTALL_DATA) $(BLT_LIB) $(libdir)

install-headers:
	for i in $(HEADERS) ; do \
	    echo "installing $(includedir)/$$i..." ; \
	    $(INSTALL_DATA) "$(srcdir)/$$i" $(includedir) ; \
	done

clean:
	-del $(builddir)\*.o 2>nul
	-del $(builddir)\$(lib_name).* 2>nul
	-del $(builddir)\$(shell_name).* 2>nul
	-rmdir $(builddir) 2>nul
	-del $(srcdir)\*.bak 2>nul
	-del $(srcdir)\*~ 2>nul 
	-del $(srcdir)\"#"* 2>nul

{$(srcdir)}.c.o:
	$(CC) -c $(CC_SWITCHES) -Fo$*.o $<
