# ------------------------------------------------------------------------
#       Makefile for demonstation shell of BLT library
# ------------------------------------------------------------------------

include ./win/makedefs

# ------------------------------------------------------------------------
#       Source and target installation directories
# ------------------------------------------------------------------------

srcdir		= .
instdirs	= $(prefix) $(exec_prefix) $(bindir) $(libdir) $(includedir)

# ------------------------------------------------------------------------
#       Don't edit anything beyond this point
# ------------------------------------------------------------------------

subdirs	     = src demos library html

all:  
	@for i in $(subdirs) ; do \
	    (cd $$i; $(MAKE) -f Makefile.gnu all) ; \
	done

install: install-dirs install-all install-readme

install-all:
	@for i in $(subdirs) ; do \
	    (cd $$i; $(MAKE) -f Makefile.gnu install) ; \
        done

install-dirs:
	@for i in $(instdirs) ; do \
	    if test ! -d "$$i" ; then \
		echo " mkdir $$i" ; \
		mkdir $$i ; \
	    fi ; \
        done

install-readme:
	$(INSTALL_DATA) $(srcdir)/README $(scriptdir)
	$(INSTALL_DATA) $(srcdir)/PROBLEMS $(scriptdir)

clean:
	@for i in $(subdirs) ; do \
	    (cd $$i; $(MAKE) -f Makefile.gnu clean) ; \
	done
	$(RM) *.bak *\~ "#"* *pure* .pure*

GENERATED_FILES = \
	config.status config.cache config.log Makefile 

distclean: clean
	$(RM) $(GENERATED_FILES)
