#
# HPUXRISC/options.mk ---
# Part of Makefile for PFE, compiler options for HP-UX on PA-RISC machines.
#

# You can use gcc or the HP c89 compiler.
# For some time the HP compiler didn't work with -O (which is +O2)
# but worked with +O1. Try it, you'll see immediately if your's still
# doesn't work.
# Another problem with the HP-compiler is that it fails to handle the
# `const' keyword correctly in one place in file `dictnry.c'. That's
# why const is #defined to nothing.
# No problem with gcc which is faster anyway due to the global register
# variables.

PREFIX	= /usr/local
PFELIB	= $(PREFIX)/lib/pfe
PFEHLP	= $(PFELIB)/help

SYSTEM	= HPUX

CC	= gcc -pipe -Wall
OPTIM	= -O2 -fomit-frame-pointer -DUSE_REGS
DEBUG	= -g -O
OPTIONS	= -D_HPUX_SOURCE -DUSE_TERMCAP

#CC	= c89 -Aa
#OPTIM	= +O1
#DEBUG	= -g
#OPTIONS = -D_HPUX_SOURCE -DUSE_TERMCAP -Dconst=""

CL	= $(CC)
CPP	= $(CC) -E

STRIP	= -s
TERM_O	= termunix$o
SYS_O	= unix$o
LFLAGS	= -L/lib/pa1.1
LIBS	= -lcurses -lm


