#! /usr/local/bin/ruby

require 'xmlparser'
require 'nkf'
require 'uconv'

class XMLRetry<Exception; end

xml = $<.read
parser = XMLParser.new
def parser.default; end
def parser.unknownEncoding(e)
  raise XMLRetry, e
end

begin
  parser.parse(xml) do |type, name, data|
    case type
    when XMLParser::START_ELEM
      data.each do |key, value|
        print Uconv.u8toeuc("A#{key} CDATA #{value}\n")
      end
      print "(#{name}\n"
    when XMLParser::END_ELEM
      print Uconv.u8toeuc(")#{name}\n")
    when XMLParser::CDATA
      data.gsub!("\n", "\\n")
      print Uconv.u8toeuc("-#{data}\n")
    when XMLParser::PI
      data.gsub!("\n", "\\n")
      print Uconv.u8toeuc("?#{name} #{data}\n")
    else
      next if data =~ /^<\?xml /
      data.gsub!("\n", "\\n")
      print Uconv.u8toeuc("//#{data}\n")
    end
  end
rescue XMLRetry
  newencoding = nil
  e = $!.to_s
  if e =~ /^iso-2022-jp$/i
    xml = NKF.nkf("-Je", xml)
    newencoding = "EUC-JP"
  end
  parser = XMLParser.new(newencoding)
  def parser.default; end
  retry
rescue XMLParserError
  line = parser.line
  print "Parse error(#{line}): #{$!}\n"
end
