// ---------------------------------------------------------------------------
// - Directory.hpp                                                           -
// - aleph:sio library - directory class definition                          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_DIRECTORY_HPP
#define  ALEPH_DIRECTORY_HPP

#ifndef  ALEPH_LIST_HPP
#include "List.hpp"
#endif

namespace aleph {

  /// The Directory class provides facilities to access a directory
  /// and retreive its contents. The directory contents is returned as
  /// a vector of names. The default constructor opens the '.' directory.
  /// @author amaury darsch

  class Directory : public Object {
  private:
    /// the directory name
    String d_name;
    /// the directory handle
    void* p_handle;

  public:
    /// open the default directory
    Directory (void);

    /// open a directory by name
    /// @param name the directory to open
    Directory (const String& name);

    /// destroy this directory accessor
    ~Directory (void);

    /// @return the class name
    String repr (void) const;

    /// @return the directory name
    inline String getname (void) const {
      return d_name;
    }

    /// @return a list of this directory names
    List* getlist (void);

    /// @return a list of this directory files
    List* getfiles (void);

    /// @return a list of sub directories
    List* getdirs (void);

    /// create a new directory by name
    /// @param name the directory name
    void mkdir (const String& name);

    /// remove a directory by name
    /// @param name the directory to remove
    void rmdir (const String& name);

    /// generate a new directory
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// evaluate a directory member name
    /// @param interp interp the current interpreter
    /// @param nset   the current nameset    
    /// @param name   the name to evaluate
    Object* eval (Interp* interp, Nameset* nset, const String& name);

    /// apply this directory with a set of arguments and a method name
    /// @param interp interp the current interpreter
    /// @param nset   the current nameset    
    /// @param name   the name to apply this arguments
    /// @param args   the arguments to apply
    Object* apply (Interp* interp, Nameset* nset, const String& name,
		   Cons* args);

  private:
    // make the copy constructor private
    Directory (const Directory&);
    // make the assignment operator private
    Directory& operator = (const Directory&);
  };
}

#endif
