// ---------------------------------------------------------------------------
// - Return.cpp                                                              -
// - aleph engine - return exception class implementation                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Return.hpp"
#include "String.hpp"

namespace aleph {

  // create a default return object

  Return::Return (void) {
    p_object = nilp;
  }

  // create a return object with an object

  Return::Return (Object* object) {
    p_object = Object::iref (object);
  }

  // copy constructor for this returned object
  
  Return::Return (const Return& that) {
    p_object = Object::iref (that.p_object);
  }

  // destroy this return object

  Return::~Return (void) {
    Object::dref (p_object);
  }

  // return the class name

  String Return::repr (void) const {
    return "Return";
  }
}
