// logconv.cpp
//
// Copyright (C) 1999 Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#if defined(__NT__)
#include <windows.h>
#endif
#include <stdio.h>
#if !defined(__NT__)
#include <string.h>
#endif

#include "adiffile.h"
#include "arrlfile.h"
#include "ctfile.h"
#include "ct8file.h"
#include "ct9file.h"
#include "dbfile.h"
#include "dxclus.h"
#include "dxifile.h"
#include "nafile.h"
#include "na9file.h"
#include "sdffile.h"
#include "trfile.h"
#include "wrtc.h"

#define STRING_BUFFER_SIZE    2048

#if !defined(_CMD_LINE_)
char *contString = "Would you like to convert another file?\n\r";
#endif

#if !defined(_CMD_LINE_)
static int GetInputFileName(char *);
static int GetOutputFileName(char *, int *);
static void FilePrefix(char *, char*);
#else
static int OutputLogType(char *);
static void ShowOptions();
#endif
static int LogType(char *);
char *LogConvVersion = "1.54";

#if defined(__NT__)
  #if defined(_CMD_LINE_)
    static char *exeName = "clogconv";        // Win32 console
  #endif
#else
  #ifdef LINUX
    static char *exeName = "logconv";         // Linux
  #else
    static char *exeName = "dlogconv";        // DOS
  #endif
#endif

#if defined(__NT__)
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                     LPTSTR lpCmdLine, int nCmdShow)
#else
int main(int argc, char *argv[])
#endif                   
{
#if !defined(_CMD_LINE_)
    boolean bAnotherLog = IDYES;
    char *progName = "LogConv";
    char displayBuffer[80];
    int  OutputFileType;
#else
#if !defined(__NT__)
    char lpCmdLine[STRING_BUFFER_SIZE];
#endif
    boolean bVerboseMode = FALSE;
#endif
    char InputFileName[STRING_BUFFER_SIZE];
    char OutputFileName[STRING_BUFFER_SIZE];

    qso_data qso;

    RQsoFile    *FromFile;
    RQsoFile    *ToFile;

#if defined(__NT__)
    // These are to remove warnings about these not being used.
    hInstance = hInstance;
    hPrevInstance = hPrevInstance;
    lpCmdLine = lpCmdLine;
    nCmdShow = nCmdShow;
#endif

#if !defined(_CMD_LINE_)
    MessageBox(NULL, "Amateur Radio Log File Conversion v1.54\n\r\n\r             (c) 1999 by KA5WSS",
               progName, MB_OK);

    while (bAnotherLog == IDYES)
    {
        if (!GetInputFileName(InputFileName))
        {
            MessageBox(NULL, "Can't find the requested file", progName, MB_OK | MB_ICONSTOP);
            return FALSE;
        }
#else
    printf("Amateur Radio Log File Conversion v1.54\n\r(c) 1999 by KA5WSS\n\r\n\r");
    
#if defined(__NT__)
    {
        char *CmdLineTmp = new char[strlen(lpCmdLine) + 1];
        char *tmp1, *tmp2;

        strcpy(CmdLineTmp, lpCmdLine);
        if (((tmp1 = strtok(CmdLineTmp, " ")) == NULL)
             || ((tmp2 = strtok(NULL, " ")) == NULL))
        {
            if (tmp1 && (stricmp(tmp1, "-h") == 0))
                ShowOptions();
            else
            {
                printf("usage: %s infile outfile [options]\n\r", exeName);
                printf("\n\rFor a complete list of options type in \'%s -h\'\n\r", exeName);
            }
            return (1);
        }

        strcpy(InputFileName, tmp1);
        strcpy(OutputFileName, tmp2);
        delete CmdLineTmp;
    }
#else
    if (argc < 3)
    {
        if ((argc == 2) && (stricmp("-h", argv[1]) == 0))
            ShowOptions();
        else
        {
            printf("usage: %s infile outfile [options]\n\r", exeName);
            printf("\n\rFor a complete list of options type in \'%s -h\'\n\r", exeName);
        }
        return(1);
    }
    
    *lpCmdLine = (char)NULL;
    for (int c = 3; c < argc; c++)     // Turn command line arguments into a string
    {                                   // Similar to Windows.
        strcat(lpCmdLine, argv[c]);
        strcat(lpCmdLine, " ");
    }
    
    strcpy(InputFileName, argv[1]);
    strcpy(OutputFileName, argv[2]);
#endif
#endif    

        switch (LogType(InputFileName))
        {
            case LOG_TYPE_CT7:
                    FromFile = new RCtFile();
                    break;
            case LOG_TYPE_CT8:
                    FromFile = new RCt8File();
                    break;
            case LOG_TYPE_CT9:
                    FromFile = new RCt9File();
                    break;
            case LOG_TYPE_WRTC:
                   FromFile = new RWrtcFile();
                    break;
            case LOG_TYPE_NALOG:
                    FromFile = new RNaFile();
                    break;
            case LOG_TYPE_NA9LOG:
                    FromFile = new RNa9File();
                    break;
            case LOG_TYPE_TRLOG:
                    FromFile = new RTrFile();
                    break;
            case LOG_TYPE_DXINFO:
                    FromFile = new RDxiFile();
                    break;
            case LOG_TYPE_DXCLUS:
                    FromFile = new RDxClusFile();
                    break;
            case LOG_TYPE_ARRL:
                    FromFile = new RArrlFile();
                    break;
            case LOG_TYPE_ADIF:
                    FromFile = new RAdifFile();
                    break;
            case LOG_TYPE_UNKNOWN:
            default:
#if !defined(_CMD_LINE_)
                    MessageBox(NULL, "File type or contest not implemented!", progName, MB_OK | MB_ICONSTOP);
#else
                    printf("File type or contest not implemented!\n\r");
#endif                    
                    return FALSE;
        }
        
        if (!FromFile->open(InputFileName, ios::in))
        {
#if !defined(_CMD_LINE_)
            char tempMsg[80];
            sprintf(tempMsg, "Error opening %s\n\r", InputFileName);
            MessageBox(NULL, tempMsg, progName, MB_OK | MB_ICONSTOP);
#else
            printf("Error opening %s\n\r", InputFileName);
#endif
            return FALSE;
        }
        
        FromFile->setOptions(lpCmdLine);

#if !defined(_CMD_LINE_)            
        FilePrefix(OutputFileName, InputFileName);
        if (!GetOutputFileName(OutputFileName, &OutputFileType))
        {
            MessageBox(NULL, "Can't open the requested file", progName, MB_OK | MB_ICONSTOP);
            return FALSE;
        }
        else
#endif            
        {
#if !defined(_CMD_LINE_)
            switch (OutputFileType)
#else
            switch (OutputLogType(OutputFileName))
#endif            
            {
                case LOG_TYPE_CT8:
                        ToFile = new RCt8File();
                        break;
                case LOG_TYPE_TRLOG:
                        ToFile = new RTrFile();
                        break;
                case LOG_TYPE_DBASE:
                        ToFile = new RDbFile();
                        break;
                case LOG_TYPE_SDF:
                       ToFile = new RSdfFile();
                        break;
                case LOG_TYPE_ARRL:
                        ToFile = new RArrlFile();
                        break;
                case LOG_TYPE_DXINFO:
                        ToFile = new RDxiFile();
                        break;
                case LOG_TYPE_ADIF:
                        ToFile = new RAdifFile();
                        break;
                case LOG_TYPE_CT7:
                case LOG_TYPE_CT9:
                case LOG_TYPE_UNKNOWN:
                default:
#if !defined(_CMD_LINE_)                
                        MessageBox(NULL, "File type not implemented!", progName, MB_OK | MB_ICONSTOP);
#else
                        printf("File type not implemented!\n\r");
#endif                        
                        return FALSE;
            }
            
            /* Should have exited from switch statement if object not initialized! */
#ifdef LINUX
            if (!ToFile->open(OutputFileName, ios::out | ios::noreplace))
#else
            if (!ToFile->open(OutputFileName, ios::out | ios::noreplace | ios::binary))
#endif
            {
#if !defined(_CMD_LINE_)                
                MessageBox(NULL, "Output file could not be opened", progName, MB_OK | MB_ICONSTOP);
#else
                printf("Output file could not be opened\n\r");
#endif                
                FromFile->close();
                return FALSE;
            }
            
            ToFile->setOptions(lpCmdLine);
                
        }

        if (!(ToFile->writeHeader(FromFile->headerInfo())))
        {
#if !defined(_CMD_LINE_)            
            MessageBox(NULL, "Contest not supported by output file", progName, MB_OK | MB_ICONSTOP);
#else
            printf("Contest not supported by output file\n\r");
#endif            
            return FALSE;
        }

#if defined(_CMD_LINE_)
        if (strstr(lpCmdLine, "-v") != NULL)
            bVerboseMode = TRUE;
#endif

        FromFile->nextQso(&qso);
        while (!(FromFile->eof()))
        {
#if defined(_CMD_LINE_)
            if (bVerboseMode)
                printf("Converting QSO #%d\r\n", FromFile->position());
#endif
            ToFile->writeQso(&qso);
            if (!FromFile->nextQso(&qso) && !FromFile->eof())
            {
#if !defined(_CMD_LINE_)                
                MessageBox(NULL, "Error reading end of input file",
                           progName, MB_OK | MB_ICONERROR);
#else
                printf("Error reading input file\n\r");
#endif                
                break;
            }
        }
        FromFile->close();
        ToFile->close();

#if !defined(_CMD_LINE_)
        sprintf(displayBuffer, "Conversion Complete!\n\rProcessed %d QSO's", FromFile->position());
        MessageBox(NULL, displayBuffer, progName, MB_OK);

        bAnotherLog = MessageBox(NULL, contString,
                                 progName, MB_YESNO | MB_ICONQUESTION);
    };
#else
        printf("Conversion Complete!\n\rProcessed %d QSO's\n\r", FromFile->position());
#endif                                 
               
    return 0;
}

#if !defined(_CMD_LINE_)    
// Warning!  The buffer passed via sFileName had better be at least as large as STRING_BUFFER_SIZE!

static int GetInputFileName(char *sFileName)
{
    OPENFILENAME OpenFileName;

    memset(&OpenFileName, '\0', sizeof(OPENFILENAME));
    memset(sFileName, '\0', STRING_BUFFER_SIZE);
    OpenFileName.lStructSize = sizeof(OPENFILENAME);
    OpenFileName.hwndOwner = NULL;
    OpenFileName.lpstrFile = sFileName;
    OpenFileName.nMaxFile = STRING_BUFFER_SIZE;
    OpenFileName.lpstrTitle = NULL;
    OpenFileName.lpstrFilter = "ADIF Log Files (*.adi)\0*.ADI\0CT Log files (*.bin)\0*.BIN\0TR Log, DX Cluster and DX Info files (*.dat)\0*.DAT\0NA Log files(*.qdf)\0*.QDF\0ARRL and WRTC Log files (*.log)\0*.LOG\0All Log file types\0*.ADI;*.BIN;*.DAT;*.LOG;*.QDF\0";
    OpenFileName.lpstrDefExt = "";
    OpenFileName.nFilterIndex = 1L;
    OpenFileName.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST
                         | OFN_HIDEREADONLY | OFN_NOTESTFILECREATE;

    if (!GetOpenFileName(&OpenFileName))
        return FALSE;
    else
        return TRUE;
}

// Warning!  The buffer passed via sFileName had better be at least as large as STRING_BUFFER_SIZE!

static int GetOutputFileName(char *sFileName, int *iFileType)
{
    OPENFILENAME OpenFileName;

    memset(&OpenFileName, '\0', sizeof(OPENFILENAME));
    OpenFileName.lStructSize = sizeof(OPENFILENAME);
    OpenFileName.hwndOwner = NULL;
    OpenFileName.lpstrFile = sFileName;
    OpenFileName.nMaxFile = STRING_BUFFER_SIZE;
    OpenFileName.lpstrTitle = NULL;
    OpenFileName.lpstrFilter = "ADIF Log Files (*.adi)\0*.ADI\0CT v8 Log Files (*.bin)\0*.BIN\0TR Log Files (*.dat)\0*.DAT\0dBase Files (*.dbf)\0*.DBF\0ARRL File (*.log)\0*.LOG\0DXBase Files (*.sdf)\0*.SDF\0";
    OpenFileName.lpstrDefExt = "";
    OpenFileName.nFilterIndex = 1L;
    OpenFileName.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOTESTFILECREATE;

    if (!GetSaveFileName(&OpenFileName))
        return FALSE;
    else
    {
        boolean AppendExt = FALSE;

        // Under Win3.1 the extension is not automatically appended to the filename.
        //  Do it manually, if needed.        
        if ((OpenFileName.nFileExtension == 0) || (OpenFileName.nFileExtension == strlen(sFileName)))
            AppendExt = TRUE;
            
        switch (OpenFileName.nFilterIndex)
        {
            case 1:
                *iFileType = LOG_TYPE_ADIF;
                if (AppendExt)
                    strcat(sFileName, ".adi");
                break;
            case 2:
                *iFileType = LOG_TYPE_CT8;
                if (AppendExt)
                    strcat(sFileName, ".bin");
                break;
            case 3:
                *iFileType = LOG_TYPE_TRLOG;
                if (AppendExt)
                    strcat(sFileName, ".dat");
                break;
            case 4:
                *iFileType = LOG_TYPE_DBASE;
                if (AppendExt)
                    strcat(sFileName, ".dbf");
                break;
            case 5:
                *iFileType = LOG_TYPE_ARRL;
                if (AppendExt)
                    strcat(sFileName, ".log");
                break;
            case 6:
                *iFileType = LOG_TYPE_SDF;
                if (AppendExt)
                    strcat(sFileName, ".sdf");
                break;
            default:
                *iFileType = LOG_TYPE_UNKNOWN;
        }
        return TRUE;
    }
}

// This routine returns the prefix name of a file supplied in pathName.  For
//  example pathName="d:\tmp\example.txt" would result in name="example".
static void FilePrefix(char *name, char *pathName)
{
    char *dot = strrchr(pathName, '.');
    char *slash = strrchr(pathName, '\\');

    if (!dot)
        dot = pathName + strlen(pathName);
    if (!slash)
        slash = pathName;
    else
        slash++;

    strncpy(name, slash, dot - slash);
    name[dot - slash] = NULL;
    return;
}
#endif

#if defined(_CMD_LINE_)
// This routine tries to determine the output file's file
// type based on the user supplied file name's suffix.
static int OutputLogType(char *sFileName)
{
    char *suffix = strrchr(sFileName, '.');

    if (suffix)
        suffix++;

    if (stricmp(suffix, "bin") == 0)
        return LOG_TYPE_CT8;
    else if (stricmp(suffix, "dbf") == 0)
        return LOG_TYPE_DBASE;
    else if (stricmp(suffix, "dat") == 0)
        return LOG_TYPE_TRLOG;
    else if (stricmp(suffix, "sdf") == 0)
        return LOG_TYPE_SDF;
    else if (stricmp(suffix, "log") == 0)
        return LOG_TYPE_ARRL;
    else if (stricmp(suffix, "adi") == 0)
        return LOG_TYPE_ADIF;
    else
        return LOG_TYPE_UNKNOWN;
}
#endif

static int LogType(char *sFileName)
{
    RFile Log;

#ifdef LINUX
    Log.open(sFileName, ios::in);
#else
    Log.open(sFileName, ios::in | ios::binary);
#endif
    return Log.fileType();
}

#if defined(_CMD_LINE_)
static void ShowOptions()
{
    printf("usage: %s infile outfile [options]\n\r\n\r", exeName);
    printf("  -bNumeric    Output the BAND field in meters (dBase output only).\n\r"); 
    printf("  -c<contest>  Indicate the contest type for logs that do not contain header\n\r");
    printf("               information (ARRL .log).  See readme.txt for the list of values.\n\r");
    printf("  -freq        Add new output field which contains the exact frequency, in MHz\n\r");
    printf("               (dBase output only).\n\r");
    printf("  -h           Displays this list of options (Command Line only).\n\r");
    printf("  -n \"Comment\" Indicate string to be placed in notes field, if applicable.\n\r");
    printf("  -qsonum      Add field which sequentially numbers QSO's (dBase output only).\n\r");
    printf("  -tApproach   Append \'TM9\' to TIME field for Approach support\n\r");
    printf("               (dBase output only).\n\r");
    printf("  -v           Verbose output.  Will indicate the QSO number being converted\n\r");
    printf("               (Command Line only).\n\r");
    return;
}
#endif

