/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_FLEX_ARRAY_COORD2_H
#define _TF_FLEX_ARRAY_COORD2_H

#include "flexarray.h"


/*
 *  TFFlexArrayCoord2: provide a built in destructor for the COORD2 type. 
 *	chunks) as new data is extended and provides fast access.
 */
class TFFlexArrayCoord2 : public FlexArray
	{
	public:
				TFFlexArrayCoord2 (int n, float growth=2.0);
	protected:
		virtual void	clearArray ();
	};


inline TFFlexArrayCoord2::TFFlexArrayCoord2  (int n, float growth)
		 	 : FlexArray (n, growth)
{
;
}


inline void TFFlexArrayCoord2::clearArray ()
{
	if (!this->d_array)
		return;

	int             i, lim = this->getSize();
        COORD2		*c2;

        for (i=0; i<lim; i++)
                {
                c2 = static_cast<COORD2*>(this->last());
                this->removeLast ();
                delete c2;
                }
}


#endif // _TF_FLEX_ARRAY_COORD2_H
