/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Modified by the GLib Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/. 
 */

/* 
 * MT safe ; except for tf_on_error_stack_trace, but who wants thread safety 
 * then
 */


/* This code is shamelessly stolen from glib (version 1.2.3) - RNG */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef TF_DEBUG
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include "glib.h"
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#ifdef HAVE_SYS_TIMES_H
#include <sys/times.h>
#endif
#include <sys/types.h>
#include <sys/wait.h>

#include <time.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif /* HAVE_SYS_SELECT_H */

#ifdef STDC_HEADERS
#include <string.h> /* for bzero on BSD systems */
#endif

#ifdef _MSC_VER
#include <process.h>		/* For _getpid() */
#endif

#ifndef NO_FD_SET
#  define SELECT_MASK fd_set
#else
#  ifndef _AIX
     typedef long fd_mask;
#  endif
#  if defined(_IBMR2)
#    define SELECT_MASK void
#  else
#    define SELECT_MASK int
#  endif
#endif


void tf_segfault_handler (int sig);
static void tf_on_error_query ();
static void tf_on_error_stack_trace ();
static void stack_trace (char **args);
static void stack_trace_sigchld (int signum);

static gboolean stack_trace_done = FALSE;


void tf_segfault_handler(int sig)
{
	printf("\nSegmentation fault !!!\n\n\
Looks like you've found a bug in terraform. Unless it's in a really
obvious/visible place where it should be impossible for the author to
miss, please mail r.gasch@chello.nl with the details so that
he may learn of it's existence and attempt to fix it. (See the Terraform 
FAQ for the finer points of this.)\n\n");
	tf_on_error_query ();
	fprintf (stdout, "Forcing exiting of terraform now!\n");
	exit (1);
}


void tf_on_error_query ()
{
	static const gchar 	*query1 = "[E]xit";
	static const gchar 	*query2 = ", show [S]tack trace";
	static const gchar 	*query3 = " or [P]roceed";
	static const gchar 	*prg_name = "terraform";
	gchar 			buf[16];

	retry: 

	fprintf (stdout, "%s (pid:%u): %s%s%s: ",
	     prg_name, (guint) getpid (), query1, query2, query3);
	fflush (stdout);
  
	fgets (buf, 8, stdin);

	if ((buf[0] == 'E' || buf[0] == 'e') && buf[1] == '\n')
		exit (0);
	else 
	if ((buf[0] == 'P' || buf[0] == 'p') && buf[1] == '\n')
		return;
	else 
	if (prg_name && (buf[0] == 'S' || buf[0] == 's')
	   && buf[1] == '\n')
		tf_on_error_stack_trace ();

	goto retry;
}


void tf_on_error_stack_trace ()
{
#ifndef NATIVE_WIN32
	pid_t 			pid;
	gchar 			buf[16];
	gchar 			*args[4] = { "gdb", NULL, NULL, NULL };
	static const gchar 	*prg_name = "terraform";

	sprintf (buf, "%u", (guint) getpid ());

	args[1] = (gchar*) prg_name;
	args[2] = buf;

	pid = fork ();
	if (pid == 0)
		{
		stack_trace (args);
		_exit (0);
		}
	else 
	if (pid == (pid_t) -1)
		{
		perror ("unable to fork gdb");
		return;
		}
	// cast to make sure this compiles on all platforms 
	wait ((int*)(&pid)); 		// don't need pid anymore
#else
	abort ();
#endif
}

static void stack_trace_sigchld (int signum)
{
	stack_trace_done = TRUE;
}


static void stack_trace (char **args)
{
#ifndef NATIVE_WIN32
	pid_t 		pid;
	int 		in_fd[2];
	int 		out_fd[2];
	SELECT_MASK 	fdset;
	SELECT_MASK 	readset;
	struct timeval 	tv;
	int 		sel, index, state;
	char 		buffer[256];
	char 		c;

	stack_trace_done = FALSE;
	signal (SIGCHLD, stack_trace_sigchld);

	if ((pipe (in_fd) == -1) || (pipe (out_fd) == -1))
		{
		perror ("unable to open pipe");
		exit (0);
		}

	pid = fork ();
	if (pid == 0)
		{
		close (0); dup (in_fd[0]);   /* set the stdin to the in pipe */
		close (1); dup (out_fd[1]);  /* set the stdout to the out pipe */
		close (2); dup (out_fd[1]);  /* set the stderr to the out pipe */

		execvp (args[0], args);      /* exec gdb */
		perror ("exec failed");
		exit (0);
		}
	else 
	if (pid == (pid_t) -1)
		{
		perror ("unable to fork");
		exit (0);
		}

	FD_ZERO (&fdset);
	FD_SET (out_fd[0], &fdset);

	write (in_fd[1], "backtrace\n", 10);
	write (in_fd[1], "p x = 0\n", 8);
	write (in_fd[1], "quit\n", 5);

	index = 0;
	state = 0;

	while (1)
		{
		readset = fdset;
		tv.tv_sec = 1;
		tv.tv_usec = 0;

		sel = select (FD_SETSIZE, &readset, NULL, NULL, &tv);
		if (sel == -1)
			break;

		if ((sel > 0) && (FD_ISSET (out_fd[0], &readset)))
		    {
		    if (read (out_fd[0], &c, 1))
			{
 			switch (state)
			    {
			    case 0:
				if (c == '#')
					{
					state = 1;
					index = 0;
					buffer[index++] = c;
					}
				break;
			    case 1:
				buffer[index++] = c;
				if ((c == '\n') || (c == '\r'))
					{
					buffer[index] = 0;
					fprintf (stdout, "%s", buffer);
					state = 0;
					index = 0;
					}
				break;
			    default:
				break;
 			    }
			}
		    }
		else 
		if (stack_trace_done)
			break;
		}

	close (in_fd[0]);
	close (in_fd[1]);
	close (out_fd[0]);
	close (out_fd[1]);
	exit (0);
#else
	abort ();
#endif
}

#endif //TF_DEBUG
