/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFPreviewDialog.h"
#include "GuiColormap.h"
#include "GuiColormapBands.h"
#include "GuiDialogOAC.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"



/*
 *  constructor: initialize all data members 
 */
TFPreviewDialog::TFPreviewDialog (HeightField *HF, HeightFieldDraw *HFD, 
				  char *winTitle, char *paramTitle,
				  int tableX, int tableY) 
	        : GuiDialogPreview (winTitle, paramTitle, tableX, tableY),
		  d_vBoxOptions (TRUE, 5)
{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFPreviewDialog::TFPreviewDialog");
	SanityCheck::bailout ((!HFD), "HFD==NULL", "TFPreviewDialog::TFPreviewDialog");

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFPreviewDialog\n");

	d_cx = d_cy = -1;
	d_hfTimestamp = 0;
	p_HF = NULL;
	p_HFD = NULL;
	p_HFO = NULL;
	p_HFPreview = NULL;
	p_HFDPreview = NULL;
	p_HFOPreview = NULL;
}


/*
 *  destructor: clean up 
 */
TFPreviewDialog::~TFPreviewDialog ()
{
	if (p_HFO)
		delete p_HFO;
	if (p_HFPreview)
		delete p_HFPreview;
	if (p_HFDPreview)
		delete p_HFDPreview;
	if (p_HFOPreview)
		delete p_HFOPreview;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFPreviewDialog\n");
}


/*
 *  setHBobjs: set the HF objects we operate on and generate a scaled 
 * 	down version for the preview 
 */
void TFPreviewDialog::setHFobjs (HeightField *HF, HeightFieldDraw *HFD)
{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFPreviewDialog::setHFobjs");
	SanityCheck::bailout ((!HFD), "HFD==NULL", "TFPreviewDialog::setHFobjs");

	GuiColormap 	*cMap = HFD->getColormap();

	if (HF!=p_HF || HFD!=p_HFD)
		{
		if (p_HFO)
			delete p_HFO;
		p_HF = HF;
		p_HFD = HFD;
		p_HFO = new HeightFieldOps (p_HF);
		}

	if (p_HFPreview)
		delete p_HFPreview;
	if (p_HFDPreview)
		delete p_HFDPreview;
	if (p_HFOPreview)
		delete p_HFOPreview;
	p_HFPreview = p_HFO->hfResize (100, 100);
	p_HFDPreview = new HeightFieldDraw (p_HFPreview, this->p_drawArea);
	p_HFDPreview->setMode ("0");
	p_HFDPreview->setColormap (cMap);
	p_HFOPreview = new HeightFieldOps (p_HFPreview);
	p_HFPreview->backup ();
	d_hfTimestamp = p_HF->getUpdateTime();
}


/* 
 * drawCrosshairs: draw horizonal/vertical crosshairs
 */
void TFPreviewDialog::drawCrosshairs (int cx, int cy)
{
	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFPreviewDialog::drawCrosshairs");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFDPreview==NULL", "TFPreviewDialog::drawCrosshairs");

	int		w = p_drawArea->width(),
			h = p_drawArea->height();

	this->p_drawArea->setColors (&(this->p_HFDPreview->getColormap()->d_black));
	this->p_drawArea->drawLine (cx, 0, cx, h);
	this->p_drawArea->drawLine (0, cy, w, cy);
	p_drawArea->sync ();
}


/* 
 * previewUpToDate(): check if the preview HF is current (ie: if the master 
 *	HF has not been updated)
 */
void TFPreviewDialog::previewUpToDate ()
{
	SanityCheck::bailout ((p_HF->getUpdateTime()<d_hfTimestamp), "p_HF->getUpdateTime()<d_hfTimestamp", "TFPreviewDialog::previewUpToDate");

	if (p_HF->getUpdateTime() == d_hfTimestamp)
		return;

	setHFobjs (p_HF, p_HFD);
}


/*
 *  (virtual) checkboxCallbackPreview: process the 'use preview' checkbox 
 */
void TFPreviewDialog::checkboxCallbackPreview ()
{
	if (!d_cbUsePreview.get_active())
		{
		p_HFPreview->restoreBackup ();
		p_HFDPreview->draw ();
		}
	else
		{
		SanityCheck::bailout ((!p_HFDPreview), "HFDPreview==NULL", 
				"GuiDialogPreview::checkboxCallbackPreview");
		p_drawArea->set_sensitive (TRUE);	
		updatePreviewCallback ();
		p_HFDPreview->draw ();
		if ( (d_cx != -1) && (d_cy != -1) )
			drawCrosshairs (d_cx, d_cy);
		}
}


