/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_GUI_H
#define _TF_GUI_H 1


#include "flexarray.h"
#include "HeightField.h"
#include "TFDialogMerge.h"
#include "TFWindowHandler.h"
#include "TFWindowMain.h"



/*
 *  TFGui: main gui routines for terraform. All this does is initialize 
 * 	MainWindow and spawn a new TFWindowHandler from setHeightField().
 * 
 * 	Everything here is static/global. The constructor contains a 
 * 	Sanity Check which makes sure we only have one copy of this class. 
 */
class TFGui 
	{
	public: 
					TFGui ();
					~TFGui ();
		static TFWindowHandler	*addHeightField (HeightField *HF);
		static void		addWindow (TFWindowHandler *TFWH);
		static char		*getNewName (char *name);
		static bool		isDuplicateName (char *name);
		static void		scheduleDelete (HeightField *HF);
		static int		cleanup ();
		static bool		allWindowsSaved ();
		static TFWindowHandler	*findTFWin (HeightField *HF);
		static TFDialogMerge	*getMergeDialog ();
		static FlexArray 	*getWindowList () { return s_windowList; }
		static TFWindowMain 	*getMainWindow () { return s_winMain; }

	private: 	
		static FlexArray		*s_windowList;	// array of TFWindows
		static FlexArray		*s_deleteList;	// array of HeightFields to be deleted
		static TFWindowMain		*s_winMain;
		static TFDialogMerge		*s_dlgMerge;
	};


#endif // _TF_GUI_H
