/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <time.h>
//#include <values.h>
#include "TFDialogGenSubdiv.h"
#include "HeightFieldGenSubdiv.h"
#include "MathRandom.h"
#include "TFGui.h"					// circular dependency
#include "TFOptions.h"
#include "TFWindowHandler.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "agename.h"


#if 0
// dummy table to trick xgettext into extracting the translatable strings
char *foobar[] = {
			N_("Diamond Square"),
			N_("Midpoint Subdivision"),
			N_("Offset Square"),
			N_("Recursive Subdivision"),
};
#endif




/*
 *  constructor: initialize all data members 
 */
TFDialogGenSubdiv::TFDialogGenSubdiv ()
	        : GuiDialogOAC ("Generation by Subdivision Dialog", 
				"Parameters"),
		  d_vbList (TRUE, 5),
		  d_hbMethod (TRUE, 5),
		  d_hbSize (TRUE, 5),
		  d_hbScaleFactor (TRUE, 5),
		  d_hbGenSeed (TRUE, 5),
		  d_hbSeed (TRUE, 5)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogGenSubdiv\n");

	p_seedInitStr = new char [40];
	reset ();

	p_glstMethod = NULL;
	d_mode = 0;

	p_cmbMethod = new  Gtk_Combo ();
	p_lblMethod = new Gtk_Label (_("Method to use"));
	p_lblSize = new Gtk_Label (_("Size"));
	p_lblScaleFactor = new Gtk_Label (_("Scale Factor"));
	p_lblGenSeed = new Gtk_Label (_("Generate new seed"));
	p_lblSeed = new Gtk_Label (_("Specify Seed"));
	p_adjScaleFactor = new Gtk_Adjustment (0.5, 0.01, 1, 0.01);
	p_adjSize = new Gtk_Adjustment (400, 10, (TFOptions::s_large ? 5000 : 1000), 1);
	p_hsScaleFactor = new Gtk_HScale (*p_adjScaleFactor);
	p_hsSize = new Gtk_HScale (*p_adjSize);

	buildDialogWindow ();
	connect_to_method (d_btnGenSeed.clicked, this, &TFDialogGenSubdiv::seedCheckboxCallback);
}



/*
 *  destructor: clean up, free allocated memory
 */
TFDialogGenSubdiv::~TFDialogGenSubdiv ()
{
	if (p_seedInitStr) delete p_seedInitStr;

	delete p_cmbMethod;
	delete p_lblMethod;
	delete p_lblSize;
	delete p_lblScaleFactor;
	delete p_lblGenSeed;
	delete p_lblSeed;
	delete p_adjScaleFactor;
	delete p_adjSize;
	delete p_hsScaleFactor;
	delete p_hsSize;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogGenSubdiv\n");
}


/*
 *  reset: clear p_tfWin so the next generate will register a new
 * 	window. Should be called before re-showing an existing dialog
 */
void TFDialogGenSubdiv::reset ()
{
	p_HF = NULL;
	p_tfWin = NULL;
	this->set_title (_("Generate Subdivision"));
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogGenSubdiv::fillVBox ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogGenSubdiv called without Frame label",
		"TFDialogGenSubdiv::fillVBox");

        d_hbMethod.pack_start (*p_lblMethod, TRUE, TRUE, s_HBOff);
        p_lblMethod->show ();

	// build Option Menu

	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_GEN_RECURSIVE)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_GEN_OFFSET)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_GEN_MIDPOINT)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_GEN_DIAMOND)));

	p_cmbMethod->set_popdown_strings (p_glstMethod);
	p_cmbMethod->get_entry()->set_text (_(MENU_GEN_RECURSIVE));
	p_cmbMethod->get_entry()->set_editable (FALSE);
	
	p_cmbMethod->show ();
        d_hbMethod.pack_start (*p_cmbMethod, TRUE, TRUE, s_HBOff);
	d_vbList.pack_start (d_hbMethod, TRUE, TRUE, s_VBOff);
	d_hbMethod.show ();

	// start actual generation parameters
        d_hbSize.pack_start (*p_lblSize, TRUE, TRUE, s_HBOff);
        p_lblSize->show ();
        p_hsSize->set_update_policy (GTK_UPDATE_DELAYED);
	p_hsSize->set_adjustment (*p_adjSize);
        p_hsSize->set_digits (0);
        p_hsSize->set_draw_value (TRUE);
        d_hbSize.pack_end (*p_hsSize, TRUE, TRUE, s_HBOff);
        p_hsSize->show ();
	d_vbList.pack_start (d_hbSize, TRUE, TRUE, s_VBOff);
	d_hbSize.show ();

        d_hbScaleFactor.pack_start (*p_lblScaleFactor, TRUE, TRUE, s_HBOff);
        p_lblScaleFactor->show ();
        p_hsScaleFactor->set_update_policy (GTK_UPDATE_DELAYED);
	p_hsScaleFactor->set_adjustment (*p_adjScaleFactor);
        p_hsScaleFactor->set_digits (2);
        p_hsScaleFactor->set_draw_value (TRUE);
        d_hbScaleFactor.pack_end (*p_hsScaleFactor, TRUE, TRUE, s_HBOff);
        p_hsScaleFactor->show ();
	d_vbList.pack_start (d_hbScaleFactor, TRUE, TRUE, s_VBOff);
	d_hbScaleFactor.show ();

	d_vbList.pack_start (d_sepMain, TRUE, TRUE, s_HBOff);
	d_sepMain.show ();

	// random seed parameters 
	d_hbGenSeed.pack_start (*p_lblGenSeed, TRUE, TRUE, s_HBOff);
	p_lblGenSeed->show ();
	d_hbGenSeed.pack_end (d_btnGenSeed, TRUE, TRUE, s_HBOff);
	d_btnGenSeed.set_active (TRUE);
	d_btnGenSeed.show ();
	d_vbList.pack_start (d_hbGenSeed, TRUE, TRUE, s_VBOff);
	d_hbGenSeed.show ();

	p_lblSeed->set_justify (GTK_JUSTIFY_RIGHT);
	d_hbSeed.pack_start (*p_lblSeed, TRUE, TRUE, s_HBOff);
	p_lblSeed->set_sensitive (FALSE);
	p_lblSeed->show ();

	MathRandom	*mRand = new MathRandom ();
	sprintf (p_seedInitStr, "%d", (int)mRand->rnd());
	delete mRand;
	d_enSeed.set_text (p_seedInitStr);
	d_enSeed.set_sensitive (FALSE);
	d_hbSeed.pack_end (d_enSeed, TRUE, TRUE, s_HBOff);
	d_enSeed.show ();
	d_vbList.pack_start (d_hbSeed, TRUE, TRUE, s_VBOff);
	d_hbSeed.show ();

	this->p_frmBase->add (d_vbList);
	d_vbList.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
	
}


/*
 *  buildDialogWindow:
 */
void TFDialogGenSubdiv::buildDialogWindow ()
{
	this->set_usize (300, 300);
	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	fillVBox ();
	fillActionArea ();

	this->show ();
}


void TFDialogGenSubdiv::seedCheckboxCallback ()
{
	bool		status=d_enSeed.is_sensitive ();

	p_lblSeed->set_sensitive (!status);
	d_enSeed.set_sensitive (!status);
}


void TFDialogGenSubdiv::buttonCallbackApply ()
{
	char			*s;
	int			size, seed;
	float			scaleFactor;
	string			entry;
	bool			HFisNew = FALSE;
	HeightFieldGenSubdiv	*HFGen;

	if (!p_HF)
		{
		p_HF = new HeightField ();
		HFisNew = TRUE;
		}
	HFGen = new HeightFieldGenSubdiv (p_HF);

	// get slider values
	size = (int)(p_adjSize->get_value());
	scaleFactor = p_adjScaleFactor->get_value();

	// either generate or read a random number seed
	if (d_btnGenSeed.get_active())
		{
		MathRandom	*mRand = new MathRandom ();

		seed = (int) (mRand->rnd()*G_MAXINT);
		sprintf (p_seedInitStr, "%d", seed);
		d_enSeed.set_text (p_seedInitStr);
		delete mRand;
		}
	else
		{
		s = const_cast<char*>(d_enSeed.get_text().c_str());
		seed = atoi (s);
		}

	SanityCheck::bailout ((!HFGen), "HFGen==NULL", "TFDialogGenSubdiv::buttonCallbackApply");

	entry = (p_cmbMethod->get_entry())->get_text();
	if (entry == _(MENU_GEN_DIAMOND))
		HFGen->generateDiamond (size, scaleFactor, seed);
	else
	if (entry == _(MENU_GEN_MIDPOINT))
		HFGen->generateMidpoint (size, scaleFactor, seed);
	else
	if (entry == _(MENU_GEN_OFFSET))
		HFGen->generateOffset (size, scaleFactor, seed);
	else
	if (entry == _(MENU_GEN_RECURSIVE))
		HFGen->generateRecursive (size, scaleFactor, seed);
	else
		SanityCheck::bailout ((TRUE), "uncaught RadioMenuItem", "TFDialogGenSubdiv::buttonApplyCallback");

	delete HFGen;
	HFGen = NULL;

	if (HFisNew)
		{
		p_tfWin = TFGui::addHeightField (p_HF);
		this->set_title (p_HF->getName());
		}
	else
		p_tfWin->drawHeightField ();

	this->b_applyHit = TRUE;
}


gint TFDialogGenSubdiv::delete_event_impl (GdkEventAny *e)
{
	this->hide ();
	return (0);
}


